/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.bootstrap;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.util.StatusPrinter;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.logging.LogLevelModifierTurboFilter;
import com.hivemq.logging.modifier.NettyLogLevelModifier;
import com.hivemq.logging.modifier.XodusEnvironmentImplLogLevelModifier;
import com.hivemq.logging.modifier.XodusFileDataWriterLogLevelModifier;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class LoggingBootstrap {
    private static final Logger log = LoggerFactory.getLogger(LoggingBootstrap.class);
    @NotNull
    private static final ListAppender<ILoggingEvent> LIST_APPENDER = new ListAppender();
    @NotNull
    private static final List<Appender<ILoggingEvent>> DEFAULT_APPENDERS = new LinkedList<Appender<ILoggingEvent>>();
    @NotNull
    private static final LogLevelModifierTurboFilter LOG_LEVEL_MODIFIER_TURBO_FILTER = new LogLevelModifierTurboFilter();
    @NotNull
    private static final LogbackChangeListener LOGBACK_CHANGE_LISTENER = new LogbackChangeListener();

    public static void prepareLogging() {
        ch.qos.logback.classic.Logger logger = LoggingBootstrap.getRootLogger();
        Iterator iterator = logger.iteratorForAppenders();
        while (iterator.hasNext()) {
            Appender next = (Appender)iterator.next();
            logger.detachAppender(next);
            DEFAULT_APPENDERS.add((Appender<ILoggingEvent>)next);
        }
        LIST_APPENDER.start();
        logger.addAppender(LIST_APPENDER);
    }

    public static void initLogging(@NotNull File configFolder) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.addListener((LoggerContextListener)LOGBACK_CHANGE_LISTENER);
        boolean overridden = LoggingBootstrap.tryToOverrideLogbackXml(configFolder);
        if (!overridden) {
            LoggingBootstrap.reEnableDefaultAppenders();
            context.addTurboFilter((TurboFilter)LOG_LEVEL_MODIFIER_TURBO_FILTER);
            LoggingBootstrap.logQueuedEntries();
        }
        LoggingBootstrap.redirectJULToSLF4J();
        LoggingBootstrap.reset();
        if (SystemUtils.IS_OS_WINDOWS) {
            LOG_LEVEL_MODIFIER_TURBO_FILTER.registerLogLevelModifier(new XodusFileDataWriterLogLevelModifier());
            log.trace("Added Xodus log level modifier for FileDataWriter.class");
        }
        LOG_LEVEL_MODIFIER_TURBO_FILTER.registerLogLevelModifier(new NettyLogLevelModifier());
        log.trace("Added Netty log level modifier");
    }

    public static void resetLogging() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.getTurboFilterList().remove((Object)LOG_LEVEL_MODIFIER_TURBO_FILTER);
        context.removeListener((LoggerContextListener)LOGBACK_CHANGE_LISTENER);
    }

    private static void reEnableDefaultAppenders() {
        ch.qos.logback.classic.Logger logger = LoggingBootstrap.getRootLogger();
        for (Appender<ILoggingEvent> defaultAppender : DEFAULT_APPENDERS) {
            logger.addAppender(defaultAppender);
        }
    }

    private static void logQueuedEntries() {
        ch.qos.logback.classic.Logger logger = LoggingBootstrap.getRootLogger();
        LIST_APPENDER.stop();
        logger.detachAppender(LIST_APPENDER);
        for (ILoggingEvent loggingEvent : LoggingBootstrap.LIST_APPENDER.list) {
            logger.callAppenders(loggingEvent);
        }
        LoggingBootstrap.LIST_APPENDER.list.clear();
    }

    @NotNull
    private static ch.qos.logback.classic.Logger getRootLogger() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        return context.getLogger("ROOT");
    }

    private static void redirectJULToSLF4J() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tryToOverrideLogbackXml(@NotNull File configFolder) {
        File file = new File(configFolder, "logback.xml");
        if (file.canRead()) {
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            try {
                context.reset();
                JoranConfigurator configurator = new JoranConfigurator();
                configurator.setContext((Context)context);
                configurator.doConfigure(file);
                LoggingBootstrap.logQueuedEntries();
                log.info("Log Configuration was overridden by {}", (Object)file.getAbsolutePath());
                boolean bl = true;
                return bl;
            }
            catch (JoranException je) {
                log.warn("A configurator exception was thrown while attempting to configure Logback. Using HiveMQ default logging configuration.");
            }
            catch (Exception ex) {
                log.warn("An exception was thrown while attempting to configure Logback. Using HiveMQ default logging configuration.");
                ex.printStackTrace();
            }
            finally {
                StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
            }
        } else {
            log.warn("The logging configuration file {} cannot be read or does not exist. Using HiveMQ default logging configuration.", (Object)file.getAbsolutePath());
        }
        return false;
    }

    public static void addLoglevelModifiers() {
        LOG_LEVEL_MODIFIER_TURBO_FILTER.registerLogLevelModifier(new XodusEnvironmentImplLogLevelModifier());
        log.trace("Added Xodus log level modifier for EnvironmentImpl.class");
    }

    private static void reset() {
        DEFAULT_APPENDERS.clear();
        LoggingBootstrap.LIST_APPENDER.list.clear();
    }

    private static final class LogbackChangeListener
    implements LoggerContextListener {
        private LogbackChangeListener() {
        }

        public boolean isResetResistant() {
            return true;
        }

        public void onStart(@NotNull LoggerContext context) {
        }

        public void onReset(@NotNull LoggerContext context) {
            log.trace("logback.xml was changed");
            context.addTurboFilter((TurboFilter)LOG_LEVEL_MODIFIER_TURBO_FILTER);
        }

        public void onStop(@NotNull LoggerContext context) {
        }

        public void onLevelChange(@NotNull ch.qos.logback.classic.Logger logger, @NotNull Level level) {
        }
    }
}

