/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.bootstrap.netty.initializer;

import com.hivemq.bootstrap.netty.ChannelDependencies;
import com.hivemq.bootstrap.netty.initializer.AbstractChannelInitializer;
import com.hivemq.configuration.service.entity.Tls;
import com.hivemq.configuration.service.entity.TlsListener;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.handler.connect.NoTlsHandshakeIdleHandler;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.security.exception.SslException;
import com.hivemq.security.ssl.SslClientCertificateHandler;
import com.hivemq.security.ssl.SslExceptionHandler;
import com.hivemq.security.ssl.SslFactory;
import com.hivemq.security.ssl.SslSniHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;

public abstract class AbstractTlsChannelInitializer
extends AbstractChannelInitializer {
    @NotNull
    private final TlsListener tlsListener;
    @NotNull
    private final SslFactory sslFactory;
    @NotNull
    private final ChannelDependencies channelDependencies;

    public AbstractTlsChannelInitializer(@NotNull ChannelDependencies channelDependencies, @NotNull TlsListener tlsListener, @NotNull SslFactory sslFactory) {
        super(channelDependencies, tlsListener);
        this.tlsListener = tlsListener;
        this.sslFactory = sslFactory;
        this.channelDependencies = channelDependencies;
    }

    @Override
    protected void addNoConnectIdleHandler(@NotNull Channel ch) {
    }

    protected void addNoConnectIdleHandlerAfterTlsHandshake(@NotNull Channel ch) {
        super.addNoConnectIdleHandler(ch);
    }

    @Override
    protected void addSpecialHandlers(@NotNull Channel ch) throws SslException {
        int handshakeTimeout = this.tlsListener.getTls().getHandshakeTimeout();
        IdleStateHandler idleStateHandler = new IdleStateHandler((long)handshakeTimeout, 0L, 0L, TimeUnit.MILLISECONDS);
        MqttServerDisconnector mqttServerDisconnector = this.channelDependencies.getMqttServerDisconnector();
        NoTlsHandshakeIdleHandler noTlsHandshakeIdleHandler = new NoTlsHandshakeIdleHandler(mqttServerDisconnector);
        if (handshakeTimeout > 0) {
            ch.pipeline().addLast("new_connection_idle_handler", (ChannelHandler)idleStateHandler);
            ch.pipeline().addLast("no_tls_handshake_idle_event_handler", (ChannelHandler)noTlsHandshakeIdleHandler);
        }
        Tls tls = this.tlsListener.getTls();
        SslContext sslContext = this.sslFactory.getSslContext(tls);
        SslHandler sslHandler = this.sslFactory.getSslHandler(ch, tls, sslContext);
        sslHandler.handshakeFuture().addListener(future -> {
            if (handshakeTimeout > 0) {
                ch.pipeline().remove((ChannelHandler)idleStateHandler);
                ch.pipeline().remove((ChannelHandler)noTlsHandshakeIdleHandler);
            }
            this.addNoConnectIdleHandlerAfterTlsHandshake(ch);
        });
        ch.pipeline().addFirst("ssl_handler", (ChannelHandler)new SslSniHandler(sslHandler, sslContext));
        ch.pipeline().addAfter("ssl_handler", "ssl_exception_handler", (ChannelHandler)new SslExceptionHandler(mqttServerDisconnector));
        ch.pipeline().addAfter("ssl_exception_handler", "ssl_parameter_handler", (ChannelHandler)this.channelDependencies.getSslParameterHandler());
        if (!Tls.ClientAuthMode.NONE.equals((Object)tls.getClientAuthMode())) {
            ch.pipeline().addAfter("ssl_parameter_handler", "ssl_client_certificate_handler", (ChannelHandler)new SslClientCertificateHandler(tls, mqttServerDisconnector));
        }
    }
}

