/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder;

import com.google.inject.Inject;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.codec.decoder.MqttDecoder;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.PINGREQ;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import io.netty.buffer.ByteBuf;

@LazySingleton
public class MqttPingreqDecoder
extends MqttDecoder<PINGREQ> {
    @NotNull
    private final MqttServerDisconnector serverDisconnector;

    @Inject
    public MqttPingreqDecoder(@NotNull MqttServerDisconnector serverDisconnector) {
        this.serverDisconnector = serverDisconnector;
    }

    @Override
    @Nullable
    public PINGREQ decode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte header) {
        ProtocolVersion protocolVersion = clientConnectionContext.getProtocolVersion();
        if (!(protocolVersion != ProtocolVersion.MQTTv5 && protocolVersion != ProtocolVersion.MQTTv3_1_1 || this.validateHeader(header))) {
            this.serverDisconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a PINGREQ with an invalid fixed header. Disconnecting client.", "Sent a PINGREQ with invalid fixed header", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, String.format("%s with incorrect fixed header was sent.", "PINGREQ"));
            buf.clear();
            return null;
        }
        return PINGREQ.INSTANCE;
    }
}

