/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder.mqtt5;

import com.google.common.collect.ImmutableList;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.codec.decoder.AbstractMqttDecoder;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import com.hivemq.mqtt.message.pubrec.Mqtt5PUBREC;
import com.hivemq.mqtt.message.pubrec.PUBREC;
import com.hivemq.mqtt.message.reason.Mqtt5PubRecReasonCode;
import io.netty.buffer.ByteBuf;
import javax.inject.Inject;

@LazySingleton
public class Mqtt5PubrecDecoder
extends AbstractMqttDecoder<PUBREC> {
    @Inject
    public Mqtt5PubrecDecoder(@NotNull MqttServerDisconnector disconnector, @NotNull FullConfigurationService configurationService) {
        super(disconnector, configurationService);
    }

    @Override
    @Nullable
    public PUBREC decode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte header) {
        if (!this.validateHeader(header)) {
            this.disconnectByInvalidFixedHeader(clientConnectionContext, MessageType.PUBREC);
            return null;
        }
        if (buf.readableBytes() < 2) {
            this.disconnectByRemainingLengthToShort(clientConnectionContext, MessageType.PUBREC);
            return null;
        }
        int packetIdentifier = this.decodePacketIdentifier(clientConnectionContext, buf, MessageType.PUBREC);
        if (packetIdentifier == 0) {
            return null;
        }
        if (!buf.isReadable()) {
            return new PUBREC(packetIdentifier, Mqtt5PUBREC.DEFAULT_REASON_CODE, null, Mqtt5UserProperties.NO_USER_PROPERTIES);
        }
        Mqtt5PubRecReasonCode reasonCode = Mqtt5PubRecReasonCode.fromCode(buf.readUnsignedByte());
        if (reasonCode == null) {
            this.disconnectByInvalidReasonCode(clientConnectionContext, MessageType.PUBREC);
            return null;
        }
        if (!buf.isReadable()) {
            return new PUBREC(packetIdentifier, reasonCode, null, Mqtt5UserProperties.NO_USER_PROPERTIES);
        }
        int propertiesLength = this.decodePropertiesLengthNoPayload(clientConnectionContext, buf, MessageType.PUBREC);
        if (propertiesLength == -1) {
            return null;
        }
        String reasonString = null;
        ImmutableList.Builder<MqttUserProperty> userPropertiesBuilder = null;
        block4: while (buf.isReadable()) {
            byte propertyIdentifier = buf.readByte();
            switch (propertyIdentifier) {
                case 31: {
                    if ((reasonString = this.decodeReasonString(clientConnectionContext, buf, reasonString, MessageType.PUBREC)) != null) continue block4;
                    return null;
                }
                case 38: {
                    if ((userPropertiesBuilder = this.readUserProperty(clientConnectionContext, buf, userPropertiesBuilder, MessageType.PUBREC)) != null) continue block4;
                    return null;
                }
            }
            this.disconnectByInvalidPropertyIdentifier(clientConnectionContext, propertyIdentifier, MessageType.PUBREC);
            return null;
        }
        Mqtt5UserProperties userProperties = Mqtt5UserProperties.build(userPropertiesBuilder);
        if (this.invalidUserPropertiesLength(clientConnectionContext, MessageType.PUBREC, userProperties)) {
            return null;
        }
        return new PUBREC(packetIdentifier, reasonCode, reasonString, userProperties);
    }
}

