/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder.mqtt5;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.codec.decoder.AbstractMqttDecoder;
import com.hivemq.codec.encoder.mqtt5.MqttVariableByteInteger;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.mqtt5.Mqtt5RetainHandling;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import com.hivemq.mqtt.message.subscribe.SUBSCRIBE;
import com.hivemq.mqtt.message.subscribe.Topic;
import com.hivemq.util.Bytes;
import com.hivemq.util.Topics;
import io.netty.buffer.ByteBuf;
import java.util.Objects;

@LazySingleton
public class Mqtt5SubscribeDecoder
extends AbstractMqttDecoder<SUBSCRIBE> {
    @Inject
    public Mqtt5SubscribeDecoder(@NotNull MqttServerDisconnector disconnector, @NotNull FullConfigurationService configurationService) {
        super(disconnector, configurationService);
    }

    @Override
    @Nullable
    public SUBSCRIBE decode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte header) {
        int readPropertyLength;
        if ((header & 0xF) != 2) {
            this.disconnectByInvalidFixedHeader(clientConnectionContext, MessageType.SUBSCRIBE);
            return null;
        }
        if (buf.readableBytes() < 2) {
            this.disconnectByRemainingLengthToShort(clientConnectionContext, MessageType.SUBSCRIBE);
            return null;
        }
        int packetIdentifier = this.decodePacketIdentifier(clientConnectionContext, buf);
        if (packetIdentifier == 0) {
            return null;
        }
        int propertiesLength = MqttVariableByteInteger.decode(buf);
        if (this.propertiesLengthInvalid(clientConnectionContext, buf, propertiesLength)) {
            return null;
        }
        int subscriptionIdentifier = -1;
        ImmutableList.Builder<MqttUserProperty> userPropertiesBuilder = null;
        int propertiesStartIndex = buf.readerIndex();
        block4: while ((readPropertyLength = buf.readerIndex() - propertiesStartIndex) < propertiesLength) {
            byte propertyIdentifier = buf.readByte();
            switch (propertyIdentifier) {
                case 38: {
                    if ((userPropertiesBuilder = this.readUserProperty(clientConnectionContext, buf, userPropertiesBuilder, MessageType.SUBSCRIBE)) != null) continue block4;
                    return null;
                }
                case 11: {
                    if ((subscriptionIdentifier = this.readSubscriptionIdentifier(clientConnectionContext, buf, subscriptionIdentifier)) != -1) continue block4;
                    return null;
                }
            }
            this.disconnectByInvalidPropertyIdentifier(clientConnectionContext, propertyIdentifier, MessageType.SUBSCRIBE);
            return null;
        }
        if (readPropertyLength != propertiesLength) {
            this.disconnectByMalformedPropertyLength(clientConnectionContext, MessageType.SUBSCRIBE);
            return null;
        }
        if (!buf.isReadable()) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a SUBSCRIBE which didn't contain any subscription. This is not allowed. Disconnecting client.", "Sent a SUBSCRIBE without any subscriptions", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "SUBSCRIBE with zero subscriptions was sent.");
            return null;
        }
        ImmutableList.Builder<Topic> topicBuilder = null;
        while (buf.isReadable()) {
            if ((topicBuilder = this.decodeTopic(clientConnectionContext, buf, topicBuilder, subscriptionIdentifier)) != null) continue;
            return null;
        }
        Mqtt5UserProperties userProperties = Mqtt5UserProperties.build(userPropertiesBuilder);
        if (this.invalidUserPropertiesLength(clientConnectionContext, MessageType.SUBSCRIBE, userProperties)) {
            return null;
        }
        return new SUBSCRIBE(userProperties, (ImmutableList<Topic>)Objects.requireNonNull(topicBuilder).build(), packetIdentifier, subscriptionIdentifier);
    }

    @Nullable
    private ImmutableList.Builder<Topic> decodeTopic(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @Nullable ImmutableList.Builder<Topic> topicBuilder, @NotNull Integer subscriptionIdentifier) {
        String topicFilter = this.decodeUTF8Topic(clientConnectionContext, buf, "topic filter", MessageType.SUBSCRIBE);
        if (topicFilter == null) {
            return null;
        }
        if (buf.readableBytes() == 0) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a SUBSCRIBE without subscription options. Disconnecting client.", "Sent a SUBSCRIBE without subscription options", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "SUBSCRIBE with no subscription options was sent. This is a protocol violation.");
            return null;
        }
        byte subscriptionOptions = buf.readByte();
        if (Bytes.isBitSet(subscriptionOptions, 6) || Bytes.isBitSet(subscriptionOptions, 7)) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a SUBSCRIBE with malformed subscription options. Disconnecting client.", "Sent a SUBSCRIBE with malformed subscription options", Mqtt5DisconnectReasonCode.MALFORMED_PACKET, "SUBSCRIBE with malformed subscription options was sent.");
            return null;
        }
        int qoS = this.decodeQoS(clientConnectionContext, subscriptionOptions);
        if (qoS == -1) {
            return null;
        }
        boolean noLocal = Bytes.isBitSet(subscriptionOptions, 2);
        if (noLocal && Topics.isSharedSubscriptionTopic(topicFilter)) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent SUBSCRIBE with a shared subscription and no local set to true. This is not allowed. Disconnecting client.", "Sent a SUBSCRIBE with a shared subscription and no local set to true", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "SUBSCRIBE with a shared subscription and the no local flag set to true was sent. This is a protocol violation.");
            return null;
        }
        boolean retainAsPublished = Bytes.isBitSet(subscriptionOptions, 3);
        Mqtt5RetainHandling retainHandling = this.decodeRetainHandling(clientConnectionContext, subscriptionOptions);
        if (retainHandling == null) {
            return null;
        }
        if (topicBuilder == null) {
            topicBuilder = new ImmutableList.Builder();
        }
        if (subscriptionIdentifier == -1) {
            subscriptionIdentifier = null;
        }
        return topicBuilder.add((Object)new Topic(topicFilter, QoS.valueOf(qoS), noLocal, retainAsPublished, retainHandling, subscriptionIdentifier));
    }

    private int readSubscriptionIdentifier(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, int subscriptionIdentifier) {
        if (!this.subscriptionIdentifiersAvailable) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a SUBSCRIBE with a subscription identifier. Subscription identifiers are disabled. Disconnecting client.", "Sent a SUBSCRIBE with a subscription identifier", Mqtt5DisconnectReasonCode.SUBSCRIPTION_IDENTIFIERS_NOT_SUPPORTED, "Disconnecting client. SUBSCRIBE containing subscription identifiers was sent. The broker does not allow this.");
            return -1;
        }
        if (subscriptionIdentifier != -1) {
            this.disconnectByMoreThanOnce(clientConnectionContext, "subscription identifier", MessageType.SUBSCRIBE);
            return -1;
        }
        subscriptionIdentifier = MqttVariableByteInteger.decode(buf);
        if (subscriptionIdentifier == 0) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a SUBSCRIBE with subscription identifier = '0'. This is not allowed. Disconnecting client.", "Sent a SUBSCRIBE with subscription identifier = '0'", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "SUBSCRIBE with a subscription identifier of '0' was sent. This is a protocol violation.");
            return -1;
        }
        return subscriptionIdentifier;
    }

    private int decodePacketIdentifier(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf) {
        int packetIdentifier = buf.readUnsignedShort();
        if (packetIdentifier == 0) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a SUBSCRIBE with message id = '0'. This is not allowed. Disconnecting client.", "Sent a SUBSCRIBE with message id = '0'", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "SUBSCRIBE with a packet identifier of '0' was sent. This is a protocol violation.");
        }
        return packetIdentifier;
    }

    private boolean propertiesLengthInvalid(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, int propertyLength) {
        if (propertyLength < 0) {
            this.disconnectByMalformedPropertyLength(clientConnectionContext, MessageType.SUBSCRIBE);
            return true;
        }
        if (buf.readableBytes() < propertyLength) {
            this.disconnectByRemainingLengthToShort(clientConnectionContext, MessageType.SUBSCRIBE);
            return true;
        }
        return false;
    }

    private int decodeQoS(@NotNull ClientConnectionContext clientConnectionContext, byte flags) {
        int qos = flags & 3;
        if (qos == 3) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a SUBSCRIBE with invalid qos '3'. This is not allowed. Disconnecting client.", "Invalid SUBSCRIBE with invalid qos '3'", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "SUBSCRIBE with a quality of service level set to '3' was sent. This is a protocol violation.");
            return -1;
        }
        return qos;
    }

    private Mqtt5RetainHandling decodeRetainHandling(@NotNull ClientConnectionContext clientConnectionContext, byte flags) {
        int code = (flags & 0x30) >> 4;
        if (code == 3) {
            this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a SUBSCRIBE with invalid retain handling = '3'. This is not allowed. Disconnecting client.", "Invalid SUBSCRIBE with retain handling = '3'", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "SUBSCRIBE with retain handling set to '3' was sent. This is a protocol violation.");
            return null;
        }
        return Mqtt5RetainHandling.fromCode(code);
    }
}

