/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.encoder;

import com.google.inject.Inject;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.codec.encoder.MqttEncoder;
import com.hivemq.codec.encoder.MqttPingrespEncoder;
import com.hivemq.codec.encoder.mqtt3.Mqtt3ConnackEncoder;
import com.hivemq.codec.encoder.mqtt3.Mqtt3DisconnectEncoder;
import com.hivemq.codec.encoder.mqtt3.Mqtt3PubackEncoder;
import com.hivemq.codec.encoder.mqtt3.Mqtt3PubcompEncoder;
import com.hivemq.codec.encoder.mqtt3.Mqtt3PublishEncoder;
import com.hivemq.codec.encoder.mqtt3.Mqtt3PubrecEncoder;
import com.hivemq.codec.encoder.mqtt3.Mqtt3PubrelEncoder;
import com.hivemq.codec.encoder.mqtt3.Mqtt3SubackEncoder;
import com.hivemq.codec.encoder.mqtt3.Mqtt3UnsubackEncoder;
import com.hivemq.codec.encoder.mqtt5.Mqtt5AuthEncoder;
import com.hivemq.codec.encoder.mqtt5.Mqtt5ConnackEncoder;
import com.hivemq.codec.encoder.mqtt5.Mqtt5DisconnectEncoder;
import com.hivemq.codec.encoder.mqtt5.Mqtt5PubCompEncoder;
import com.hivemq.codec.encoder.mqtt5.Mqtt5PubackEncoder;
import com.hivemq.codec.encoder.mqtt5.Mqtt5PublishEncoder;
import com.hivemq.codec.encoder.mqtt5.Mqtt5PubrecEncoder;
import com.hivemq.codec.encoder.mqtt5.Mqtt5PubrelEncoder;
import com.hivemq.codec.encoder.mqtt5.Mqtt5SubackEncoder;
import com.hivemq.codec.encoder.mqtt5.Mqtt5UnsubackEncoder;
import com.hivemq.configuration.service.SecurityConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.Message;
import com.hivemq.mqtt.message.PINGRESP;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.mqtt.message.auth.AUTH;
import com.hivemq.mqtt.message.connack.CONNACK;
import com.hivemq.mqtt.message.disconnect.DISCONNECT;
import com.hivemq.mqtt.message.dropping.MessageDroppedService;
import com.hivemq.mqtt.message.puback.PUBACK;
import com.hivemq.mqtt.message.pubcomp.PUBCOMP;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.message.pubrec.PUBREC;
import com.hivemq.mqtt.message.pubrel.PUBREL;
import com.hivemq.mqtt.message.suback.SUBACK;
import com.hivemq.mqtt.message.unsuback.UNSUBACK;
import io.netty.buffer.ByteBuf;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EncoderFactory {
    private static final Logger log = LoggerFactory.getLogger(EncoderFactory.class);
    @NotNull
    private final Mqtt5EncoderFactory mqtt5Instance;
    @NotNull
    private final Mqtt3EncoderFactory mqtt3Instance;

    @Inject
    public EncoderFactory(@NotNull MessageDroppedService messageDroppedService, @NotNull SecurityConfigurationService securityConfigurationService, @NotNull MqttServerDisconnector mqttServerDisconnector) {
        this.mqtt5Instance = new Mqtt5EncoderFactory(messageDroppedService, securityConfigurationService);
        this.mqtt3Instance = new Mqtt3EncoderFactory(mqttServerDisconnector);
    }

    public void encode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull Message msg, @NotNull ByteBuf out) {
        MqttEncoder encoder = this.getEncoder(msg, clientConnectionContext);
        if (encoder != null) {
            encoder.encode(clientConnectionContext, msg, out);
        } else {
            log.error("No encoder found for msg: {} ", (Object)msg.getType());
        }
    }

    @Nullable
    protected MqttEncoder getEncoder(@NotNull Message msg, @NotNull ClientConnectionContext clientConnectionContext) {
        if (clientConnectionContext.getProtocolVersion() == ProtocolVersion.MQTTv5) {
            return this.mqtt5Instance.getEncoder(msg);
        }
        return this.mqtt3Instance.getEncoder(msg);
    }

    @NotNull
    protected ByteBuf allocateBuffer(@NotNull ClientConnectionContext clientConnectionContext, @NotNull Message msg, boolean preferDirect) {
        MqttEncoder encoder = this.getEncoder(msg, clientConnectionContext);
        if (encoder != null) {
            int bufferSize = encoder.bufferSize(clientConnectionContext, msg);
            if (preferDirect) {
                return clientConnectionContext.getChannel().alloc().ioBuffer(bufferSize);
            }
            return clientConnectionContext.getChannel().alloc().heapBuffer(bufferSize);
        }
        if (preferDirect) {
            return clientConnectionContext.getChannel().alloc().ioBuffer();
        }
        return clientConnectionContext.getChannel().alloc().heapBuffer();
    }

    private static class Mqtt3EncoderFactory {
        @NotNull
        private final Mqtt3ConnackEncoder connackEncoder = new Mqtt3ConnackEncoder();
        @NotNull
        private final Mqtt3PubackEncoder pubackEncoder = new Mqtt3PubackEncoder();
        @NotNull
        private final Mqtt3PubrecEncoder pubrecEncoder = new Mqtt3PubrecEncoder();
        @NotNull
        private final Mqtt3PubrelEncoder pubrelEncoder = new Mqtt3PubrelEncoder();
        @NotNull
        private final Mqtt3PubcompEncoder pubcompEncoder = new Mqtt3PubcompEncoder();
        @NotNull
        private final Mqtt3SubackEncoder subackEncoder;
        @NotNull
        private final Mqtt3UnsubackEncoder unsubackEncoder;
        @NotNull
        private final Mqtt3PublishEncoder publishEncoder;
        @NotNull
        private final Mqtt3DisconnectEncoder disconnectEncoder;
        @NotNull
        private final MqttPingrespEncoder pingrespEncoder;

        Mqtt3EncoderFactory(@NotNull MqttServerDisconnector mqttServerDisconnector) {
            this.subackEncoder = new Mqtt3SubackEncoder(mqttServerDisconnector);
            this.unsubackEncoder = new Mqtt3UnsubackEncoder();
            this.publishEncoder = new Mqtt3PublishEncoder();
            this.disconnectEncoder = new Mqtt3DisconnectEncoder();
            this.pingrespEncoder = new MqttPingrespEncoder();
        }

        @Nullable
        private MqttEncoder getEncoder(@NotNull Message msg) {
            if (msg instanceof PUBLISH) {
                return this.publishEncoder;
            }
            if (msg instanceof PINGRESP) {
                return this.pingrespEncoder;
            }
            if (msg instanceof PUBACK) {
                return this.pubackEncoder;
            }
            if (msg instanceof PUBREC) {
                return this.pubrecEncoder;
            }
            if (msg instanceof PUBREL) {
                return this.pubrelEncoder;
            }
            if (msg instanceof PUBCOMP) {
                return this.pubcompEncoder;
            }
            if (msg instanceof CONNACK) {
                return this.connackEncoder;
            }
            if (msg instanceof SUBACK) {
                return this.subackEncoder;
            }
            if (msg instanceof UNSUBACK) {
                return this.unsubackEncoder;
            }
            if (msg instanceof DISCONNECT) {
                return this.disconnectEncoder;
            }
            return null;
        }
    }

    private static class Mqtt5EncoderFactory {
        @NotNull
        private final Mqtt5PublishEncoder mqtt5PublishEncoder;
        @NotNull
        private final Mqtt5DisconnectEncoder mqtt5DisconnectEncoder;
        @NotNull
        private final Mqtt5SubackEncoder mqtt5SubackEncoder;
        @NotNull
        private final Mqtt5ConnackEncoder mqtt5ConnackEncoder;
        @NotNull
        private final Mqtt5PubackEncoder mqtt5PubackEncoder;
        @NotNull
        private final Mqtt5PubrecEncoder mqtt5PubrecEncoder;
        @NotNull
        private final Mqtt5PubrelEncoder mqtt5PubrelEncoder;
        @NotNull
        private final Mqtt5PubCompEncoder mqtt5PubCompEncoder;
        @NotNull
        private final Mqtt5AuthEncoder mqtt5AuthEncoder;
        @NotNull
        private final Mqtt5UnsubackEncoder mqtt5UnsubackEncoder;
        @NotNull
        private final MqttPingrespEncoder mqttPingrespEncoder;

        Mqtt5EncoderFactory(@NotNull MessageDroppedService messageDroppedService, @NotNull SecurityConfigurationService securityConfigurationService) {
            this.mqtt5PublishEncoder = new Mqtt5PublishEncoder(messageDroppedService, securityConfigurationService);
            this.mqtt5DisconnectEncoder = new Mqtt5DisconnectEncoder(messageDroppedService, securityConfigurationService);
            this.mqtt5SubackEncoder = new Mqtt5SubackEncoder(messageDroppedService, securityConfigurationService);
            this.mqtt5ConnackEncoder = new Mqtt5ConnackEncoder(messageDroppedService, securityConfigurationService);
            this.mqtt5PubackEncoder = new Mqtt5PubackEncoder(messageDroppedService, securityConfigurationService);
            this.mqtt5PubrecEncoder = new Mqtt5PubrecEncoder(messageDroppedService, securityConfigurationService);
            this.mqtt5PubrelEncoder = new Mqtt5PubrelEncoder(messageDroppedService, securityConfigurationService);
            this.mqtt5PubCompEncoder = new Mqtt5PubCompEncoder(messageDroppedService, securityConfigurationService);
            this.mqtt5AuthEncoder = new Mqtt5AuthEncoder(messageDroppedService, securityConfigurationService);
            this.mqtt5UnsubackEncoder = new Mqtt5UnsubackEncoder(messageDroppedService, securityConfigurationService);
            this.mqttPingrespEncoder = new MqttPingrespEncoder();
        }

        @Nullable
        private MqttEncoder getEncoder(@NotNull Message msg) {
            if (msg instanceof PUBLISH) {
                return this.mqtt5PublishEncoder;
            }
            if (msg instanceof PINGRESP) {
                return this.mqttPingrespEncoder;
            }
            if (msg instanceof PUBACK) {
                return this.mqtt5PubackEncoder;
            }
            if (msg instanceof PUBREC) {
                return this.mqtt5PubrecEncoder;
            }
            if (msg instanceof PUBREL) {
                return this.mqtt5PubrelEncoder;
            }
            if (msg instanceof PUBCOMP) {
                return this.mqtt5PubCompEncoder;
            }
            if (msg instanceof CONNACK) {
                return this.mqtt5ConnackEncoder;
            }
            if (msg instanceof SUBACK) {
                return this.mqtt5SubackEncoder;
            }
            if (msg instanceof UNSUBACK) {
                return this.mqtt5UnsubackEncoder;
            }
            if (msg instanceof DISCONNECT) {
                return this.mqtt5DisconnectEncoder;
            }
            if (msg instanceof AUTH) {
                return this.mqtt5AuthEncoder;
            }
            return null;
        }
    }
}

