/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.encoder.mqtt5;

import com.google.common.base.Preconditions;
import com.hivemq.codec.encoder.mqtt5.Mqtt5MessageWithUserPropertiesEncoder;
import com.hivemq.codec.encoder.mqtt5.MqttVariableByteInteger;
import com.hivemq.configuration.service.SecurityConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.dropping.MessageDroppedService;
import com.hivemq.mqtt.message.reason.Mqtt5SubAckReasonCode;
import com.hivemq.mqtt.message.suback.SUBACK;
import io.netty.buffer.ByteBuf;
import javax.inject.Singleton;

@Singleton
public class Mqtt5SubackEncoder
extends Mqtt5MessageWithUserPropertiesEncoder.Mqtt5MessageWithReasonStringEncoder<SUBACK> {
    private static final int FIXED_HEADER = MessageType.SUBACK.ordinal() << 4;

    public Mqtt5SubackEncoder(@NotNull MessageDroppedService messageDroppedService, @NotNull SecurityConfigurationService securityConfigurationService) {
        super(messageDroppedService, securityConfigurationService);
    }

    @Override
    void encode(@NotNull SUBACK suback, @NotNull ByteBuf out) {
        Preconditions.checkNotNull((Object)suback, (Object)"Suback must not be null.");
        Preconditions.checkNotNull((Object)out, (Object)"ByteBuf must not be null.");
        Mqtt5SubackEncoder.encodeFixedHeader(out, suback.getRemainingLength());
        this.encodeVariableHeader(suback, out);
        Mqtt5SubackEncoder.encodePayload(suback, out);
    }

    @Override
    int calculateRemainingLengthWithoutProperties(@NotNull SUBACK message) {
        return message.getReasonCodes().size() + 2;
    }

    @Override
    int calculatePropertyLength(@NotNull SUBACK message) {
        return this.omissiblePropertiesLength(message);
    }

    private void encodeVariableHeader(@NotNull SUBACK message, ByteBuf out) {
        out.writeShort(message.getPacketIdentifier());
        MqttVariableByteInteger.encode(message.getPropertyLength(), out);
        this.encodeOmissibleProperties(message, out);
    }

    private static void encodeFixedHeader(@NotNull ByteBuf out, int remainingLength) {
        out.writeByte(FIXED_HEADER);
        MqttVariableByteInteger.encode(remainingLength, out);
    }

    private static void encodePayload(@NotNull SUBACK message, @NotNull ByteBuf out) {
        for (Mqtt5SubAckReasonCode mqtt5SubAckReasonCode : message.getReasonCodes()) {
            out.writeByte(mqtt5SubAckReasonCode.getCode());
        }
    }
}

