/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.encoder.mqtt5;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.util.Utf8Utils;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public final class MqttBinaryData {
    private static final int MAX_LENGTH = 65535;
    private static final int EMPTY_LENGTH = 2;

    private MqttBinaryData() {
    }

    public static byte @Nullable [] decode(@NotNull ByteBuf byteBuf) {
        if (byteBuf.readableBytes() < 2) {
            return null;
        }
        int length = byteBuf.readUnsignedShort();
        if (byteBuf.readableBytes() < length) {
            return null;
        }
        byte[] binary = new byte[length];
        byteBuf.readBytes(binary);
        return binary;
    }

    @Nullable
    public static String decodeString(@NotNull ByteBuf byteBuf, boolean validateUTF8) {
        byte[] binary = MqttBinaryData.decode(byteBuf);
        if (binary != null && Utf8Utils.containsMustNotCharacters(binary)) {
            return null;
        }
        if (binary != null && validateUTF8 && Utf8Utils.hasControlOrNonCharacter(binary)) {
            return null;
        }
        return binary == null ? null : new String(binary, StandardCharsets.UTF_8);
    }

    @Nullable
    public static ByteBuffer decode(@NotNull ByteBuf byteBuf, boolean direct) {
        if (byteBuf.readableBytes() < 2) {
            return null;
        }
        int length = byteBuf.readUnsignedShort();
        if (byteBuf.readableBytes() < length) {
            return null;
        }
        ByteBuffer byteBuffer = MqttBinaryData.allocate(length, direct);
        byteBuf.readBytes(byteBuffer);
        byteBuffer.position(0);
        return byteBuffer;
    }

    public static void encode(byte @NotNull [] binary, @NotNull ByteBuf byteBuf) {
        byteBuf.writeShort(binary.length);
        byteBuf.writeBytes(binary);
    }

    public static void encode(@NotNull String value, @NotNull ByteBuf byteBuf) {
        byte[] binary = value.getBytes(StandardCharsets.UTF_8);
        MqttBinaryData.encode(binary, byteBuf);
    }

    public static void encode(@NotNull ByteBuffer byteBuffer, @NotNull ByteBuf byteBuf) {
        byteBuf.writeShort(byteBuffer.remaining());
        byteBuf.writeBytes(byteBuffer.duplicate());
    }

    public static void encodeEmpty(@NotNull ByteBuf byteBuf) {
        byteBuf.writeShort(0);
    }

    public static boolean isInRange(byte @NotNull [] binary) {
        return binary.length <= 65535;
    }

    public static boolean isInRange(@NotNull ByteBuffer byteBuffer) {
        return byteBuffer.remaining() <= 65535;
    }

    public static int encodedLength(byte @NotNull [] binary) {
        return 2 + binary.length;
    }

    public static int encodedLength(@NotNull String value) {
        return MqttBinaryData.encodedLength(value.getBytes(StandardCharsets.UTF_8));
    }

    public static int encodedLength(@NotNull ByteBuffer byteBuffer) {
        return 2 + byteBuffer.remaining();
    }

    @NotNull
    public static ByteBuffer allocate(int capacity, boolean direct) {
        return direct ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
    }

    @Nullable
    public static ByteBuffer wrap(byte @Nullable [] binary) {
        return binary == null ? null : ByteBuffer.wrap(binary);
    }

    @Nullable
    public static ByteBuffer slice(@Nullable ByteBuffer byteBuffer) {
        return byteBuffer == null ? null : byteBuffer.slice();
    }

    @Nullable
    public static ByteBuffer readOnly(@Nullable ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        ByteBuffer readOnlyBuffer = byteBuffer.asReadOnlyBuffer();
        readOnlyBuffer.clear();
        return readOnlyBuffer;
    }

    public static byte @NotNull [] getBytes(@NotNull ByteBuffer byteBuffer) {
        byte[] binary = new byte[byteBuffer.remaining()];
        byteBuffer.get(binary).position(0);
        return binary;
    }
}

