/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.configuration.service.entity;

import com.google.common.base.Preconditions;
import com.hivemq.configuration.service.entity.Listener;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;

public class TcpListener
implements Listener {
    private int port;
    @NotNull
    private final String name;
    @NotNull
    private final String bindAddress;

    @Deprecated
    public TcpListener(int port, @NotNull String bindAddress) {
        this(port, bindAddress, "tcp-listener-" + port);
    }

    public TcpListener(int port, @NotNull String bindAddress, @NotNull String name) {
        Preconditions.checkNotNull((Object)bindAddress, (Object)"bindAddress must not be null");
        Preconditions.checkNotNull((Object)name, (Object)"name must not be null");
        this.port = port;
        this.bindAddress = bindAddress;
        this.name = name;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    @NotNull
    public String getBindAddress() {
        return this.bindAddress;
    }

    @Override
    @NotNull
    public String readableName() {
        return "TCP Listener";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public static class Builder {
        @Nullable
        private String name;
        @Nullable
        private Integer port;
        @Nullable
        private String bindAddress;

        @NotNull
        public Builder from(@NotNull TcpListener tcpListener) {
            this.port = tcpListener.getPort();
            this.bindAddress = tcpListener.getBindAddress();
            this.name = tcpListener.getName();
            return this;
        }

        @NotNull
        public Builder port(int port) {
            this.port = port;
            return this;
        }

        @NotNull
        public Builder bindAddress(@NotNull String bindAddress) {
            Preconditions.checkNotNull((Object)bindAddress);
            this.bindAddress = bindAddress;
            return this;
        }

        @NotNull
        public Builder name(@NotNull String name) {
            Preconditions.checkNotNull((Object)name);
            this.name = name;
            return this;
        }

        @NotNull
        public TcpListener build() throws IllegalStateException {
            if (this.port == null) {
                throw new IllegalStateException("The port for a TCP listener was not set.");
            }
            if (this.bindAddress == null) {
                throw new IllegalStateException("The bind address for a TCP listener was not set.");
            }
            if (this.name == null) {
                this.name = "tcp-listener-" + this.port;
            }
            return new TcpListener(this.port, this.bindAddress, this.name);
        }
    }
}

