/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.auth;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.async.Async;
import com.hivemq.extension.sdk.api.async.TimeoutFallback;
import com.hivemq.extension.sdk.api.packets.auth.ModifiableDefaultPermissions;
import com.hivemq.extensions.auth.AuthenticationState;
import com.hivemq.extensions.auth.parameter.ModifiableClientSettingsImpl;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.task.AbstractAsyncOutput;
import com.hivemq.extensions.packets.general.ModifiableUserPropertiesImpl;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class AuthOutput<T>
extends AbstractAsyncOutput<T> {
    @NotNull
    private final AtomicBoolean decided = new AtomicBoolean(false);
    private boolean authenticatorPresent = false;
    @NotNull
    private AuthenticationState authenticationState = AuthenticationState.UNDECIDED;
    @Nullable
    private ByteBuffer authenticationData;
    @Nullable
    String reasonString;
    @Nullable
    String timeoutReasonString;
    private final boolean validateUTF8;
    @NotNull
    private final ModifiableUserPropertiesImpl userProperties;
    @NotNull
    private final ModifiableDefaultPermissions defaultPermissions;
    @NotNull
    private final ModifiableClientSettingsImpl clientSettings;
    private int timeout;

    AuthOutput(@NotNull PluginOutPutAsyncer asyncer, boolean validateUTF8, @NotNull ModifiableDefaultPermissions defaultPermissions, @NotNull ModifiableClientSettingsImpl clientSettings, int timeout) {
        super(asyncer);
        this.validateUTF8 = validateUTF8;
        this.userProperties = new ModifiableUserPropertiesImpl((ImmutableList<MqttUserProperty>)ImmutableList.of(), validateUTF8);
        this.defaultPermissions = defaultPermissions;
        this.clientSettings = clientSettings;
        this.timeout = timeout;
    }

    AuthOutput(@NotNull AuthOutput<T> prevOutput) {
        super(prevOutput.asyncer);
        this.validateUTF8 = prevOutput.validateUTF8;
        this.userProperties = new ModifiableUserPropertiesImpl(prevOutput.userProperties.asInternalList(), this.validateUTF8);
        this.defaultPermissions = prevOutput.defaultPermissions;
        this.clientSettings = prevOutput.clientSettings;
        this.timeout = prevOutput.timeout;
    }

    public void authenticateSuccessfully() {
        this.checkDecided("authenticateSuccessfully");
        this.authenticationState = AuthenticationState.SUCCESS;
    }

    public void authenticateSuccessfully(@NotNull ByteBuffer authenticationData) {
        Preconditions.checkNotNull((Object)authenticationData, (Object)"Authentication data must never be null");
        this.authenticateSuccessfully();
        this.authenticationData = authenticationData.asReadOnlyBuffer();
    }

    public void authenticateSuccessfully(@NotNull byte[] authenticationData) {
        Preconditions.checkNotNull((Object)authenticationData, (Object)"Authentication data must never be null");
        this.authenticateSuccessfully();
        this.authenticationData = ByteBuffer.wrap(authenticationData).asReadOnlyBuffer();
    }

    public void continueAuthentication() {
        this.checkDecided("continueAuthentication");
        this.authenticationState = AuthenticationState.CONTINUE;
    }

    public void continueAuthentication(@NotNull ByteBuffer authenticationData) {
        Preconditions.checkNotNull((Object)authenticationData, (Object)"Authentication data must never be null");
        this.continueAuthentication();
        this.authenticationData = authenticationData.asReadOnlyBuffer();
    }

    public void continueAuthentication(@NotNull byte[] authenticationData) {
        Preconditions.checkNotNull((Object)authenticationData, (Object)"Authentication data must never be null");
        this.continueAuthentication();
        this.authenticationData = ByteBuffer.wrap(authenticationData).asReadOnlyBuffer();
    }

    public void failAuthentication() {
        this.checkDecided("failAuthentication");
        this.authenticationState = AuthenticationState.FAILED;
    }

    public void failAuthentication(@Nullable String reasonString) {
        this.failAuthentication();
        this.reasonString = reasonString;
    }

    public void nextExtensionOrDefault() {
        this.checkDecided("nextExtensionOrDefault");
        this.authenticationState = AuthenticationState.NEXT_EXTENSION_OR_DEFAULT;
    }

    @NotNull
    public Async<T> async(@NotNull Duration timeout, @NotNull TimeoutFallback fallback, @Nullable String reasonString) {
        Async async = this.async(timeout, fallback);
        this.timeoutReasonString = reasonString;
        return async;
    }

    void failByTimeout() {
        this.decided.set(true);
        this.authenticationState = AuthenticationState.FAILED;
        this.reasonString = this.timeoutReasonString;
    }

    void nextByTimeout() {
        this.decided.set(true);
        this.authenticationState = AuthenticationState.NEXT_EXTENSION_OR_DEFAULT;
    }

    void failByUndecided() {
        this.decided.set(true);
        this.authenticationState = AuthenticationState.FAILED;
    }

    void failByThrowable(@NotNull Throwable throwable) {
        this.decided.set(true);
        this.authenticationState = AuthenticationState.FAILED;
    }

    @Nullable
    ByteBuffer getAuthenticationData() {
        return this.authenticationData;
    }

    @Nullable
    String getReasonString() {
        return this.reasonString;
    }

    @NotNull
    public ModifiableUserPropertiesImpl getOutboundUserProperties() {
        return this.userProperties;
    }

    @NotNull
    public ModifiableDefaultPermissions getDefaultPermissions() {
        return this.defaultPermissions;
    }

    @NotNull
    public ModifiableClientSettingsImpl getClientSettings() {
        return this.clientSettings;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    int getTimeout() {
        return this.timeout;
    }

    void setAuthenticatorPresent() {
        this.authenticatorPresent = true;
    }

    boolean isAuthenticatorPresent() {
        return this.authenticatorPresent;
    }

    @NotNull
    AuthenticationState getAuthenticationState() {
        return this.authenticationState;
    }

    private void checkDecided(@NotNull String method) {
        if (!this.decided.compareAndSet(false, true)) {
            if (this.isTimedOut()) {
                throw new UnsupportedOperationException(method + " has no effect as the async operation timed out.");
            }
            throw new UnsupportedOperationException(method + " must not be called if authenticateSuccessfully, failAuthentication, continueAuthentication or nextExtensionOrDefault has already been called.");
        }
    }
}

