/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ClientState;
import com.hivemq.bootstrap.netty.ChannelDependencies;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.client.parameter.ServerInformation;
import com.hivemq.extension.sdk.api.packets.auth.ModifiableDefaultPermissions;
import com.hivemq.extensions.ExtensionPriorityComparator;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.auth.AbstractAuthTask;
import com.hivemq.extensions.auth.AuthConnectInput;
import com.hivemq.extensions.auth.AuthInput;
import com.hivemq.extensions.auth.ConnectAuthConnectTask;
import com.hivemq.extensions.auth.ConnectAuthContext;
import com.hivemq.extensions.auth.ConnectAuthOutput;
import com.hivemq.extensions.auth.ConnectAuthTask;
import com.hivemq.extensions.auth.ConnectSimpleAuthTask;
import com.hivemq.extensions.auth.ReAuthContext;
import com.hivemq.extensions.auth.ReAuthOutput;
import com.hivemq.extensions.auth.ReAuthTask;
import com.hivemq.extensions.auth.parameter.AuthenticatorProviderInputImpl;
import com.hivemq.extensions.auth.parameter.ModifiableClientSettingsImpl;
import com.hivemq.extensions.client.ClientAuthenticators;
import com.hivemq.extensions.client.ClientAuthenticatorsImpl;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.PluginTaskExecutorService;
import com.hivemq.extensions.handler.PluginAuthenticatorService;
import com.hivemq.extensions.packets.general.ModifiableDefaultPermissionsImpl;
import com.hivemq.extensions.services.auth.Authenticators;
import com.hivemq.extensions.services.auth.WrappedAuthenticatorProvider;
import com.hivemq.mqtt.handler.auth.MqttAuthSender;
import com.hivemq.mqtt.handler.connack.MqttConnacker;
import com.hivemq.mqtt.handler.connect.ConnectHandler;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.auth.AUTH;
import com.hivemq.mqtt.message.connect.CONNECT;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5ConnAckReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import javax.inject.Singleton;

@Singleton
public class PluginAuthenticatorServiceImpl
implements PluginAuthenticatorService {
    @VisibleForTesting
    static final String CONNACK_BAD_AUTHENTICATION_METHOD_LOG_STATEMENT = "Client with IP {} sent AUTH packet with a different authentication method than in the CONNECT packet. Disconnecting client.";
    @VisibleForTesting
    static final String DISCONNECT_BAD_AUTHENTICATION_METHOD_LOG_STATEMENT = "Client with IP {} sent AUTH packet with a different authentication method than in the CONNECT packet. Disconnecting client.";
    public static final String AUTH_FAILED_LOG = "Client with ip {} could not be authenticated";
    public static final String RE_AUTH_FAILED_LOG = "Client with ip {} could not be re-authenticated";
    @NotNull
    private final ConnectHandler connectHandler;
    @NotNull
    private final MqttConnacker connacker;
    @NotNull
    private final MqttServerDisconnector disconnector;
    @NotNull
    private final MqttAuthSender authSender;
    @NotNull
    private final Authenticators authenticators;
    @NotNull
    private final ChannelDependencies channelDependencies;
    @NotNull
    private final PluginOutPutAsyncer asyncer;
    @NotNull
    private final PluginTaskExecutorService pluginTaskExecutorService;
    @NotNull
    private final ServerInformation serverInformation;
    @NotNull
    private final ExtensionPriorityComparator priorityComparator;
    private final boolean validateUTF8;
    private final int timeout;

    @Inject
    public PluginAuthenticatorServiceImpl(@NotNull ConnectHandler connectHandler, @NotNull MqttConnacker connacker, @NotNull MqttServerDisconnector disconnector, @NotNull MqttAuthSender authSender, @NotNull FullConfigurationService configurationService, @NotNull Authenticators authenticators, @NotNull ChannelDependencies channelDependencies, @NotNull PluginOutPutAsyncer asyncer, @NotNull PluginTaskExecutorService pluginTaskExecutorService, @NotNull HiveMQExtensions extensions, @NotNull ServerInformation serverInformation) {
        this.connectHandler = connectHandler;
        this.connacker = connacker;
        this.disconnector = disconnector;
        this.authenticators = authenticators;
        this.channelDependencies = channelDependencies;
        this.asyncer = asyncer;
        this.pluginTaskExecutorService = pluginTaskExecutorService;
        this.authSender = authSender;
        this.priorityComparator = new ExtensionPriorityComparator(extensions);
        this.serverInformation = serverInformation;
        this.timeout = InternalConfigurations.AUTH_PROCESS_TIMEOUT_SEC.get();
        this.validateUTF8 = configurationService.securityConfiguration().validateUTF8();
    }

    @Override
    public void authenticateConnect(@NotNull ChannelHandlerContext ctx, @NotNull ClientConnectionContext clientConnectionContext, @NotNull CONNECT connect, @NotNull ModifiableClientSettingsImpl clientSettings) {
        String authMethod = connect.getAuthMethod();
        if (authMethod != null) {
            clientConnectionContext.setAuthMethod(authMethod);
        }
        ModifiableDefaultPermissionsImpl defaultPermissions = new ModifiableDefaultPermissionsImpl();
        clientConnectionContext.setAuthPermissions(defaultPermissions);
        Map<String, WrappedAuthenticatorProvider> authenticatorProviderMap = this.authenticators.getAuthenticatorProviderMap();
        if (authenticatorProviderMap.isEmpty()) {
            this.connectHandler.connectSuccessfulUndecided(ctx, clientConnectionContext, connect, clientSettings);
            return;
        }
        if (authMethod != null) {
            ctx.pipeline().addAfter("mqtt_message_decoder", "auth_in_progress_message_handler", (ChannelHandler)this.channelDependencies.getAuthInProgressMessageHandler());
        }
        AuthenticatorProviderInputImpl authenticatorProviderInput = new AuthenticatorProviderInputImpl(this.serverInformation, ctx.channel(), connect.getClientIdentifier());
        AuthConnectInput input = new AuthConnectInput(connect, ctx.channel());
        ClientAuthenticators clientAuthenticators = this.getClientAuthenticators(ctx);
        ConnectAuthOutput output = new ConnectAuthOutput(this.asyncer, this.validateUTF8, defaultPermissions, clientSettings, this.timeout, authMethod != null);
        ConnectAuthContext context = new ConnectAuthContext(ctx, this.authSender, authenticatorProviderMap.size(), output, this.connectHandler, this.connacker, connect, true);
        for (Map.Entry<String, WrappedAuthenticatorProvider> entry : authenticatorProviderMap.entrySet()) {
            AbstractAuthTask task;
            String extensionId = entry.getKey();
            WrappedAuthenticatorProvider authenticatorProvider = entry.getValue();
            if (!authenticatorProvider.isEnhanced()) {
                task = new ConnectSimpleAuthTask(authenticatorProvider, authenticatorProviderInput, extensionId);
                this.pluginTaskExecutorService.handlePluginInOutTaskExecution(context, input, context, task);
                continue;
            }
            task = new ConnectAuthConnectTask(authenticatorProvider, authenticatorProviderInput, extensionId, clientAuthenticators);
            this.pluginTaskExecutorService.handlePluginInOutTaskExecution(context, input, context, task);
        }
    }

    @Override
    public void authenticateAuth(@NotNull ChannelHandlerContext ctx, @NotNull ClientConnectionContext clientConnectionContext, @NotNull AUTH auth) {
        boolean reAuth = clientConnectionContext.getClientState() == ClientState.RE_AUTHENTICATING;
        String authMethod = auth.getAuthMethod();
        if (!authMethod.equals(clientConnectionContext.getAuthMethod())) {
            this.badAuthMethodDisconnect(ctx, auth, reAuth);
            return;
        }
        ScheduledFuture<?> authFuture = clientConnectionContext.getAuthFuture();
        if (authFuture != null) {
            authFuture.cancel(true);
            clientConnectionContext.setAuthFuture(null);
        }
        int enhancedAuthenticatorCount = 0;
        Map<String, WrappedAuthenticatorProvider> authenticatorProviderMap = this.authenticators.getAuthenticatorProviderMap();
        for (Map.Entry<String, WrappedAuthenticatorProvider> entry : authenticatorProviderMap.entrySet()) {
            if (!entry.getValue().isEnhanced()) continue;
            ++enhancedAuthenticatorCount;
        }
        if (enhancedAuthenticatorCount == 0) {
            this.noAuthAvailableDisconnect(ctx, reAuth);
            return;
        }
        String clientId = clientConnectionContext.getClientId();
        AuthenticatorProviderInputImpl authenticatorProviderInput = new AuthenticatorProviderInputImpl(this.serverInformation, ctx.channel(), clientId);
        AuthInput input = new AuthInput(clientId, ctx.channel(), auth, reAuth);
        ModifiableDefaultPermissions defaultPermissions = clientConnectionContext.getAuthPermissions();
        ModifiableClientSettingsImpl clientSettings = PluginAuthenticatorServiceImpl.getSettingsFromChannel(ctx.channel());
        ClientAuthenticators clientAuthenticators = this.getClientAuthenticators(ctx);
        if (reAuth) {
            ReAuthOutput output = new ReAuthOutput(this.asyncer, this.validateUTF8, defaultPermissions, clientSettings, this.timeout);
            ReAuthContext context = new ReAuthContext(clientId, ctx, this.authSender, enhancedAuthenticatorCount, output, this.disconnector);
            for (Map.Entry<String, WrappedAuthenticatorProvider> entry : authenticatorProviderMap.entrySet()) {
                String extensionId = entry.getKey();
                WrappedAuthenticatorProvider authenticatorProvider = entry.getValue();
                if (!authenticatorProvider.isEnhanced()) continue;
                ReAuthTask task = new ReAuthTask(authenticatorProvider, authenticatorProviderInput, extensionId, clientAuthenticators);
                this.pluginTaskExecutorService.handlePluginInOutTaskExecution(context, input, context, task);
            }
        } else {
            CONNECT connect = clientConnectionContext.getAuthConnect();
            ConnectAuthOutput output = new ConnectAuthOutput(this.asyncer, this.validateUTF8, defaultPermissions, clientSettings, this.timeout, true);
            ConnectAuthContext context = new ConnectAuthContext(ctx, this.authSender, enhancedAuthenticatorCount, output, this.connectHandler, this.connacker, connect, false);
            for (Map.Entry<String, WrappedAuthenticatorProvider> entry : authenticatorProviderMap.entrySet()) {
                String extensionId = entry.getKey();
                WrappedAuthenticatorProvider authenticatorProvider = entry.getValue();
                if (!authenticatorProvider.isEnhanced()) continue;
                ConnectAuthTask task = new ConnectAuthTask(authenticatorProvider, authenticatorProviderInput, extensionId, clientAuthenticators);
                this.pluginTaskExecutorService.handlePluginInOutTaskExecution(context, input, context, task);
            }
        }
    }

    private void badAuthMethodDisconnect(@NotNull ChannelHandlerContext ctx, @NotNull AUTH auth, boolean reAuth) {
        String reasonString = String.format("%s with invalid authentication method was sent.", auth.getType().name());
        if (reAuth) {
            this.disconnector.disconnect(ctx.channel(), "Client with IP {} sent AUTH packet with a different authentication method than in the CONNECT packet. Disconnecting client.", "Different auth method", Mqtt5DisconnectReasonCode.BAD_AUTHENTICATION_METHOD, reasonString, Mqtt5UserProperties.NO_USER_PROPERTIES, true, false);
        } else {
            this.connacker.connackError(ctx.channel(), "Client with IP {} sent AUTH packet with a different authentication method than in the CONNECT packet. Disconnecting client.", "Different auth method", Mqtt5ConnAckReasonCode.BAD_AUTHENTICATION_METHOD, reasonString, Mqtt5UserProperties.NO_USER_PROPERTIES, true);
        }
    }

    private void noAuthAvailableDisconnect(@NotNull ChannelHandlerContext ctx, boolean reAuth) {
        if (reAuth) {
            this.disconnector.disconnect(ctx.channel(), RE_AUTH_FAILED_LOG, "Re-authentication failed, no authenticator registered", Mqtt5DisconnectReasonCode.NOT_AUTHORIZED, "Re-authentication failed, no authenticator registered", Mqtt5UserProperties.NO_USER_PROPERTIES, true, false);
        } else {
            this.connacker.connackError(ctx.channel(), AUTH_FAILED_LOG, "Authentication failed, no authenticator registered", Mqtt5ConnAckReasonCode.NOT_AUTHORIZED, "Authentication failed, no authenticator registered", Mqtt5UserProperties.NO_USER_PROPERTIES, true);
        }
    }

    @NotNull
    private static ModifiableClientSettingsImpl getSettingsFromChannel(@NotNull Channel channel) {
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(channel);
        Integer receiveMax = clientConnectionContext.getClientReceiveMaximum();
        Preconditions.checkNotNull((Object)receiveMax, (Object)"Receive maximum must not be null here");
        Long queueSizeMaximum = clientConnectionContext.getQueueSizeMaximum();
        return new ModifiableClientSettingsImpl(receiveMax, queueSizeMaximum);
    }

    @NotNull
    private ClientAuthenticators getClientAuthenticators(@NotNull ChannelHandlerContext ctx) {
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(ctx.channel());
        if (clientConnectionContext.getExtensionClientAuthenticators() == null) {
            clientConnectionContext.setExtensionClientAuthenticators(new ClientAuthenticatorsImpl(this.priorityComparator));
        }
        return clientConnectionContext.getExtensionClientAuthenticators();
    }
}

