/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler;

import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.interceptor.unsuback.UnsubackOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.unsuback.parameter.UnsubackOutboundInput;
import com.hivemq.extension.sdk.api.interceptor.unsuback.parameter.UnsubackOutboundOutput;
import com.hivemq.extensions.ExtensionInformationUtil;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.client.ClientContextImpl;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.PluginTaskExecutorService;
import com.hivemq.extensions.executor.task.PluginInOutTask;
import com.hivemq.extensions.executor.task.PluginInOutTaskContext;
import com.hivemq.extensions.handler.ExtensionParameterHolder;
import com.hivemq.extensions.interceptor.unsuback.parameter.UnsubackOutboundInputImpl;
import com.hivemq.extensions.interceptor.unsuback.parameter.UnsubackOutboundOutputImpl;
import com.hivemq.extensions.packets.unsuback.ModifiableUnsubackPacketImpl;
import com.hivemq.extensions.packets.unsuback.UnsubackPacketImpl;
import com.hivemq.mqtt.message.unsuback.UNSUBACK;
import com.hivemq.util.Exceptions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UnsubackOutboundInterceptorHandler {
    private static final Logger log = LoggerFactory.getLogger(UnsubackOutboundInterceptorHandler.class);
    @NotNull
    private final FullConfigurationService configurationService;
    @NotNull
    private final PluginOutPutAsyncer asyncer;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final PluginTaskExecutorService executorService;

    @Inject
    public UnsubackOutboundInterceptorHandler(@NotNull FullConfigurationService configurationService, @NotNull PluginOutPutAsyncer asyncer, @NotNull HiveMQExtensions hiveMQExtensions, @NotNull PluginTaskExecutorService executorService) {
        this.configurationService = configurationService;
        this.asyncer = asyncer;
        this.hiveMQExtensions = hiveMQExtensions;
        this.executorService = executorService;
    }

    public void handleOutboundUnsuback(@NotNull ChannelHandlerContext ctx, @NotNull UNSUBACK unsuback, @NotNull ChannelPromise promise) {
        Channel channel = ctx.channel();
        ClientConnection clientConnection = ClientConnection.of(channel);
        String clientId = clientConnection.getClientId();
        if (clientId == null) {
            return;
        }
        ClientContextImpl clientContext = clientConnection.getExtensionClientContext();
        if (clientContext == null) {
            ctx.write((Object)unsuback, promise);
            return;
        }
        List<UnsubackOutboundInterceptor> interceptors = clientContext.getUnsubackOutboundInterceptors();
        if (interceptors.isEmpty()) {
            ctx.write((Object)unsuback, promise);
            return;
        }
        ClientInformation clientInfo = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        ConnectionInformation connectionInfo = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        UnsubackPacketImpl packet = new UnsubackPacketImpl(unsuback);
        UnsubackOutboundInputImpl input = new UnsubackOutboundInputImpl(clientInfo, connectionInfo, packet);
        ExtensionParameterHolder<UnsubackOutboundInputImpl> inputHolder = new ExtensionParameterHolder<UnsubackOutboundInputImpl>(input);
        ModifiableUnsubackPacketImpl modifiablePacket = new ModifiableUnsubackPacketImpl(packet, this.configurationService);
        UnsubackOutboundOutputImpl output = new UnsubackOutboundOutputImpl(this.asyncer, modifiablePacket);
        ExtensionParameterHolder<UnsubackOutboundOutputImpl> outputHolder = new ExtensionParameterHolder<UnsubackOutboundOutputImpl>(output);
        UnsubackOutboundInterceptorContext context = new UnsubackOutboundInterceptorContext(clientId, interceptors.size(), ctx, promise, inputHolder, outputHolder);
        for (UnsubackOutboundInterceptor interceptor : interceptors) {
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(interceptor.getClass().getClassLoader());
            if (extension == null) {
                context.finishInterceptor();
                continue;
            }
            UnsubackOutboundInterceptorTask task = new UnsubackOutboundInterceptorTask(interceptor, extension.getId());
            this.executorService.handlePluginInOutTaskExecution(context, inputHolder, outputHolder, task);
        }
    }

    private static class UnsubackOutboundInterceptorTask
    implements PluginInOutTask<UnsubackOutboundInputImpl, UnsubackOutboundOutputImpl> {
        @NotNull
        private final UnsubackOutboundInterceptor interceptor;
        @NotNull
        private final String extensionId;

        UnsubackOutboundInterceptorTask(@NotNull UnsubackOutboundInterceptor interceptor, @NotNull String extensionId) {
            this.interceptor = interceptor;
            this.extensionId = extensionId;
        }

        @Override
        @NotNull
        public UnsubackOutboundOutputImpl apply(@NotNull UnsubackOutboundInputImpl input, @NotNull UnsubackOutboundOutputImpl output) {
            try {
                this.interceptor.onOutboundUnsuback((UnsubackOutboundInput)input, (UnsubackOutboundOutput)output);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on outbound UNSUBACK interception. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)e);
                output.markAsFailed();
                Exceptions.rethrowError(e);
            }
            return output;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.interceptor.getClass().getClassLoader();
        }
    }

    private static class UnsubackOutboundInterceptorContext
    extends PluginInOutTaskContext<UnsubackOutboundOutputImpl>
    implements Runnable {
        private final int interceptorCount;
        @NotNull
        private final AtomicInteger counter;
        @NotNull
        private final ChannelHandlerContext ctx;
        @NotNull
        private final ChannelPromise promise;
        @NotNull
        final ExtensionParameterHolder<UnsubackOutboundInputImpl> inputHolder;
        @NotNull
        final ExtensionParameterHolder<UnsubackOutboundOutputImpl> outputHolder;

        UnsubackOutboundInterceptorContext(@NotNull String identifier, int interceptorCount, @NotNull ChannelHandlerContext ctx, @NotNull ChannelPromise promise, @NotNull ExtensionParameterHolder<UnsubackOutboundInputImpl> inputHolder, @NotNull ExtensionParameterHolder<UnsubackOutboundOutputImpl> outputHolder) {
            super(identifier);
            this.interceptorCount = interceptorCount;
            this.counter = new AtomicInteger(0);
            this.ctx = ctx;
            this.promise = promise;
            this.inputHolder = inputHolder;
            this.outputHolder = outputHolder;
        }

        @Override
        public void pluginPost(@NotNull UnsubackOutboundOutputImpl output) {
            if (output.isTimedOut()) {
                log.debug("Async timeout on outbound UNSUBACK interception. Discarding changes made by the interceptor.");
            } else if (output.isFailed()) {
                log.debug("Exception on outbound UNSUBACK interception. Discarding changes made by the interceptor.");
            } else if (output.getUnsubackPacket().isModified()) {
                this.inputHolder.set(this.inputHolder.get().update(output));
            }
            if (!this.finishInterceptor()) {
                this.outputHolder.set(output.update(this.inputHolder.get()));
            }
        }

        public boolean finishInterceptor() {
            if (this.counter.incrementAndGet() == this.interceptorCount) {
                this.ctx.executor().execute((Runnable)this);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            this.ctx.writeAndFlush((Object)UNSUBACK.from(this.inputHolder.get().getUnsubackPacket()), this.promise);
        }
    }
}

