/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler.tasks;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extensions.auth.parameter.SubscriptionAuthorizerOutputImpl;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.handler.subscribe.IncomingSubscribeService;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5SubAckReasonCode;
import com.hivemq.mqtt.message.subscribe.SUBSCRIBE;
import com.hivemq.mqtt.message.subscribe.Topic;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllTopicsProcessedTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(AllTopicsProcessedTask.class);
    @NotNull
    private final SUBSCRIBE msg;
    @NotNull
    private final List<ListenableFuture<SubscriptionAuthorizerOutputImpl>> listenableFutures;
    @NotNull
    private final ChannelHandlerContext ctx;
    @NotNull
    private final MqttServerDisconnector mqttServerDisconnector;
    @NotNull
    private final IncomingSubscribeService incomingSubscribeService;

    public AllTopicsProcessedTask(@NotNull SUBSCRIBE msg, @NotNull List<ListenableFuture<SubscriptionAuthorizerOutputImpl>> listenableFutures, @NotNull ChannelHandlerContext ctx, @NotNull MqttServerDisconnector mqttServerDisconnector, @NotNull IncomingSubscribeService incomingSubscribeService) {
        this.msg = msg;
        this.listenableFutures = listenableFutures;
        this.ctx = ctx;
        this.mqttServerDisconnector = mqttServerDisconnector;
        this.incomingSubscribeService = incomingSubscribeService;
    }

    @Override
    public void run() {
        try {
            Preconditions.checkArgument((this.listenableFutures.size() == this.msg.getTopics().size() ? 1 : 0) != 0, (Object)"The amount of futures must be equal to the amount of topics");
            Mqtt5SubAckReasonCode[] answerCodes = new Mqtt5SubAckReasonCode[this.msg.getTopics().size()];
            String[] reasonStrings = new String[this.msg.getTopics().size()];
            boolean authorizersPresent = false;
            block9: for (int i = 0; i < this.listenableFutures.size(); ++i) {
                SubscriptionAuthorizerOutputImpl output = (SubscriptionAuthorizerOutputImpl)this.listenableFutures.get(i).get();
                if (output.isAuthorizerPresent()) {
                    authorizersPresent = true;
                }
                switch (output.getAuthorizationState()) {
                    case CONTINUE: {
                        continue block9;
                    }
                    case DISCONNECT: {
                        this.disconnectClient(i, output);
                        return;
                    }
                    case FAIL: {
                        if (output.getSubackReasonCode() != null) {
                            answerCodes[i] = Mqtt5SubAckReasonCode.from(output.getSubackReasonCode());
                            reasonStrings[i] = output.getReasonString();
                            continue block9;
                        }
                        answerCodes[i] = Mqtt5SubAckReasonCode.NOT_AUTHORIZED;
                        continue block9;
                    }
                    case UNDECIDED: {
                        if (!output.isAuthorizerPresent()) continue block9;
                        answerCodes[i] = Mqtt5SubAckReasonCode.NOT_AUTHORIZED;
                        reasonStrings[i] = "Sent a SUBSCRIBE with an unauthorized subscription";
                        continue block9;
                    }
                    case SUCCESS: {
                        answerCodes[i] = Mqtt5SubAckReasonCode.fromCode(((Topic)this.msg.getTopics().get(i)).getQoS().getQosNumber());
                        continue block9;
                    }
                }
            }
            boolean finalAuthorizersPresent = authorizersPresent;
            if (this.ctx.channel().isActive()) {
                this.ctx.executor().execute(() -> this.incomingSubscribeService.processSubscribe(this.ctx, this.msg, answerCodes, reasonStrings, finalAuthorizersPresent));
            }
        }
        catch (Exception e) {
            log.error("Subscription authorization failed: ", (Throwable)e);
        }
    }

    private void disconnectClient(int topicIndex, @NotNull SubscriptionAuthorizerOutputImpl output) {
        String logMessage = "A client (IP: {}) sent a SUBSCRIBE with an unauthorized subscription for topic '" + ((Topic)this.msg.getTopics().get(topicIndex)).getTopic() + "'. This is not allowed. Disconnecting client.";
        String eventLogMessage = "Sent a SUBSCRIBE with an unauthorized subscription for topic '" + ((Topic)this.msg.getTopics().get(topicIndex)).getTopic() + "'";
        this.ctx.channel().eventLoop().execute(() -> this.mqttServerDisconnector.disconnect(this.ctx.channel(), logMessage, eventLogMessage, Mqtt5DisconnectReasonCode.from(output.getDisconnectReasonCode()), output.getReasonString()));
    }
}

