/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler.tasks;

import com.google.common.util.concurrent.FutureCallback;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.disconnect.DisconnectReasonCode;
import com.hivemq.extension.sdk.api.packets.publish.AckReasonCode;
import com.hivemq.extensions.auth.parameter.PublishAuthorizerOutputImpl;
import com.hivemq.extensions.handler.PluginAuthorizerServiceImpl;
import com.hivemq.extensions.handler.tasks.PublishAuthorizerResult;
import com.hivemq.mqtt.message.connect.CONNECT;
import com.hivemq.util.Exceptions;
import io.netty.channel.ChannelHandlerContext;

public class WillPublishAuthorizationProcessedTask
implements FutureCallback<PublishAuthorizerOutputImpl> {
    @NotNull
    private final CONNECT connect;
    @NotNull
    private final ChannelHandlerContext ctx;

    public WillPublishAuthorizationProcessedTask(@NotNull CONNECT connect, @NotNull ChannelHandlerContext ctx) {
        this.connect = connect;
        this.ctx = ctx;
    }

    public void onSuccess(@Nullable PublishAuthorizerOutputImpl output) {
        if (output == null) {
            return;
        }
        DisconnectReasonCode disconnectReasonCode = null;
        AckReasonCode reasonCode = null;
        String reasonString = null;
        switch (output.getAuthorizationState()) {
            case DISCONNECT: {
                disconnectReasonCode = output.getDisconnectReasonCode();
                reasonCode = output.getAckReasonCode() != null ? output.getAckReasonCode() : AckReasonCode.NOT_AUTHORIZED;
                reasonString = output.getReasonString() != null ? output.getReasonString() : this.getReasonString(this.connect);
                break;
            }
            case FAIL: {
                reasonCode = output.getAckReasonCode() != null ? output.getAckReasonCode() : AckReasonCode.NOT_AUTHORIZED;
                reasonString = output.getReasonString() != null ? output.getReasonString() : this.getReasonString(this.connect);
                break;
            }
            case UNDECIDED: {
                if (!output.isAuthorizerPresent()) break;
                reasonCode = AckReasonCode.NOT_AUTHORIZED;
                reasonString = this.getReasonString(this.connect);
                break;
            }
            case SUCCESS: {
                reasonCode = AckReasonCode.SUCCESS;
                break;
            }
            case CONTINUE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type");
            }
        }
        PublishAuthorizerResult result = new PublishAuthorizerResult(reasonCode, reasonString, output.isAuthorizerPresent(), disconnectReasonCode);
        this.ctx.pipeline().fireUserEventTriggered((Object)new PluginAuthorizerServiceImpl.AuthorizeWillResultEvent(this.connect, result));
    }

    public void onFailure(@NotNull Throwable t) {
        Exceptions.rethrowError("Exception at PublishAuthorization", t);
        PublishAuthorizerResult result = new PublishAuthorizerResult(AckReasonCode.NOT_AUTHORIZED, this.getReasonString(this.connect), true, DisconnectReasonCode.NOT_AUTHORIZED);
        this.ctx.pipeline().fireUserEventTriggered((Object)new PluginAuthorizerServiceImpl.AuthorizeWillResultEvent(this.connect, result));
    }

    private String getReasonString(@NotNull CONNECT connect) {
        return "Not allowed to connect with Will Publish for unauthorized topic '" + connect.getWillPublish().getTopic() + "' with QoS '" + connect.getWillPublish().getQos().getQosNumber() + "' and retain '" + connect.getWillPublish().isRetain() + "'";
    }
}

