/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.publish;

import com.google.common.primitives.ImmutableIntArray;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.connect.WillPublishPacket;
import com.hivemq.extension.sdk.api.packets.general.Qos;
import com.hivemq.extension.sdk.api.packets.publish.PayloadFormatIndicator;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import com.hivemq.extensions.packets.publish.PublishPacketImpl;
import com.hivemq.mqtt.message.connect.MqttWillPublish;
import java.nio.ByteBuffer;
import java.util.Objects;

public class WillPublishPacketImpl
extends PublishPacketImpl
implements WillPublishPacket {
    final long willDelay;

    public WillPublishPacketImpl(@NotNull String topic, @NotNull Qos qos, @Nullable ByteBuffer payload, boolean retain, long messageExpiryInterval, @Nullable PayloadFormatIndicator payloadFormatIndicator, @Nullable String contentType, @Nullable String responseTopic, @Nullable ByteBuffer correlationData, @NotNull UserPropertiesImpl userProperties, long willDelay, long timestamp) {
        super(topic, qos, qos, 0, false, payload, retain, messageExpiryInterval, payloadFormatIndicator, contentType, responseTopic, correlationData, ImmutableIntArray.of(), userProperties, timestamp);
        this.willDelay = willDelay;
    }

    public WillPublishPacketImpl(@NotNull MqttWillPublish willPublish, long timestamp) {
        this(willPublish.getTopic(), willPublish.getQos().toQos(), willPublish.getPayload() == null ? null : ByteBuffer.wrap(willPublish.getPayload()), willPublish.isRetain(), willPublish.getMessageExpiryInterval(), willPublish.getPayloadFormatIndicator() == null ? null : PayloadFormatIndicator.valueOf((String)willPublish.getPayloadFormatIndicator().name()), willPublish.getContentType(), willPublish.getResponseTopic(), willPublish.getCorrelationData() == null ? null : ByteBuffer.wrap(willPublish.getCorrelationData()), UserPropertiesImpl.of(willPublish.getUserProperties().asList()), willPublish.getDelayInterval(), timestamp);
    }

    public long getWillDelay() {
        return this.willDelay;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WillPublishPacketImpl) || !super.equals(o)) {
            return false;
        }
        WillPublishPacketImpl that = (WillPublishPacketImpl)o;
        return this.willDelay == that.willDelay;
    }

    @Override
    protected boolean canEqual(@Nullable Object o) {
        return o instanceof WillPublishPacketImpl;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.willDelay);
    }
}

