/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.metrics.handler;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.metrics.HiveMQMetrics;
import com.hivemq.metrics.MetricsHolder;
import com.hivemq.mqtt.message.Message;
import com.hivemq.mqtt.message.connect.CONNECT;
import com.hivemq.mqtt.message.publish.PUBLISH;
import java.util.concurrent.atomic.LongAdder;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GlobalMQTTMessageCounter {
    @NotNull
    private final MetricsHolder metricsHolder;
    @NotNull
    private final LongAdder bytesReadTotal;
    @NotNull
    private final LongAdder bytesWrittenTotal;

    @Inject
    public GlobalMQTTMessageCounter(@NotNull MetricsHolder metricsHolder) {
        this.metricsHolder = metricsHolder;
        this.bytesReadTotal = new LongAdder();
        this.bytesWrittenTotal = new LongAdder();
        metricsHolder.getMetricRegistry().register(HiveMQMetrics.BYTES_READ_TOTAL.name(), (Metric)((Gauge)this.bytesReadTotal::longValue));
        metricsHolder.getMetricRegistry().register(HiveMQMetrics.BYTES_WRITE_TOTAL.name(), (Metric)((Gauge)this.bytesWrittenTotal::longValue));
    }

    public void countInbound(@NotNull Message message) {
        this.metricsHolder.getIncomingMessageCounter().inc();
        if (message instanceof CONNECT) {
            this.metricsHolder.getIncomingConnectCounter().inc();
        }
        if (message instanceof PUBLISH) {
            this.metricsHolder.getIncomingPublishCounter().inc();
        }
    }

    public void countInboundTraffic(int bytes) {
        this.bytesReadTotal.add(bytes);
    }

    public void countOutbound(@NotNull Message message) {
        this.metricsHolder.getOutgoingMessageCounter().inc();
        if (message instanceof PUBLISH) {
            this.metricsHolder.getOutgoingPublishCounter().inc();
        }
    }

    public void countOutboundTraffic(int bytes) {
        this.bytesWrittenTotal.add(bytes);
    }
}

