/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.auth;

import com.google.common.annotations.VisibleForTesting;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.handler.connack.MqttConnacker;
import com.hivemq.mqtt.message.auth.AUTH;
import com.hivemq.mqtt.message.disconnect.DISCONNECT;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5ConnAckReasonCode;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import javax.inject.Inject;
import javax.inject.Singleton;

@ChannelHandler.Sharable
@Singleton
public class AuthInProgressMessageHandler
extends ChannelInboundHandlerAdapter {
    @NotNull
    private static final String DISCONNECT_LOG_MESSAGE = "The client with id %s and IP {} sent a message other than AUTH or DISCONNECT during enhanced authentication. This is not allowed. Disconnecting client.";
    @NotNull
    private final MqttConnacker connacker;

    @Inject
    @VisibleForTesting
    public AuthInProgressMessageHandler(@NotNull MqttConnacker connacker) {
        this.connacker = connacker;
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) throws Exception {
        if (msg instanceof AUTH || msg instanceof DISCONNECT) {
            super.channelRead(ctx, msg);
            return;
        }
        String reasonString = "Client must not send a message other than AUTH or DISCONNECT during enhanced authentication";
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(ctx.channel());
        this.connacker.connackError(ctx.channel(), String.format(DISCONNECT_LOG_MESSAGE, clientConnectionContext.getClientId()), "Sent message other than AUTH or DISCONNECT during enhanced authentication", Mqtt5ConnAckReasonCode.PROTOCOL_ERROR, "Client must not send a message other than AUTH or DISCONNECT during enhanced authentication", Mqtt5UserProperties.NO_USER_PROPERTIES, true);
    }
}

