/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.reason;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.publish.AckReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5ReasonCode;
import com.hivemq.mqtt.message.reason.MqttCommonReasonCode;

public enum Mqtt5PubRecReasonCode implements Mqtt5ReasonCode
{
    SUCCESS(MqttCommonReasonCode.SUCCESS),
    NO_MATCHING_SUBSCRIBERS(MqttCommonReasonCode.NO_MATCHING_SUBSCRIBERS),
    UNSPECIFIED_ERROR(MqttCommonReasonCode.UNSPECIFIED_ERROR),
    IMPLEMENTATION_SPECIFIC_ERROR(MqttCommonReasonCode.IMPLEMENTATION_SPECIFIC_ERROR),
    NOT_AUTHORIZED(MqttCommonReasonCode.NOT_AUTHORIZED),
    TOPIC_NAME_INVALID(MqttCommonReasonCode.TOPIC_NAME_INVALID),
    PACKET_IDENTIFIER_IN_USE(MqttCommonReasonCode.PACKET_IDENTIFIER_IN_USE),
    QUOTA_EXCEEDED(MqttCommonReasonCode.QUOTA_EXCEEDED),
    PAYLOAD_FORMAT_INVALID(MqttCommonReasonCode.PAYLOAD_FORMAT_INVALID);

    @NotNull
    private static final Mqtt5PubRecReasonCode[] VALUES;
    private final int code;
    @NotNull
    private final AckReasonCode ackReasonCode;
    @NotNull
    private static final @NotNull Mqtt5PubRecReasonCode @NotNull [] ACK_LOOKUP;

    private Mqtt5PubRecReasonCode(int code) {
        this.code = code;
        this.ackReasonCode = AckReasonCode.valueOf((String)this.name());
    }

    private Mqtt5PubRecReasonCode(MqttCommonReasonCode reasonCode) {
        this(reasonCode.getCode());
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @NotNull
    public AckReasonCode toAckReasonCode() {
        return this.ackReasonCode;
    }

    @Nullable
    public static Mqtt5PubRecReasonCode fromCode(int code) {
        for (Mqtt5PubRecReasonCode reasonCode : VALUES) {
            if (reasonCode.code != code) continue;
            return reasonCode;
        }
        return null;
    }

    @NotNull
    public static Mqtt5PubRecReasonCode from(@NotNull AckReasonCode reasonCode) {
        return ACK_LOOKUP[reasonCode.ordinal()];
    }

    @Override
    public boolean canBeSentByClient() {
        return this != NO_MATCHING_SUBSCRIBERS;
    }

    static {
        VALUES = Mqtt5PubRecReasonCode.values();
        ACK_LOOKUP = new Mqtt5PubRecReasonCode[AckReasonCode.values().length];
        Mqtt5PubRecReasonCode[] mqtt5PubRecReasonCodeArray = VALUES;
        int n = mqtt5PubRecReasonCodeArray.length;
        for (int i = 0; i < n; ++i) {
            Mqtt5PubRecReasonCode reasonCode;
            Mqtt5PubRecReasonCode.ACK_LOOKUP[reasonCode.ackReasonCode.ordinal()] = reasonCode = mqtt5PubRecReasonCodeArray[i];
        }
    }
}

