/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.unsuback;

import com.google.common.collect.ImmutableList;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.packets.unsuback.UnsubackPacketImpl;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttMessageWithUserProperties;
import com.hivemq.mqtt.message.reason.Mqtt5UnsubAckReasonCode;
import com.hivemq.mqtt.message.unsuback.Mqtt3UNSUBACK;
import com.hivemq.mqtt.message.unsuback.Mqtt5UNSUBACK;
import java.util.List;

public class UNSUBACK
extends MqttMessageWithUserProperties.MqttMessageWithIdAndReasonCodes<Mqtt5UnsubAckReasonCode>
implements Mqtt3UNSUBACK,
Mqtt5UNSUBACK {
    public UNSUBACK(int packetIdentifier, Mqtt5UnsubAckReasonCode ... entries) {
        super(packetIdentifier, ImmutableList.copyOf((Object[])entries), null, Mqtt5UserProperties.NO_USER_PROPERTIES);
    }

    public UNSUBACK(int packetIdentifier, @NotNull List<Mqtt5UnsubAckReasonCode> grantedQos) {
        this(packetIdentifier, grantedQos, null, Mqtt5UserProperties.NO_USER_PROPERTIES);
    }

    public UNSUBACK(int packetIdentifier, @NotNull List<Mqtt5UnsubAckReasonCode> grantedQos, @Nullable String reasonString) {
        this(packetIdentifier, grantedQos, reasonString, Mqtt5UserProperties.NO_USER_PROPERTIES);
    }

    public UNSUBACK(int packetIdentifier, @NotNull List<Mqtt5UnsubAckReasonCode> grantedQos, @Nullable String reasonString, @NotNull Mqtt5UserProperties userProperties) {
        super(packetIdentifier, ImmutableList.copyOf(grantedQos), reasonString, userProperties);
    }

    public UNSUBACK(int packetIdentifier, @Nullable String reasonString, @NotNull Mqtt5UserProperties userProperties, Mqtt5UnsubAckReasonCode ... grantedQos) {
        super(packetIdentifier, ImmutableList.copyOf((Object[])grantedQos), reasonString, userProperties);
    }

    @Override
    @NotNull
    public MessageType getType() {
        return MessageType.UNSUBACK;
    }

    @NotNull
    public static UNSUBACK from(@NotNull UnsubackPacketImpl packet) {
        ImmutableList.Builder reasonCodesBuilder = ImmutableList.builder();
        packet.getReasonCodes().forEach(reasonCode -> reasonCodesBuilder.add((Object)Mqtt5UnsubAckReasonCode.from(reasonCode)));
        return new UNSUBACK(packet.getPacketIdentifier(), (List<Mqtt5UnsubAckReasonCode>)reasonCodesBuilder.build(), (String)packet.getReasonString().orElse(null), Mqtt5UserProperties.of(packet.getUserProperties().asInternalList()));
    }
}

