/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.persistence.Sizable;
import com.hivemq.util.ObjectMemoryEstimation;
import java.util.Collection;

public class IterablePersistenceEntry<T extends Collection<? extends Sizable>>
implements Sizable {
    private final long timestamp;
    @NotNull
    private final T object;
    private int sizeInMemory = -1;

    public IterablePersistenceEntry(@NotNull T object, long timestamp) {
        this.timestamp = timestamp;
        this.object = object;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public T getObject() {
        return this.object;
    }

    @NotNull
    public String toString() {
        return this.object.toString();
    }

    public static int getFixedSize() {
        int size = ObjectMemoryEstimation.objectShellSize();
        size += ObjectMemoryEstimation.longSize();
        size += ObjectMemoryEstimation.intSize();
        return size += ObjectMemoryEstimation.collectionOverhead();
    }

    @Override
    public int getEstimatedSize() {
        if (this.sizeInMemory != -1) {
            return this.sizeInMemory;
        }
        int size = IterablePersistenceEntry.getFixedSize();
        for (Sizable item : this.object) {
            size += ObjectMemoryEstimation.objectRefSize();
            size += item.getEstimatedSize();
        }
        this.sizeInMemory = size;
        return this.sizeInMemory;
    }
}

