/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence;

import com.google.common.base.Preconditions;
import com.hivemq.codec.encoder.mqtt5.Mqtt5PayloadFormatIndicator;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.util.ObjectMemoryEstimation;
import java.util.Arrays;
import java.util.Objects;

public class RetainedMessage {
    private static final int SIZE_NOT_CALCULATED = -1;
    @Nullable
    private byte[] message;
    @NotNull
    private final QoS qos;
    private long publishId;
    protected final long messageExpiryInterval;
    @NotNull
    private final Mqtt5UserProperties userProperties;
    @Nullable
    private final String responseTopic;
    @Nullable
    private final String contentType;
    @Nullable
    private final byte[] correlationData;
    @Nullable
    private final Mqtt5PayloadFormatIndicator payloadFormatIndicator;
    private final long timestamp;
    private int sizeInMemory = -1;

    public RetainedMessage(@Nullable byte[] message, @NotNull QoS qos, long publishId, long messageExpiryInterval) {
        this(message, qos, publishId, messageExpiryInterval, Mqtt5UserProperties.NO_USER_PROPERTIES, null, null, null, null, System.currentTimeMillis());
    }

    public RetainedMessage(@Nullable byte[] message, @NotNull QoS qos, long publishId, long messageExpiryInterval, @NotNull Mqtt5UserProperties userProperties, @Nullable String responseTopic, @Nullable String contentType, @Nullable byte[] correlationData, @Nullable Mqtt5PayloadFormatIndicator payloadFormatIndicator, long timestamp) {
        Preconditions.checkNotNull((Object)((Object)qos), (Object)"QoS must not be null");
        this.message = message;
        this.qos = qos;
        this.publishId = publishId;
        this.messageExpiryInterval = messageExpiryInterval;
        this.userProperties = userProperties;
        this.responseTopic = responseTopic;
        this.contentType = contentType;
        this.correlationData = correlationData;
        this.payloadFormatIndicator = payloadFormatIndicator;
        this.timestamp = timestamp;
    }

    public RetainedMessage(@NotNull PUBLISH publish, long messageExpiryInterval) {
        this.message = publish.getPayload();
        this.qos = publish.getQoS();
        this.publishId = publish.getPublishId();
        this.messageExpiryInterval = messageExpiryInterval;
        this.userProperties = publish.getUserProperties();
        this.responseTopic = publish.getResponseTopic();
        this.contentType = publish.getContentType();
        this.correlationData = publish.getCorrelationData();
        this.payloadFormatIndicator = publish.getPayloadFormatIndicator();
        this.timestamp = publish.getTimestamp();
    }

    public RetainedMessage copyWithoutPayload() {
        return new RetainedMessage(null, this.qos, this.publishId, this.messageExpiryInterval, this.userProperties, this.responseTopic, this.contentType, this.correlationData, this.payloadFormatIndicator, this.timestamp);
    }

    public int getEstimatedSizeInMemory() {
        if (this.sizeInMemory != -1) {
            return this.sizeInMemory;
        }
        int size = 0;
        size += ObjectMemoryEstimation.enumSize();
        size += ObjectMemoryEstimation.longWrapperSize();
        size += ObjectMemoryEstimation.longSize();
        size += 24;
        for (MqttUserProperty userProperty : this.getUserProperties().asList()) {
            size += 24;
            size += ObjectMemoryEstimation.stringSize(userProperty.getName());
            size += ObjectMemoryEstimation.stringSize(userProperty.getValue());
        }
        size += ObjectMemoryEstimation.stringSize(this.responseTopic);
        size += ObjectMemoryEstimation.stringSize(this.contentType);
        size += ObjectMemoryEstimation.byteArraySize(this.correlationData);
        size += ObjectMemoryEstimation.enumSize();
        size += ObjectMemoryEstimation.longSize();
        this.sizeInMemory = size += ObjectMemoryEstimation.intSize();
        return this.sizeInMemory;
    }

    @NotNull
    public Mqtt5UserProperties getUserProperties() {
        return this.userProperties;
    }

    @Nullable
    public byte[] getMessage() {
        return this.message;
    }

    @NotNull
    public QoS getQos() {
        return this.qos;
    }

    public long getMessageExpiryInterval() {
        return this.messageExpiryInterval;
    }

    public long getPublishId() {
        return this.publishId;
    }

    @Nullable
    public String getResponseTopic() {
        return this.responseTopic;
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    @Nullable
    public byte[] getCorrelationData() {
        return this.correlationData;
    }

    @Nullable
    public Mqtt5PayloadFormatIndicator getPayloadFormatIndicator() {
        return this.payloadFormatIndicator;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setMessage(@Nullable byte[] message) {
        this.message = message;
    }

    public void setPublishId(long publishId) {
        this.publishId = publishId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetainedMessage that = (RetainedMessage)o;
        if (this.messageExpiryInterval != that.messageExpiryInterval) {
            return false;
        }
        if (!Arrays.equals(this.message, that.message)) {
            return false;
        }
        return this.qos == that.qos;
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.qos, this.publishId, this.messageExpiryInterval, this.userProperties});
        result = 31 * result + Arrays.hashCode(this.message);
        return result;
    }

    public long getRemainingExpiry() {
        if (this.isExpiryDisabled()) {
            return Long.MAX_VALUE;
        }
        long waitingSeconds = (System.currentTimeMillis() - this.timestamp) / 1000L;
        return Math.max(0L, this.messageExpiryInterval - waitingSeconds);
    }

    public boolean isExpiryDisabled() {
        return this.messageExpiryInterval == -1L || this.messageExpiryInterval == Long.MAX_VALUE;
    }

    public boolean hasExpired() {
        return this.getRemainingExpiry() == 0L;
    }
}

