/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.persistence.clientqueue.ClientQueuePersistence;
import com.hivemq.persistence.clientsession.ClientSessionPersistence;
import com.hivemq.persistence.clientsession.ClientSessionSubscriptionPersistence;
import com.hivemq.persistence.ioc.annotation.Persistence;
import com.hivemq.persistence.retained.RetainedMessagePersistence;
import com.hivemq.persistence.util.FutureUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ScheduledCleanUpService {
    static final int NUMBER_OF_PERSISTENCES = 4;
    public static final int CLIENT_SESSION_PERSISTENCE_INDEX = 0;
    public static final int SUBSCRIPTION_PERSISTENCE_INDEX = 1;
    public static final int RETAINED_MESSAGES_PERSISTENCE_INDEX = 2;
    public static final int CLIENT_QUEUE_PERSISTENCE_INDEX = 3;
    private static final Logger log = LoggerFactory.getLogger(ScheduledCleanUpService.class);
    @NotNull
    private final ListeningScheduledExecutorService scheduledExecutorService;
    @NotNull
    private final ClientSessionPersistence clientSessionPersistence;
    @NotNull
    private final ClientSessionSubscriptionPersistence subscriptionPersistence;
    @NotNull
    private final RetainedMessagePersistence retainedMessagePersistence;
    @NotNull
    private final ClientQueuePersistence clientQueuePersistence;
    private int bucketIndex = 0;
    private int persistenceIndex = 0;
    private final int persistenceBucketCount;
    private final int cleanUpJobSchedule;
    private final int cleanUpTaskTimeoutSec;

    @Inject
    public ScheduledCleanUpService(@Persistence @NotNull ListeningScheduledExecutorService scheduledExecutorService, @NotNull ClientSessionPersistence clientSessionPersistence, @NotNull ClientSessionSubscriptionPersistence subscriptionPersistence, @NotNull RetainedMessagePersistence retainedMessagePersistence, @NotNull ClientQueuePersistence clientQueuePersistence) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.clientSessionPersistence = clientSessionPersistence;
        this.subscriptionPersistence = subscriptionPersistence;
        this.retainedMessagePersistence = retainedMessagePersistence;
        this.clientQueuePersistence = clientQueuePersistence;
        this.persistenceBucketCount = InternalConfigurations.PERSISTENCE_BUCKET_COUNT.get();
        this.cleanUpJobSchedule = InternalConfigurations.INTERVAL_BETWEEN_CLEANUP_JOBS_SEC.get();
        this.cleanUpTaskTimeoutSec = 300;
    }

    @PostConstruct
    public void postConstruct() {
        for (int i = 0; i < 1; ++i) {
            this.scheduleCleanUpTask();
        }
    }

    @VisibleForTesting
    synchronized void scheduleCleanUpTask() {
        if (this.scheduledExecutorService.isShutdown()) {
            return;
        }
        ListenableScheduledFuture schedule = this.scheduledExecutorService.schedule((Callable)new CleanUpTask(this, this.scheduledExecutorService, this.cleanUpTaskTimeoutSec, this.bucketIndex, this.persistenceIndex), (long)this.cleanUpJobSchedule, TimeUnit.SECONDS);
        this.persistenceIndex = (this.persistenceIndex + 1) % 4;
        if (this.persistenceIndex == 0) {
            this.bucketIndex = (this.bucketIndex + 1) % this.persistenceBucketCount;
        }
        FutureUtils.addExceptionLogger(schedule);
    }

    public ListenableFuture<Void> cleanUp(int bucketIndex, int persistenceIndex) {
        switch (persistenceIndex) {
            case 0: {
                return this.clientSessionPersistence.cleanUp(bucketIndex);
            }
            case 1: {
                return this.subscriptionPersistence.cleanUp(bucketIndex);
            }
            case 2: {
                return this.retainedMessagePersistence.cleanUp(bucketIndex);
            }
            case 3: {
                return this.clientQueuePersistence.cleanUp(bucketIndex);
            }
        }
        log.error("Unknown persistence index " + persistenceIndex);
        return Futures.immediateFuture(null);
    }

    @VisibleForTesting
    static final class CleanUpTask
    implements Callable<Void> {
        @NotNull
        private final ScheduledCleanUpService scheduledCleanUpService;
        @NotNull
        private final ListeningScheduledExecutorService scheduledExecutorService;
        private final int cleanUpTaskTimeoutSec;
        private final int bucketIndex;
        private final int persistenceIndex;

        @VisibleForTesting
        CleanUpTask(@NotNull ScheduledCleanUpService scheduledCleanUpService, @NotNull ListeningScheduledExecutorService scheduledExecutorService, int cleanUpTaskTimeoutSec, int bucketIndex, int persistenceIndex) {
            Preconditions.checkNotNull((Object)scheduledCleanUpService, (Object)"Clean up service must not be null");
            Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"Executor service must not be null");
            this.scheduledCleanUpService = scheduledCleanUpService;
            this.scheduledExecutorService = scheduledExecutorService;
            this.cleanUpTaskTimeoutSec = cleanUpTaskTimeoutSec;
            this.bucketIndex = bucketIndex;
            this.persistenceIndex = persistenceIndex;
        }

        @Override
        public Void call() {
            try {
                ListenableFuture<Void> future = this.scheduledCleanUpService.cleanUp(this.bucketIndex, this.persistenceIndex);
                Futures.addCallback(future, (FutureCallback)new FutureCallback<Void>(){

                    public void onSuccess(@Nullable Void aVoid) {
                        scheduledCleanUpService.scheduleCleanUpTask();
                    }

                    public void onFailure(Throwable throwable) {
                        if (throwable instanceof CancellationException) {
                            log.debug("Cleanup was cancelled (timeout).", throwable);
                        } else {
                            log.error("Exception during cleanup.", throwable);
                        }
                        scheduledCleanUpService.scheduleCleanUpTask();
                    }
                }, (Executor)MoreExecutors.directExecutor());
                Futures.withTimeout(future, (long)this.cleanUpTaskTimeoutSec, (TimeUnit)TimeUnit.SECONDS, (ScheduledExecutorService)this.scheduledExecutorService);
            }
            catch (Throwable throwable) {
                log.error("Exception in clean up job ", throwable);
                this.scheduledCleanUpService.scheduleCleanUpTask();
            }
            return null;
        }

        public int getBucketIndex() {
            return this.bucketIndex;
        }

        public int getPersistenceIndex() {
            return this.persistenceIndex;
        }
    }
}

