/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.util;

import com.google.common.base.Preconditions;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;

public class BatchedException
extends Exception {
    final Collection<Throwable> throwables;

    public BatchedException(Collection<Throwable> throwables) {
        Preconditions.checkArgument((throwables.size() > 1 ? 1 : 0) != 0, (Object)"throwables.size() must be greater than 1");
        this.throwables = throwables;
    }

    public Collection<Throwable> getThrowables() {
        return this.throwables;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public void printStackTrace() {
        for (Throwable throwable : this.throwables) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        for (Throwable throwable : this.throwables) {
            throwable.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        for (Throwable throwable : this.throwables) {
            throwable.printStackTrace(s);
        }
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        int size = 0;
        for (Throwable throwable : this.throwables) {
            size += throwable.getStackTrace().length;
        }
        StackTraceElement[] stackTraceElements = new StackTraceElement[size];
        int i = 0;
        for (Throwable throwable : this.throwables) {
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            int n = stackTraceElementArray.length;
            for (int j = 0; j < n; ++j) {
                StackTraceElement stackTraceElement;
                stackTraceElements[i] = stackTraceElement = stackTraceElementArray[j];
                ++i;
            }
        }
        return stackTraceElements;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        for (Throwable throwable : this.throwables) {
            stringBuilder.append(", ").append(throwable);
        }
        return stringBuilder.toString();
    }
}

