/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.security.ssl;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.security.auth.SslClientCertificate;
import com.hivemq.security.exception.PropertyNotFoundException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

public class SslClientCertificateImpl
implements SslClientCertificate {
    private final Certificate[] certificates;

    public SslClientCertificateImpl(@NotNull Certificate[] certificates) {
        Preconditions.checkNotNull((Object)certificates, (Object)"Certificates must not be null");
        this.certificates = certificates;
    }

    @Override
    public Certificate certificate() {
        return this.certificates[0];
    }

    @Override
    public Certificate[] certificateChain() {
        return this.certificates;
    }

    @Override
    public String commonName() {
        return this.certificateProperty(BCStyle.CN);
    }

    @Override
    public String organization() {
        return this.certificateProperty(BCStyle.O);
    }

    @Override
    public String organizationalUnit() {
        return this.certificateProperty(BCStyle.OU);
    }

    @Override
    public String title() {
        return this.certificateProperty(BCStyle.T);
    }

    @Override
    public String serial() {
        return this.certificateProperty(BCStyle.SN);
    }

    @Override
    public String country() {
        return this.certificateProperty(BCStyle.C);
    }

    @Override
    public String locality() {
        return this.certificateProperty(BCStyle.L);
    }

    @Override
    public String state() {
        return this.certificateProperty(BCStyle.ST);
    }

    private String certificateProperty(ASN1ObjectIdentifier objectIdentifier) {
        try {
            X509Certificate cert = (X509Certificate)this.certificate();
            String subjectProperty = this.subjectProperty(objectIdentifier, cert);
            if (subjectProperty != null) {
                return subjectProperty;
            }
            if (objectIdentifier.equals((ASN1Primitive)BCStyle.SN)) {
                return cert.getSerialNumber().toString();
            }
            Extension extension = new JcaX509CertificateHolder(cert).getExtension(objectIdentifier);
            if (extension == null) {
                return null;
            }
            return extension.getParsedValue().toString();
        }
        catch (Exception e) {
            throw new PropertyNotFoundException("Not able to get property from certificate", e);
        }
    }

    @Nullable
    private String subjectProperty(ASN1ObjectIdentifier objectIdentifier, X509Certificate cert) throws CertificateEncodingException {
        X500Name x500name = new JcaX509CertificateHolder(cert).getSubject();
        RDN[] rdNs = x500name.getRDNs(objectIdentifier);
        if (rdNs.length < 1) {
            return null;
        }
        RDN cn = rdNs[0];
        return IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
    }
}

