/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.statistics.collectors;

import com.google.common.annotations.VisibleForTesting;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.sun.jna.Platform;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudPlatform {
    private static final Logger log = LoggerFactory.getLogger(CloudPlatform.class);

    public String getCloudPlatform() {
        try {
            String content;
            if (!Platform.isLinux()) {
                return null;
            }
            File uuidFile = this.getUuidFile();
            if (uuidFile.exists() && uuidFile.canRead() && ((content = FileUtils.readFileToString((File)uuidFile, (Charset)StandardCharsets.UTF_8)).startsWith("ec2") || content.startsWith("EC2"))) {
                return "AWS EC2";
            }
        }
        catch (Exception ex) {
            log.trace("not able to determine if running on cloud platform", (Throwable)ex);
        }
        return null;
    }

    @NotNull
    @VisibleForTesting
    File getUuidFile() {
        return new File("/sys/hypervisor/uuid");
    }
}

