/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.util;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;

public final class Reflections {
    private Reflections() {
    }

    public static <T extends Annotation> Optional<T> getMethodAnnotationFromInterface(@NotNull Method method, @NotNull Class<? extends T> annotation) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = method.getDeclaringClass().getInterfaces()) {
            Method[] interfaceMethods;
            for (Method interfaceMethod : interfaceMethods = anInterface.getMethods()) {
                if (!Reflections.methodSignatureEquals(method, interfaceMethod)) continue;
                return Optional.ofNullable(interfaceMethod.getAnnotation(annotation));
            }
        }
        return Optional.empty();
    }

    private static boolean methodSignatureEquals(@NotNull Method method, @NotNull Method anotherMethod) {
        if (method.getReturnType().equals(anotherMethod.getReturnType()) && method.getName().equals(anotherMethod.getName())) {
            return Arrays.equals(method.getParameterTypes(), anotherMethod.getParameterTypes());
        }
        return false;
    }
}

