/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.util;

import com.hivemq.extension.sdk.api.annotations.NotNull;

public class ThreadPreConditions {
    public static final String SINGLE_WRITER_THREAD_PREFIX = "single-writer";
    public static final String NETTY_NATIVE_CHILD_EVENTLOOP = "hivemq-native-eventloop-child";
    public static final String NETTY_CHILD_EVENTLOOP = "hivemq-eventloop-child";
    private static boolean enabled = false;

    public static boolean enabled() {
        return enabled;
    }

    public static void enable() {
        enabled = true;
    }

    public static void disable() {
        enabled = false;
    }

    public static void startsWith(@NotNull String prefix) {
        if (!enabled) {
            return;
        }
        String name = Thread.currentThread().getName();
        if (!name.startsWith(prefix)) {
            throw new ThreadPreConditionException("Thread name doesn't start with '" + prefix + "' as expected. Thread name: '" + name + "'.");
        }
    }

    public static void inNettyChildEventloop() {
        if (!enabled) {
            return;
        }
        String name = Thread.currentThread().getName();
        if (!name.startsWith(NETTY_NATIVE_CHILD_EVENTLOOP) && !name.startsWith(NETTY_CHILD_EVENTLOOP)) {
            throw new ThreadPreConditionException("Thread name doesn't start with 'hivemq-native-eventloop-child' as expected. Thread name: '" + name + "'.");
        }
    }

    static {
        String enableThreadPreconditionString = System.getProperty("TEST_ENABLE_THREAD_PRECONDITION");
        if (enableThreadPreconditionString != null) {
            enabled = Boolean.parseBoolean(enableThreadPreconditionString);
        }
    }

    public static class ThreadPreConditionException
    extends RuntimeException {
        public ThreadPreConditionException(@NotNull String message) {
            super(message);
        }
    }
}

