/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.websocket;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.hivemq.configuration.service.entity.WebsocketListener;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.websocket.MQTTWebsocketEncoder;
import com.hivemq.websocket.WebSocketBinaryFrameHandler;
import com.hivemq.websocket.WebSocketContinuationFrameHandler;
import com.hivemq.websocket.WebSocketTextFrameHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;

public class WebSocketInitializer {
    public static final int WEBSOCKET_MAX_CONTENT_LENGTH = 65536;
    private final WebsocketListener websocketListener;

    public WebSocketInitializer(WebsocketListener websocketListener) {
        this.websocketListener = websocketListener;
    }

    public void addHandlers(Channel ch, @NotNull String handlerBefore) {
        ch.pipeline().addAfter(handlerBefore, "http_server_codec", (ChannelHandler)new HttpServerCodec());
        ch.pipeline().addAfter("http_server_codec", "http_object_aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
        String webSocketPath = this.websocketListener.getPath();
        String subprotocols = this.getSubprotocolString();
        boolean allowExtensions = this.websocketListener.getAllowExtensions();
        ch.pipeline().addAfter("http_object_aggregator", "websocket_server_protocol_handler", (ChannelHandler)new WebSocketServerProtocolHandler(webSocketPath, subprotocols, allowExtensions, Integer.MAX_VALUE));
        ch.pipeline().addAfter("websocket_server_protocol_handler", "websocket_binary_frame_handler", (ChannelHandler)new WebSocketBinaryFrameHandler());
        ch.pipeline().addAfter("websocket_binary_frame_handler", "websocket_continuation_frame_handler", (ChannelHandler)new WebSocketContinuationFrameHandler());
        ch.pipeline().addAfter("websocket_binary_frame_handler", "websocket_text_frame_handler", (ChannelHandler)new WebSocketTextFrameHandler());
        ch.pipeline().addAfter("websocket_text_frame_handler", "mqtt_websocket_encoder", (ChannelHandler)new MQTTWebsocketEncoder());
    }

    @VisibleForTesting
    String getSubprotocolString() {
        return Joiner.on((String)",").join(this.websocketListener.getSubprotocols());
    }
}

