/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import org.apache.qpid.server.protocol.v1_0.LinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.Link_1_0;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.BaseSource;
import org.apache.qpid.server.protocol.v1_0.type.BaseTarget;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.DeliveryState;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.transport.Attach;
import org.apache.qpid.server.protocol.v1_0.type.transport.Detach;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;
import org.apache.qpid.server.protocol.v1_0.type.transport.Flow;
import org.apache.qpid.server.protocol.v1_0.type.transport.ReceiverSettleMode;
import org.apache.qpid.server.protocol.v1_0.type.transport.Role;
import org.apache.qpid.server.protocol.v1_0.type.transport.SenderSettleMode;

public class ErrantLinkEndpoint<S extends BaseSource, T extends BaseTarget>
implements LinkEndpoint<S, T> {
    private final Link_1_0<S, T> _link;
    private final Session_1_0 _session;
    private final Error _error;
    private UnsignedInteger _localHandle;

    ErrantLinkEndpoint(Link_1_0<S, T> link, Session_1_0 session, Error error) {
        this._link = link;
        this._session = session;
        this._error = error;
    }

    @Override
    public Role getRole() {
        return this._link.getRole();
    }

    @Override
    public S getSource() {
        return null;
    }

    @Override
    public T getTarget() {
        return null;
    }

    @Override
    public Session_1_0 getSession() {
        return this._session;
    }

    @Override
    public UnsignedInteger getLocalHandle() {
        return this._localHandle;
    }

    @Override
    public void setLocalHandle(UnsignedInteger localHandle) {
        this._localHandle = localHandle;
    }

    @Override
    public void sendAttach() {
        Attach attachToSend = new Attach();
        attachToSend.setName(this._link.getName());
        attachToSend.setRole(this.getRole());
        attachToSend.setHandle(this.getLocalHandle());
        if (this.getRole() == Role.SENDER) {
            attachToSend.setInitialDeliveryCount(UnsignedInteger.ZERO);
        }
        attachToSend.setSource((BaseSource)this.getSource());
        attachToSend.setTarget((BaseTarget)this.getTarget());
        this._session.sendAttach(attachToSend);
    }

    @Override
    public void receiveAttach(Attach attach) throws AmqpErrorException {
        throw new UnsupportedOperationException("This Link is errant");
    }

    @Override
    public void destroy() {
        this.setLocalHandle(null);
        this._link.discardEndpoint();
    }

    public void closeWithError() {
        this.close(this._error);
    }

    @Override
    public void close(Error error) {
        Detach detach = new Detach();
        detach.setHandle(this._localHandle);
        detach.setClosed(true);
        detach.setError(error);
        this._session.sendDetach(detach);
        this._session.dissociateEndpoint(this);
        this.destroy();
        this._link.linkClosed();
    }

    @Override
    public SenderSettleMode getSendingSettlementMode() {
        return null;
    }

    @Override
    public ReceiverSettleMode getReceivingSettlementMode() {
        return null;
    }

    @Override
    public void remoteDetached(Detach detach) {
    }

    @Override
    public void receiveDeliveryState(Binary deliveryTag, DeliveryState state, Boolean settled) {
    }

    @Override
    public void receiveFlow(Flow flow) {
        throw new UnsupportedOperationException("This Link is errant");
    }

    @Override
    public void sendFlow() {
        throw new UnsupportedOperationException("This Link is errant");
    }

    @Override
    public void flowStateChanged() {
        throw new UnsupportedOperationException("This Link is errant");
    }

    @Override
    public void start() {
        throw new UnsupportedOperationException("This Link is errant");
    }

    @Override
    public void setStopped(boolean stopped) {
        throw new UnsupportedOperationException("This Link is errant");
    }

    @Override
    public void receiveComplete() {
    }
}

