/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.OsUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import org.apache.commons.validator.routines.InetAddressValidator;

public class NetUtils {
    public static final String PROP_INCONTAINER = "iip.inContainer";
    public static final String NO_MASK = "";

    private NetUtils() {
    }

    public static int getEphemeralPort() {
        int result = 0;
        try {
            ServerSocket s = new ServerSocket(0);
            result = s.getLocalPort();
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static String getOwnIP(String netMask) {
        String result = "127.0.0.1";
        if (null == netMask || netMask.length() == 0) {
            result = NetUtils.getOwnIP();
        } else {
            netMask = netMask.replaceAll("255", "\\\\d{1,3}");
            if (!(netMask = netMask.replaceAll("\\.", "\\\\.")).startsWith("^")) {
                netMask = "^" + netMask;
            }
            boolean found = false;
            try {
                Pattern pat = Pattern.compile(netMask);
                Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
                while (ifs.hasMoreElements()) {
                    NetworkInterface ni = ifs.nextElement();
                    for (InterfaceAddress addr : ni.getInterfaceAddresses()) {
                        String tmp = addr.getAddress().getHostAddress();
                        if (!pat.matcher(tmp).matches()) continue;
                        result = tmp;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
            }
            catch (SocketException | PatternSyntaxException exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean isOwnAddress(String host) {
        boolean isOwn = false;
        try {
            InetAddress givenHost = InetAddress.getByName(host);
            Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
            block2: while (!isOwn && ifs.hasMoreElements()) {
                NetworkInterface ni = ifs.nextElement();
                for (InterfaceAddress addr : ni.getInterfaceAddresses()) {
                    if (!addr.getAddress().equals(givenHost)) continue;
                    isOwn = true;
                    continue block2;
                }
            }
        }
        catch (SocketException | UnknownHostException iOException) {
            // empty catch block
        }
        return isOwn;
    }

    public static String getOwnIP() {
        String ip;
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            ip = socket.getLocalAddress().getHostAddress();
            if ("0.0.0.0".equals(ip)) {
                ip = NetUtils.findFallbackIP();
            }
        }
        catch (UncheckedIOException | SocketException | UnknownHostException e) {
            ip = "127.0.0.1";
        }
        return ip;
    }

    private static String findFallbackIP() {
        String result = "127.0.0.1";
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(nets)) {
                Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
                String ipV4 = null;
                String ipV6 = null;
                for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                    if (inetAddress.isLoopbackAddress()) continue;
                    if (inetAddress.getAddress().length == 4) {
                        ipV4 = inetAddress.getHostAddress();
                        continue;
                    }
                    ipV6 = inetAddress.getHostAddress();
                }
                if (ipV4 == null || ipV6 == null || NetUtils.isContainerIp(ipV4)) continue;
                result = ipV4;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isContainerIp(String address) {
        return address.startsWith("172.17.");
    }

    public static boolean isInContainer() {
        boolean inContainer = false;
        String tmp = OsUtils.getPropertyOrEnv(PROP_INCONTAINER);
        if (null == tmp) {
            if (OsUtils.isWindows()) {
                try {
                    Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
                    for (NetworkInterface netint : Collections.list(nets)) {
                        Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
                        for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                            if (!NetUtils.isContainerIp(inetAddress.getHostAddress())) continue;
                            inContainer = true;
                            break;
                        }
                        if (!inContainer) continue;
                    }
                }
                catch (SocketException socketException) {}
            } else {
                inContainer = NetUtils.isRunningInsideDocker();
            }
        } else {
            inContainer = Boolean.valueOf(tmp);
        }
        return inContainer;
    }

    private static Boolean isRunningInsideDocker() {
        Boolean bl;
        block8: {
            Stream<String> stream = Files.lines(Paths.get("/proc/1/cgroup", new String[0]));
            try {
                bl = stream.anyMatch(line -> line.contains("/docker"));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }

    public static String getOwnHostname() {
        String result;
        try {
            result = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            result = "localhost";
        }
        return result;
    }

    public static boolean isAvailable(String host, int port) {
        boolean result = false;
        try {
            Socket sock = new Socket(host, port);
            sock.close();
            result = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isIpV4Addess(String address) {
        return InetAddressValidator.getInstance().isValidInet4Address(address);
    }

    public static String getNetMask(String netMask, String fallbackIp) {
        String result;
        if (NetUtils.isIpV4Addess(netMask)) {
            result = netMask;
        } else if (NetUtils.isIpV4Addess(fallbackIp)) {
            int pos = fallbackIp.lastIndexOf(46);
            result = fallbackIp.substring(0, pos + 1) + "255";
        } else {
            result = NO_MASK;
        }
        return result;
    }

    public static URL createURL(String url) throws IllegalArgumentException {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean connectionOk(String url) {
        try {
            return NetUtils.connectionOk(new URL(url));
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean connectionOk(URL url) {
        boolean connectionOk = false;
        try {
            URLConnection conn = url.openConnection();
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection huc = (HttpURLConnection)url.openConnection();
                int responseCode = huc.getResponseCode();
                connectionOk = responseCode == 200;
                huc.disconnect();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return connectionOk;
    }
}

