/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.plugins;

import de.iip_ecosphere.platform.support.plugins.ChildClassLoader;
import de.iip_ecosphere.platform.support.plugins.CompoundEnumeration;
import de.iip_ecosphere.platform.support.plugins.FindClassClassLoader;
import de.iip_ecosphere.platform.support.plugins.IdentifyingClassloader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.function.Function;

public class ChildFirstClassLoader
extends ClassLoader
implements IdentifyingClassloader {
    private ChildClassLoader childClassLoader;

    public ChildFirstClassLoader(Function<FindClassClassLoader, ChildClassLoader> creator) {
        this(creator, null);
    }

    public ChildFirstClassLoader(Function<FindClassClassLoader, ChildClassLoader> creator, ClassLoader parent) {
        super(null == parent ? Thread.currentThread().getContextClassLoader() : parent);
        this.childClassLoader = creator.apply(new FindClassClassLoader(this.getParent()));
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.childClassLoader.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name, resolve);
        }
    }

    @Override
    public URL getResource(String name) {
        URL result = this.childClassLoader.getResource(name);
        if (result == null) {
            result = super.getResource(name);
        }
        return result;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] tmp = new Enumeration[2];
        int index = 0;
        IOException ex1 = null;
        IOException ex2 = null;
        try {
            tmp[index++] = this.childClassLoader.getResources(name);
        }
        catch (IOException ex) {
            ex1 = ex;
        }
        try {
            tmp[index++] = super.getResources(name);
        }
        catch (IOException ex) {
            ex2 = ex;
        }
        if (ex1 != null && ex2 != null) {
            throw ex1;
        }
        return new CompoundEnumeration<URL>(tmp);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream result = this.childClassLoader.getResourceAsStream(name);
        if (null == result) {
            result = super.getResourceAsStream(name);
        }
        return result;
    }

    @Override
    public void setClassAssertionStatus(String className, boolean enabled) {
        this.childClassLoader.setClassAssertionStatus(className, enabled);
        super.setClassAssertionStatus(className, enabled);
    }

    @Override
    public void clearAssertionStatus() {
        this.childClassLoader.clearAssertionStatus();
        super.clearAssertionStatus();
    }

    @Override
    public void setDefaultAssertionStatus(boolean enabled) {
        this.childClassLoader.setDefaultAssertionStatus(enabled);
        super.setDefaultAssertionStatus(enabled);
    }

    @Override
    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        this.childClassLoader.setPackageAssertionStatus(packageName, enabled);
        super.setPackageAssertionStatus(packageName, enabled);
    }

    @Override
    public boolean amI(ClassLoader loader) {
        return this == loader || this.childClassLoader == loader;
    }

    public String toString() {
        return super.toString() + " with child " + this.childClassLoader;
    }
}

