/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.resources;

import de.iip_ecosphere.platform.support.resources.FolderResourceResolver;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.InputStream;
import java.util.List;

public class MultiResourceResolver
implements ResourceResolver {
    public static final ResourceResolver SETUP_RESOLVER = new MultiResourceResolver(new FolderResourceResolver("."), new FolderResourceResolver("/etc"), new FolderResourceResolver());
    private ResourceResolver[] resolvers;

    public MultiResourceResolver(ResourceResolver ... resolvers) {
        this.resolvers = resolvers;
    }

    public MultiResourceResolver(List<ResourceResolver> resolvers) {
        this(resolvers.toArray(new ResourceResolver[0]));
    }

    @Override
    public String getName() {
        String name = "Multi resource resolver: ";
        int count = 0;
        for (ResourceResolver r : this.resolvers) {
            if (count > 0) {
                name = name + ", ";
            }
            name = name + r.getName();
            ++count;
        }
        return name;
    }

    @Override
    public InputStream resolve(ClassLoader loader, String resource) {
        InputStream result = null;
        for (int r = 0; null == result && r < this.resolvers.length; ++r) {
            result = this.resolvers[r].resolve(loader, resource);
        }
        return result;
    }
}

