/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.ParameterConfigurer;
import de.iip_ecosphere.platform.services.environment.ParameterConfigurerProvider;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.ValueConfigurer;
import de.iip_ecosphere.platform.services.environment.YamlArtifact;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.ObjectUtils;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.Version;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.net.ManagedServerAddress;
import de.iip_ecosphere.platform.support.net.NetworkManagerFactory;
import de.iip_ecosphere.platform.support.resources.FolderResourceResolver;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class AbstractService
implements Service {
    private static ClassLoader loader = AbstractService.class.getClassLoader();
    private String id;
    private String name;
    private Version version;
    private String description;
    private boolean isDeployable;
    private boolean isTopLevel;
    private ServiceKind kind;
    private ServiceState state;
    private ManagedServerAddress netKeyMgtAddress;
    private Map<Class<?>, TypeCreator<?>> typeCreators = new HashMap();

    protected AbstractService(ServiceKind kind) {
        this("", kind);
    }

    protected AbstractService(String id, ServiceKind kind) {
        this(id, "", new Version(new int[]{0, 0, 0}), "", true, true, kind);
    }

    protected AbstractService(String id, String name, Version version, String description, boolean isDeployable, boolean isTopLevel, ServiceKind kind) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.description = description;
        this.isDeployable = isDeployable;
        this.isTopLevel = isTopLevel;
        this.kind = kind;
        this.state = ServiceState.AVAILABLE;
    }

    protected AbstractService(YamlService yaml) {
        this(yaml.getId(), yaml.getName(), yaml.getVersion(), yaml.getDescription(), yaml.isDeployable(), yaml.isTopLevel(), yaml.getKind());
        if (null != yaml.getNetMgtKey() && yaml.getNetMgtKey().length() > 0) {
            this.netKeyMgtAddress = NetworkManagerFactory.getInstance().getPort(yaml.getNetMgtKey());
        }
        this.initializeFrom(yaml);
    }

    protected AbstractService(String serviceId, InputStream ymlFile) {
        this(YamlArtifact.readFromYamlSafe(ymlFile).getServiceSafe(serviceId));
    }

    protected void initializeFrom(YamlService yaml) {
    }

    public static void setLibJars(URL[] jars) {
        if (null != jars) {
            loader = new URLClassLoader(jars, loader);
        }
    }

    public static <S extends Service> S createInstance(String className, Class<S> cls) {
        return AbstractService.createInstance(loader, className, cls, null, null);
    }

    public static <S extends Service> S createInstance(String className, Class<S> cls, String serviceId, String deploymentDescFile) {
        return AbstractService.createInstance(loader, className, cls, serviceId, deploymentDescFile);
    }

    public static InputStream getResourceAsStream(ClassLoader loader, String resource) {
        return ResourceLoader.getResourceAsStream((ClassLoader)loader, (String)resource, (ResourceResolver[])new ResourceResolver[]{new FolderResourceResolver(new File("."))});
    }

    public static <S extends Service> S createInstance(ClassLoader loader, String className, Class<S> cls, String serviceId, String deploymentDescFile) {
        Service result;
        block15: {
            result = null;
            try {
                Constructor<?> cons3;
                Class<?> serviceClass = loader.loadClass(className);
                Object instance = null;
                if (null != serviceId && null != deploymentDescFile) {
                    try {
                        cons3 = serviceClass.getConstructor(String.class, InputStream.class);
                        InputStream desc = AbstractService.getResourceAsStream(loader, deploymentDescFile);
                        instance = cons3.newInstance(serviceId, desc);
                        if (null != desc) {
                            desc.close();
                        }
                    }
                    catch (NoSuchMethodException cons2) {
                    }
                    catch (InvocationTargetException e) {
                        LoggerFactory.getLogger(AbstractService.class).error("While instantiating " + className + ": " + e.getMessage() + ", falling back to default constructor", (Throwable)e);
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(AbstractService.class).error("While instantiating " + className + " here loading descriptor " + deploymentDescFile + ": " + e.getMessage() + ", falling back to default constructor");
                    }
                }
                if (null == instance && null != serviceId) {
                    try {
                        cons3 = serviceClass.getConstructor(String.class);
                        instance = cons3.newInstance(serviceId);
                    }
                    catch (NoSuchMethodException cons3) {
                    }
                    catch (InvocationTargetException e) {
                        LoggerFactory.getLogger(AbstractService.class).error("While instantiating " + className + ": " + e.getMessage() + ", falling back to default constructor");
                    }
                }
                if (null == instance) {
                    instance = serviceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                result = (Service)cls.cast(instance);
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                Object loaders = "";
                for (ClassLoader l = loader; null != l; l = l.getParent()) {
                    if (((String)loaders).length() > 0) {
                        loaders = (String)loaders + " -> ";
                    }
                    loaders = (String)loaders + l.getClass().getSimpleName();
                }
                LoggerFactory.getLogger(AbstractService.class).warn("Cannot instantiate service of type '" + className + " via " + (String)loaders + "': " + e.getClass().getSimpleName() + " " + e.getMessage() + ". Service '" + serviceId + "' will not be functional!");
                if (e.getCause() == null) break block15;
                LoggerFactory.getLogger(AbstractService.class).warn("Cause: {}", (Object)e.getMessage(), (Object)e.getCause());
                e.getCause().printStackTrace(System.out);
            }
        }
        return (S)result;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ServiceState getState() {
        return this.state;
    }

    @Override
    public void setState(ServiceState state) throws ExecutionException {
        ServiceState.validateTransition(this.state, state);
        ServiceState next = null;
        this.state = state;
        switch (state) {
            case STARTING: {
                next = this.start();
                break;
            }
            case STOPPING: {
                next = this.stop();
                break;
            }
        }
        if (null != next) {
            this.state = next;
        }
    }

    protected ServiceState start() throws ExecutionException {
        return ServiceState.RUNNING;
    }

    protected ServiceState stop() {
        return ServiceState.STOPPED;
    }

    @Override
    public boolean isDeployable() {
        return this.isDeployable;
    }

    @Override
    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    @Override
    public ServiceKind getKind() {
        return this.kind;
    }

    @Override
    public ServerAddress getNetMgtKeyAddress() {
        return this.netKeyMgtAddress;
    }

    @Override
    public void activate() throws ExecutionException {
        if (this.getState() == ServiceState.PASSIVATED) {
            this.setState(ServiceState.ACTIVATING);
            this.start();
            this.setState(ServiceState.RUNNING);
        }
    }

    @Override
    public void passivate() throws ExecutionException {
        if (this.getState() == ServiceState.RUNNING) {
            this.setState(ServiceState.PASSIVATING);
            this.stop();
            this.setState(ServiceState.PASSIVATED);
        }
    }

    public static <T> void addConfigurer(Map<String, ParameterConfigurer<?>> configurers, String name, Class<T> cls, TypeTranslator<String, T> trans, ValueConfigurer<T> cfg) {
        AbstractService.addConfigurer(configurers, name, cls, trans, cfg, null);
    }

    public static <T> void addConfigurer(Map<String, ParameterConfigurer<?>> configurers, String name, Class<T> cls, TypeTranslator<String, T> trans, ValueConfigurer<T> cfg, Supplier<T> getter) {
        AbstractService.addConfigurer(configurers, name, cls, trans, cfg, getter, null);
    }

    public static <T> void addConfigurer(Map<String, ParameterConfigurer<?>> configurers, String name, Class<T> cls, TypeTranslator<String, T> trans, ValueConfigurer<T> cfg, Supplier<T> getter, String systemProperty) {
        ParameterConfigurer<T> pc = new ParameterConfigurer<T>(name, cls, trans, cfg, getter);
        if (null != systemProperty && systemProperty.length() > 0) {
            pc.withSystemProperty(systemProperty);
        }
        configurers.put(name, pc);
    }

    public static void reconfigure(Map<String, String> values, ParameterConfigurerProvider provider, boolean rollback, ServiceState state) throws ExecutionException {
        if (null != provider) {
            HashMap<String, String> rollbackMap = rollback ? new HashMap<String, String>() : null;
            try {
                for (Map.Entry<String, String> ent : values.entrySet()) {
                    ParameterConfigurer<?> cfg = provider.getParameterConfigurer(ent.getKey());
                    if (null == cfg) continue;
                    AbstractService.reconf(cfg, ent.getKey(), ent.getValue(), rollbackMap);
                }
            }
            catch (ExecutionException e) {
                if (null != rollbackMap) {
                    for (Map.Entry ent : rollbackMap.entrySet()) {
                        try {
                            ParameterConfigurer<?> cfg = provider.getParameterConfigurer((String)ent.getKey());
                            if (null == cfg) continue;
                            AbstractService.reconf(cfg, (String)ent.getKey(), (String)ent.getValue(), rollbackMap);
                        }
                        catch (ExecutionException executionException) {}
                    }
                }
                throw e;
            }
        }
    }

    protected static <T> void reconf(ParameterConfigurer<T> configurer, String name, String value, Map<String, String> rollbackMap) throws ExecutionException {
        try {
            Supplier<T> getter;
            TypeTranslator<String, T> trans = configurer.getTranslator();
            if (null != rollbackMap && null != (getter = configurer.getGetter())) {
                T v = getter.get();
                rollbackMap.put(name, v == null ? null : (String)trans.from(v));
            }
            configurer.configure(null == value ? null : trans.to((Object)value));
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public void reconfigure(Map<String, String> values) throws ExecutionException {
        AbstractService.reconfigure(values, this, this.rollbackReconfigurationOnFailure(), this.getState());
        for (Map.Entry<String, String> c : values.entrySet()) {
            this.notifyReconfigured(c.getKey(), c.getValue());
        }
    }

    protected void notifyReconfigured(String paramName, String value) {
    }

    protected boolean rollbackReconfigurationOnFailure() {
        return true;
    }

    protected void transferData(Object source, Object target) {
        ObjectUtils.copyFieldsSafe((Object)source, (Object)target);
    }

    @Override
    public <T> void addTypeSubstitution(Class<? super T> cls, Class<T> actCls, Supplier<T> creator) {
        if (null != cls && null != creator) {
            this.typeCreators.put(cls, new TypeCreator<T>(actCls, creator));
        }
    }

    @Override
    public <T> Class<? extends T> getSubstitutedType(Class<T> cls) {
        TypeCreator<?> regCreator = this.typeCreators.get(cls);
        return null == regCreator ? cls : regCreator.getType();
    }

    @Override
    public <T> Supplier<T> getTypeCreator(Class<T> cls, Supplier<T> creator) {
        TypeCreator<?> regCreator = this.typeCreators.get(cls);
        return regCreator == null ? creator : regCreator.getCreator();
    }

    @Override
    public Map<Class<?>, Class<?>> getTypeSubstitutions() {
        return this.typeCreators.entrySet().stream().collect(Collectors.toMap(e -> (Class)e.getKey(), e -> ((TypeCreator)e.getValue()).getType()));
    }

    private static class TypeCreator<T> {
        private Class<T> cls;
        private Supplier<T> creator;

        private TypeCreator(Class<T> cls, Supplier<T> creator) {
            this.cls = cls;
            this.creator = creator;
        }

        public Class<?> getType() {
            return this.cls;
        }

        public Supplier<T> getCreator() {
            return this.creator;
        }
    }
}

