/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.ParameterConfigurer;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslators;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;

public class ConnectorServiceWrapper<O, I, CO, CI>
extends AbstractService {
    private Connector<O, I, CO, CI> connector;
    private Supplier<ConnectorParameter> connParamSupplier;
    private Map<String, ParameterConfigurer<?>> paramConfigurers = new HashMap();
    private String outPath;
    private String inPath;

    public ConnectorServiceWrapper(YamlService yaml, Connector<O, I, CO, CI> connector, Supplier<ConnectorParameter> connParamSupplier) {
        super(yaml);
        this.connector = connector;
        this.connParamSupplier = connParamSupplier;
        AbstractService.addConfigurer(this.paramConfigurers, "outPath", String.class, TypeTranslators.STRING, v -> this.setOutPath((String)v), () -> this.outPath, "iip.app." + this.getId() + ".outPath");
        AbstractService.addConfigurer(this.paramConfigurers, "inPath", String.class, TypeTranslators.STRING, v -> this.setInPath((String)v), () -> this.inPath, "iip.app." + this.getId() + ".inPath");
    }

    public Connector<O, I, CO, CI> getConnector() {
        return this.connector;
    }

    public void send(CI data) {
        try {
            this.connector.write(data);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Data loss, cannot send data: " + e.getMessage());
        }
    }

    public void setReceptionCallback(ReceptionCallback<CO> callback) {
        try {
            this.connector.setReceptionCallback(callback);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Data loss, cannot set reception callback: " + e.getMessage());
        }
    }

    @Override
    public void setState(ServiceState state) throws ExecutionException {
        this.doSetState(state);
        try {
            if (ServiceState.STARTING == state) {
                ConnectorParameter param = this.connParamSupplier.get();
                this.connector.connect(param);
                this.connector.enableNotifications(param.getNotificationInterval() == 0);
                this.doSetState(ServiceState.RUNNING);
            } else if (ServiceState.STOPPING == state) {
                this.connector.disconnect();
                this.doSetState(ServiceState.STOPPED);
            } else if (ServiceState.UNDEPLOYING == state) {
                this.connector.dispose();
            }
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    protected void doSetState(ServiceState state) throws ExecutionException {
        super.setState(state);
    }

    @Override
    public void migrate(String resourceId) throws ExecutionException {
    }

    @Override
    public void update(URI location) throws ExecutionException {
    }

    @Override
    public void switchTo(String targetId) throws ExecutionException {
    }

    public void enablePolling(boolean enablePolling) {
        this.connector.enablePolling(enablePolling);
    }

    public void enableNotifications(boolean enableNotifications) {
        this.connector.enableNotifications(enableNotifications);
    }

    @Override
    public ParameterConfigurer<?> getParameterConfigurer(String paramName) {
        return this.paramConfigurers.get(paramName);
    }

    @Override
    public Set<String> getParameterNames() {
        return this.paramConfigurers.keySet();
    }

    private void setInPath(String inPath) {
        if (inPath != null && inPath.length() > 0) {
            this.inPath = inPath;
        }
    }

    private void setOutPath(String outPath) {
        if (outPath != null && outPath.length() > 0) {
            this.outPath = outPath;
        }
    }

    public String getOutPath(String cfgPath) {
        String result = cfgPath;
        if (this.outPath != null) {
            result = this.outPath;
        }
        return result;
    }

    public String getInPath(String cfgPath) {
        String result = cfgPath;
        if (this.inPath != null) {
            result = this.inPath;
        }
        return result;
    }
}

