/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy;

import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.AbstractK8SJavaProxy;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.HttpDeleteWithBody;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.K8SRequest;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.ProxyType;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;

public class HttpK8SJavaProxy
extends AbstractK8SJavaProxy {
    private CloseableHttpClient httpClient;
    private boolean tlsCheck;

    public HttpK8SJavaProxy(ProxyType proxyType, String serverIP, String serverPort, boolean tlsCheck) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        super(proxyType, HttpK8SJavaProxy.getServerAddress(proxyType, serverIP, serverPort, tlsCheck));
        this.tlsCheck = tlsCheck;
        this.httpClient = tlsCheck ? this.getSSLHttpClients() : HttpClients.createDefault();
    }

    @Override
    public byte[] executeK8SGet(BufferedOutputStream writer, K8SRequest request) throws ClientProtocolException, IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException {
        String url = this.getServerAddress() + request.getPath();
        HttpGet httpGetRequest = new HttpGet(url);
        for (String[] value : request.getHeaders().values()) {
            httpGetRequest.addHeader(value[0], value[1]);
        }
        byte[] response = null;
        if (request.getPath().contains("&watch=true")) {
            CloseableHttpClient httpNewClient = null;
            httpNewClient = this.tlsCheck ? this.getSSLHttpClients() : HttpClients.createDefault();
            CloseableHttpResponse httpResponse = httpNewClient.execute((HttpUriRequest)httpGetRequest);
            response = this.formatWatchK8SResponse(writer, request, (HttpResponse)httpResponse);
            httpNewClient.close();
        } else {
            CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpGetRequest);
            response = this.formatK8SResponse(request, (HttpResponse)httpResponse);
        }
        httpGetRequest.releaseConnection();
        return response;
    }

    @Override
    public byte[] executeK8SPost(K8SRequest request) throws ClientProtocolException, IOException {
        String url = this.getServerAddress() + request.getPath();
        HttpPost httpPostRequest = new HttpPost(url);
        for (String[] value : request.getHeaders().values()) {
            if (value[0].toUpperCase().contains("CONTENT-LENGTH")) continue;
            httpPostRequest.addHeader(value[0], value[1]);
        }
        httpPostRequest.setEntity((HttpEntity)new ByteArrayEntity(request.getPayload()));
        CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPostRequest);
        byte[] response = this.formatK8SResponse(request, (HttpResponse)httpResponse);
        httpPostRequest.releaseConnection();
        return response;
    }

    @Override
    public byte[] executeK8SPut(K8SRequest request) throws ClientProtocolException, IOException {
        String url = this.getServerAddress() + request.getPath();
        HttpPut httpPutRequest = new HttpPut(url);
        for (String[] value : request.getHeaders().values()) {
            if (value[0].toUpperCase().contains("CONTENT-LENGTH")) continue;
            httpPutRequest.addHeader(value[0], value[1]);
        }
        httpPutRequest.setEntity((HttpEntity)new ByteArrayEntity(request.getPayload()));
        CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPutRequest);
        byte[] response = this.formatK8SResponse(request, (HttpResponse)httpResponse);
        httpPutRequest.releaseConnection();
        return response;
    }

    @Override
    public byte[] executeK8SPatch(K8SRequest request) throws ClientProtocolException, IOException {
        String url = this.getServerAddress() + request.getPath();
        HttpPatch httpPatchRequest = new HttpPatch(url);
        for (String[] value : request.getHeaders().values()) {
            if (value[0].toUpperCase().contains("CONTENT-LENGTH")) continue;
            httpPatchRequest.addHeader(value[0], value[1]);
        }
        httpPatchRequest.setEntity((HttpEntity)new ByteArrayEntity(request.getPayload()));
        CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPatchRequest);
        byte[] response = this.formatK8SResponse(request, (HttpResponse)httpResponse);
        httpPatchRequest.releaseConnection();
        return response;
    }

    @Override
    public byte[] executeK8SDelete(K8SRequest request) throws ClientProtocolException, IOException {
        String url = this.getServerAddress() + request.getPath();
        HttpDeleteWithBody httpDeleteRequest = new HttpDeleteWithBody(url);
        for (String[] value : request.getHeaders().values()) {
            if (value[0].toUpperCase().contains("CONTENT-LENGTH")) continue;
            httpDeleteRequest.addHeader(value[0], value[1]);
        }
        httpDeleteRequest.setEntity((HttpEntity)new ByteArrayEntity(request.getPayload()));
        CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpDeleteRequest);
        byte[] response = this.formatK8SResponse(request, (HttpResponse)httpResponse);
        httpDeleteRequest.releaseConnection();
        return response;
    }

    private CloseableHttpClient getSSLHttpClients() throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, KeyManagementException {
        SSLContextBuilder sslBuilder = SSLContexts.custom();
        File file = new File("./src/test/resources/keystore.jks");
        sslBuilder = sslBuilder.loadTrustMaterial(file, "a1234567".toCharArray());
        SSLContext sslcontext = sslBuilder.build();
        SSLConnectionSocketFactory sslConSocFactory = new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)new NoopHostnameVerifier());
        HttpClientBuilder clientbuilder = HttpClients.custom();
        clientbuilder = clientbuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConSocFactory);
        CloseableHttpClient httpClient = clientbuilder.build();
        return httpClient;
    }
}

