/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport;

import de.iip_ecosphere.platform.transport.serialization.DefaultQualifiedElement;
import de.iip_ecosphere.platform.transport.serialization.QualifiedElement;
import de.iip_ecosphere.platform.transport.serialization.QualifiedElementFactory;
import org.junit.Assert;
import org.junit.Test;

public class QualifiedElementFactoryTest {
    @Test
    public void testDefaultElement() {
        DefaultQualifiedElement elt = new DefaultQualifiedElement();
        elt.setValue((Object)"TEST");
        Assert.assertEquals((Object)"TEST", (Object)elt.getValue());
        elt.setQualifier("iri:0123-123-456");
        Assert.assertEquals((Object)"iri:0123-123-456", (Object)elt.getQualifier());
    }

    @Test
    public void testElementFactory() {
        QualifiedElementFactory.reset();
        QualifiedElement sElt = QualifiedElementFactory.createElement(String.class);
        Assert.assertNotNull((Object)sElt);
        Assert.assertTrue((boolean)(sElt instanceof DefaultQualifiedElement));
        QualifiedElementFactory.registerElementSupplier(Integer.class, () -> new MyElement());
        QualifiedElement iElt = QualifiedElementFactory.createElement(Integer.class);
        Assert.assertNotNull((Object)iElt);
        Assert.assertTrue((boolean)(iElt instanceof MyElement));
        QualifiedElementFactory.reset();
    }

    private static class MyElement<T>
    extends DefaultQualifiedElement<T> {
        private MyElement() {
        }
    }
}

