/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.IOUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.identities.IdentityToken;
import de.iip_ecosphere.platform.support.iip_aas.NameplateSetup;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class ConnectorParameter {
    public static final String ANY_ENDPOINT = "";
    public static final Schema DEFAULT_SCHEMA = Schema.TCP;
    public static final int DEFAULT_REQUEST_TIMEOUT = 5000;
    public static final int DEFAULT_NOTIFICATION_INTERVAL = 1000;
    public static final int DEFAULT_KEEP_ALIVE = 2000;
    private Map<String, IdentityToken> identityToken;
    private Schema schema = DEFAULT_SCHEMA;
    private int port;
    private String host;
    private int requestTimeout = 5000;
    private String endpointPath = "";
    private String applicationId = "";
    private boolean autoApplicationId = true;
    private String applicationDescription = "";
    private int notificationInterval = 1000;
    private int keepAlive = 2000;
    private String keystoreKey;
    private String keyAlias;
    private boolean hostnameVerification = false;
    private CacheMode cacheMode = CacheMode.NONE;
    private NameplateSetup.Service service;
    private Map<String, Object> specificSettings = new HashMap<String, Object>();

    private ConnectorParameter(String host, int port) {
        this.port = port;
        this.host = host;
    }

    public IdentityToken getIdentityToken(String endpointUrl) {
        IdentityToken token = null;
        if (null != this.identityToken && null == (token = this.identityToken.get(endpointUrl))) {
            token = this.identityToken.get(ANY_ENDPOINT);
        }
        return token;
    }

    public boolean isAnonymousIdentity() {
        return null == this.identityToken;
    }

    public boolean isFeasibleEndpoint(String endpointUrl, byte securityLevel) {
        return true;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getEndpointPath() {
        return this.endpointPath;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getApplicationDescription() {
        return this.applicationDescription;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public int getNotificationInterval() {
        return this.notificationInterval;
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public boolean getAutoApplicationId() {
        return this.autoApplicationId;
    }

    public String getKeystoreKey() {
        return this.keystoreKey;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public boolean getHostnameVerification() {
        return this.hostnameVerification;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public NameplateSetup.Service getService() {
        return this.service;
    }

    public Object getSpecificSetting(String key) {
        return this.specificSettings.get(key);
    }

    public Set<String> getSpecificSettingKeys() {
        return this.specificSettings.keySet();
    }

    public String getSpecificStringSetting(String key) {
        String result = null;
        Object setting = this.specificSettings.get(key);
        if (null != setting) {
            result = setting.toString();
        }
        return result;
    }

    public Integer getSpecificIntSetting(String key) {
        Integer result = null;
        Object setting = this.specificSettings.get(key);
        if (setting instanceof Integer) {
            result = (Integer)setting;
        } else if (setting != null) {
            try {
                result = Integer.valueOf(setting.toString());
            }
            catch (NumberFormatException e) {
                LoggerFactory.getLogger(ConnectorParameter.class).warn("Value {} of specific setting {} is not an integer.", setting, (Object)key);
            }
        }
        return result;
    }

    public void setSpecificIntSetting(String key, Consumer<Integer> setter) {
        Integer value = this.getSpecificIntSetting(key);
        if (null != value) {
            setter.accept(value);
        }
    }

    public static enum CacheMode {
        NONE,
        HASH,
        EQUALS;

    }

    public static class ConnectorParameterBuilder {
        private ConnectorParameter instance;

        private ConnectorParameterBuilder() {
        }

        public static ConnectorParameterBuilder newBuilder(String host, int port) {
            return ConnectorParameterBuilder.newBuilder(host, port, null);
        }

        public static ConnectorParameterBuilder newBuilder(String host, int port, Schema schema) {
            ConnectorParameterBuilder builder = new ConnectorParameterBuilder();
            builder.instance = new ConnectorParameter(host, port);
            if (null != schema) {
                builder.instance.schema = schema;
            }
            return builder;
        }

        public static ConnectorParameterBuilder newBuilder(ConnectorParameter params, String host, Integer port, Schema schema) {
            ConnectorParameterBuilder builder = ConnectorParameterBuilder.newBuilder(null == host ? params.getHost() : host, null == port ? params.getPort() : port.intValue(), null == schema ? params.getSchema() : schema);
            builder.instance.identityToken = params.identityToken;
            builder.instance.requestTimeout = params.requestTimeout;
            builder.instance.endpointPath = params.endpointPath;
            builder.instance.applicationId = params.applicationId;
            builder.instance.autoApplicationId = params.autoApplicationId;
            builder.instance.applicationDescription = params.applicationDescription;
            builder.instance.notificationInterval = params.notificationInterval;
            builder.instance.keepAlive = params.keepAlive;
            builder.instance.keystoreKey = params.keystoreKey;
            builder.instance.keyAlias = params.keyAlias;
            builder.instance.hostnameVerification = params.hostnameVerification;
            builder.instance.cacheMode = params.cacheMode;
            builder.instance.service = params.service;
            builder.instance.specificSettings.clear();
            builder.instance.specificSettings.putAll(params.specificSettings);
            return builder;
        }

        public static ConnectorParameterBuilder newBuilder(ConnectorParameter params) {
            return ConnectorParameterBuilder.newBuilder(params, null, null, null);
        }

        public static ConnectorParameterBuilder newBuilder(ServerAddress addr) {
            return ConnectorParameterBuilder.newBuilder(addr.getHost(), addr.getPort(), addr.getSchema());
        }

        public ConnectorParameterBuilder setService(NameplateSetup.Service service) {
            this.instance.service = service;
            return this;
        }

        public ConnectorParameterBuilder setEndpointPath(String endpointPath) {
            this.instance.endpointPath = endpointPath;
            return this;
        }

        public ConnectorParameterBuilder setRequestTimeout(int requestTimeout) {
            this.instance.requestTimeout = requestTimeout;
            return this;
        }

        public ConnectorParameterBuilder setKeepAlive(int keepAlive) {
            this.instance.keepAlive = keepAlive;
            return this;
        }

        public ConnectorParameterBuilder setNotificationInterval(int notificationInterval) {
            this.instance.notificationInterval = notificationInterval;
            return this;
        }

        public ConnectorParameterBuilder setApplicationInformation(String applicationId, String applicationDescription) {
            this.instance.applicationId = applicationId;
            this.instance.applicationDescription = applicationDescription;
            return this;
        }

        public ConnectorParameterBuilder setAutoApplicationId(boolean autoApplicationId) {
            this.instance.autoApplicationId = autoApplicationId;
            return this;
        }

        public ConnectorParameterBuilder setIdentities(Map<String, IdentityToken> identityToken) {
            this.instance.identityToken = identityToken;
            return this;
        }

        public ConnectorParameterBuilder setKeystoreKey(String keystoreKey) {
            this.instance.keystoreKey = keystoreKey;
            return this;
        }

        public ConnectorParameterBuilder setKeyAlias(String alias) {
            this.instance.keyAlias = alias;
            return this;
        }

        public ConnectorParameterBuilder setHostnameVerification(boolean hostnameVerification) {
            this.instance.hostnameVerification = hostnameVerification;
            return this;
        }

        public ConnectorParameterBuilder setCacheMode(CacheMode cacheMode) {
            if (null != cacheMode) {
                this.instance.cacheMode = cacheMode;
            }
            return this;
        }

        public ConnectorParameterBuilder setSpecificSetting(String key, Object value) {
            this.instance.specificSettings.put(key, value);
            return this;
        }

        public ConnectorParameterBuilder setSpecificSettingFromResource(String key, String resource, ResourceResolver ... resolver) throws IOException {
            InputStream res = ResourceLoader.getResourceAsStream((String)resource, (ResourceResolver[])resolver);
            if (null != res) {
                String contents = IOUtils.toString((InputStream)res, (Charset)StandardCharsets.UTF_8);
                this.instance.specificSettings.put(key, contents);
                FileUtils.closeQuietly((Closeable)res);
            }
            return this;
        }

        public ConnectorParameterBuilder setSpecificSettingFromResourceSafe(String key, String resource, ResourceResolver ... resolver) {
            try {
                this.setSpecificSettingFromResource(key, resource, resolver);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Cannot determine value of specific setting '{}': {}", (Object)key, (Object)e.getMessage());
            }
            return this;
        }

        public ConnectorParameter build() {
            return this.instance;
        }
    }
}

