/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.parser;

import de.iip_ecosphere.platform.connectors.parser.InputParser;
import de.iip_ecosphere.platform.connectors.parser.MachineParser;
import de.iip_ecosphere.platform.support.function.IOConsumer;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonIterator;
import de.iip_ecosphere.platform.transport.serialization.QualifiedElement;
import de.iip_ecosphere.platform.transport.serialization.QualifiedElementFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@MachineParser
public final class JsonInputParser
implements InputParser<JsonIterator> {
    private static final JsonInputConverter CONVERTER = new JsonInputConverter();

    public JsonParseResult parse(byte[] data) throws IOException {
        return new JsonParseResult(data);
    }

    public JsonInputConverter getConverter() {
        return CONVERTER;
    }

    public static final class JsonParseResult
    implements InputParser.ParseResult<JsonIterator> {
        private JsonIterator any;
        private byte[] data;
        private JsonParseResult parent;

        private JsonParseResult(byte[] data) {
            this(data, Json.parse((byte[])data), null);
        }

        private JsonParseResult(byte[] data, JsonIterator any, JsonParseResult parent) {
            this.any = any;
            this.data = data;
            this.parent = parent;
        }

        @Override
        public int getDataCount() {
            return this.any.size();
        }

        @Override
        public String getFieldName(IOConsumer<JsonIterator> valueCons, int ... indexes) throws IOException {
            String result = "";
            if (this.any.size() == 1 && indexes.length == 1) {
                result = this.any.getAnyKey();
                if (null != valueCons) {
                    valueCons.accept((Object)this.any.get(result));
                }
            } else {
                JsonIterator.EntryIterator it = this.findBy(indexes);
                if (null != it) {
                    result = it.key();
                    if (null != valueCons) {
                        valueCons.accept((Object)it.value());
                    }
                }
            }
            return result;
        }

        private JsonIterator.EntryIterator findBy(int[] indexes) {
            OneElementEntryIterator result = null;
            if (indexes.length > 0) {
                JsonIterator tmp = Json.parse((byte[])this.data);
                for (int i = 0; i < indexes.length; ++i) {
                    int pos;
                    if (tmp.valueType() == JsonIterator.ValueType.ARRAY) {
                        result = new OneElementEntryIterator("", tmp.get(pos));
                        continue;
                    }
                    JsonIterator.EntryIterator it = tmp.entries();
                    for (pos = indexes[i]; pos >= 0 && it.next(); --pos) {
                        if (pos != 0) continue;
                        if (i < indexes.length - 1) {
                            tmp = this.deserializeIfString(it.value());
                            continue;
                        }
                        result = it;
                    }
                }
            }
            return result;
        }

        private JsonIterator deserializeIfString(JsonIterator tmp) {
            if (tmp.valueType() == JsonIterator.ValueType.STRING) {
                tmp = Json.parse((String)tmp.toString());
            }
            return tmp;
        }

        private JsonIterator.EntryIterator findBy(int index) {
            OneElementEntryIterator result = null;
            JsonIterator tmp = Json.parse((byte[])this.data);
            if (tmp.valueType() == JsonIterator.ValueType.ARRAY) {
                result = new OneElementEntryIterator("", tmp.get(index));
            } else {
                JsonIterator.EntryIterator it = tmp.entries();
                while (index >= 0 && it.next()) {
                    if (index == 0) {
                        result = it;
                    }
                    --index;
                }
            }
            return result;
        }

        @Override
        public JsonIterator getData(String name, int ... indexes) throws IOException {
            JsonIterator result = this.get(name, indexes);
            if (result != null) {
                return result;
            }
            throw new IOException("No entry found for " + name + " / " + Arrays.toString(indexes));
        }

        private JsonIterator get(String name, int ... indexes) {
            JsonIterator result = null;
            JsonIterator obj = this.any;
            int start = 0;
            int end = 0;
            do {
                if (obj.valueType() == JsonIterator.ValueType.STRING) {
                    obj = Json.parse((String)obj.toString());
                }
                if ((end = name.indexOf(46, start)) > 0) {
                    obj = obj.get(name.substring(start, end));
                    start = end + 1;
                    continue;
                }
                obj = 0 == start ? obj.get(name) : obj.get(name.substring(start, name.length()));
            } while (end > 0);
            if (obj.valueType() == JsonIterator.ValueType.INVALID && indexes.length > 0) {
                JsonIterator.EntryIterator it = this.findBy(indexes);
                if (null != it) {
                    result = it.value();
                }
            } else if (obj.valueType() != JsonIterator.ValueType.INVALID && obj != this.any) {
                result = obj;
            }
            return result;
        }

        @Override
        public void getData(IOConsumer<JsonIterator> ifPresent, String name, int ... indexes) throws IOException {
            JsonIterator result = this.get(name, indexes);
            if (null != result) {
                ifPresent.accept((Object)result);
            }
        }

        private JsonIterator getLocal(String name, int[] indexes) {
            JsonIterator.EntryIterator it;
            JsonIterator result = null;
            if (this.any.containsKey(name)) {
                result = this.any.get(name);
            } else if (indexes.length > 0 && null != (it = this.findBy(indexes))) {
                result = it.value();
            }
            return result;
        }

        @Override
        public JsonIterator getLocalData(String name, int ... indexes) throws IOException {
            JsonIterator result = this.getLocal(name, indexes);
            if (null == result) {
                throw new IOException("No entry found for " + name + " / " + Arrays.toString(indexes));
            }
            return result;
        }

        @Override
        public void getLocalData(IOConsumer<JsonIterator> ifPresent, String name, int ... indexes) throws IOException {
            JsonIterator result = this.getLocal(name, indexes);
            if (null != result) {
                ifPresent.accept((Object)result);
            }
        }

        public JsonParseResult stepInto(String name, int index) throws IOException {
            JsonIterator nested = this.any.get(name);
            if (nested.valueType() == JsonIterator.ValueType.INVALID) {
                JsonIterator.EntryIterator it = this.findBy(index);
                if (null != it) {
                    nested = it.value();
                } else {
                    throw new IndexOutOfBoundsException("No entry found for " + index);
                }
            }
            if (nested.valueType() != JsonIterator.ValueType.INVALID) {
                byte[] actData = this.any.slice(this.getTopData(), nested);
                return new JsonParseResult(actData, nested, this);
            }
            throw new IOException("Cannot determine element for " + name + " index: " + index);
        }

        private byte[] getTopData() {
            JsonParseResult ptr = this;
            while (ptr.parent != null) {
                ptr = ptr.parent;
            }
            return ptr.data;
        }

        public JsonParseResult stepOut() {
            return this.parent;
        }

        @Override
        public int getArraySize() {
            return this.any.size();
        }
    }

    public static final class JsonInputConverter
    implements InputParser.InputConverter<JsonIterator> {
        @Override
        public int toInteger(JsonIterator data) throws IOException {
            return data.toIntValue();
        }

        @Override
        public byte toByte(JsonIterator data) throws IOException {
            return (byte)data.toIntValue();
        }

        @Override
        public long toLong(JsonIterator data) throws IOException {
            return data.toLongValue();
        }

        @Override
        public short toShort(JsonIterator data) throws IOException {
            return (short)data.toIntValue();
        }

        @Override
        public String toString(JsonIterator data) throws IOException {
            return data.toStringValue();
        }

        @Override
        public double toDouble(JsonIterator data) throws IOException {
            return data.toDoubleValue();
        }

        @Override
        public float toFloat(JsonIterator data) throws IOException {
            return data.toFloatValue();
        }

        @Override
        public boolean toBoolean(JsonIterator data) throws IOException {
            return data.toBooleanValue();
        }

        @Override
        public int[] toIntegerArray(JsonIterator data) throws IOException {
            int[] dta = new int[data.size()];
            for (int j = 0; j < dta.length; ++j) {
                dta[j] = data.get(j).toIntValue();
            }
            return dta;
        }

        @Override
        public String[] toStringArray(JsonIterator data) throws IOException {
            String[] dta = new String[data.size()];
            for (int j = 0; j < dta.length; ++j) {
                dta[j] = data.get(j).toStringValue();
            }
            return dta;
        }

        @Override
        public double[] toDoubleArray(JsonIterator data) throws IOException {
            double[] dta = new double[data.size()];
            for (int j = 0; j < dta.length; ++j) {
                dta[j] = Double.parseDouble(data.get(j).toStringValue());
            }
            return dta;
        }

        @Override
        public byte[] toByteArray(JsonIterator data) throws IOException {
            byte[] dta = new byte[data.size()];
            for (int j = 0; j < dta.length; ++j) {
                dta[j] = (byte)data.get(j).toIntValue();
            }
            return dta;
        }

        @Override
        public Object toObject(JsonIterator data) throws IOException {
            return null;
        }

        @Override
        public <E> List<E> toList(JsonIterator data, Class<E> eltCls) throws IOException {
            ArrayList<E> result = new ArrayList<E>(data.size());
            for (int i = 0; i < data.size(); ++i) {
                Object obj = data.get(i);
                if (obj instanceof QualifiedElement) {
                    obj = ((QualifiedElement)obj).getValue();
                }
                if (!eltCls.isInstance(obj)) {
                    throw new IOException("Element " + i + " " + String.valueOf(obj) + " is not of type " + eltCls.getName());
                }
                result.add(eltCls.cast(obj));
            }
            return result;
        }

        @Override
        public <E> List<QualifiedElement<E>> toElementList(JsonIterator data, Class<E> eltCls) throws IOException {
            ArrayList<QualifiedElement<QualifiedElement>> result = new ArrayList<QualifiedElement<QualifiedElement>>(data.size());
            for (int i = 0; i < data.size(); ++i) {
                Object obj = data.get(i);
                if (obj instanceof QualifiedElement) {
                    obj = ((QualifiedElement)obj).getValue();
                }
                if (!eltCls.isInstance(obj)) {
                    throw new IOException("Element " + i + " " + String.valueOf(obj) + " is not of type " + eltCls.getName());
                }
                QualifiedElement elt = QualifiedElementFactory.createElement(eltCls);
                elt.setValue(eltCls.cast(obj));
                result.add(elt);
            }
            return result;
        }

        @Override
        public BigInteger toBigInteger(JsonIterator data) throws IOException {
            return data.toBigIntegerValue();
        }

        @Override
        public BigDecimal toBigDecimal(JsonIterator data) throws IOException {
            return data.toBigDecimalValue();
        }
    }

    private static final class OneElementEntryIterator
    implements JsonIterator.EntryIterator {
        private String key;
        private JsonIterator value;

        private OneElementEntryIterator(String key, JsonIterator value) {
            this.key = key;
            this.value = value;
        }

        public boolean next() {
            return false;
        }

        public String key() {
            return this.key;
        }

        public JsonIterator value() {
            return this.value;
        }
    }
}

