/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.directory.tagged.observing;

import java.util.Set;
import org.eclipse.basyx.aas.registration.observing.ObservableAASRegistryServiceV2;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.IAASTaggedDirectory;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedAASDescriptor;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedSubmodelDescriptor;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;

public class ObservableAASTaggedDirectoryServiceV2
extends ObservableAASRegistryServiceV2
implements IAASTaggedDirectory {
    private IAASTaggedDirectory taggedDirectory;

    public ObservableAASTaggedDirectoryServiceV2(IAASTaggedDirectory taggedDirectory, String registryId) {
        super(taggedDirectory, registryId);
        this.taggedDirectory = taggedDirectory;
    }

    @Override
    public void register(TaggedAASDescriptor descriptor) {
        try {
            this.taggedDirectory.lookupAAS(descriptor.getIdentifier());
            this.taggedDirectory.register(descriptor);
            this.observers.stream().forEach(o -> o.aasUpdated(descriptor, super.getRegistryId()));
        }
        catch (ResourceNotFoundException e) {
            this.taggedDirectory.register(descriptor);
            this.observers.stream().forEach(o -> o.aasRegistered(descriptor, super.getRegistryId()));
        }
    }

    @Override
    public void registerSubmodel(IIdentifier aas, TaggedSubmodelDescriptor descriptor) {
        try {
            this.taggedDirectory.lookupSubmodel(aas, descriptor.getIdentifier());
            this.taggedDirectory.register(aas, descriptor);
            this.observers.stream().forEach(o -> o.submodelUpdated(aas, descriptor, super.getRegistryId()));
        }
        catch (ResourceNotFoundException e) {
            this.taggedDirectory.register(aas, descriptor);
            this.observers.stream().forEach(o -> o.submodelRegistered(aas, descriptor, super.getRegistryId()));
        }
    }

    @Override
    public Set<TaggedAASDescriptor> lookupTag(String tag) {
        return this.taggedDirectory.lookupTag(tag);
    }

    @Override
    public Set<TaggedAASDescriptor> lookupTags(Set<String> tags) {
        return this.taggedDirectory.lookupTags(tags);
    }

    @Override
    public Set<TaggedSubmodelDescriptor> lookupSubmodelTag(String submodelTag) {
        return this.taggedDirectory.lookupSubmodelTag(submodelTag);
    }

    @Override
    public Set<TaggedSubmodelDescriptor> lookupSubmodelTags(Set<String> submodelTags) {
        return this.taggedDirectory.lookupSubmodelTags(submodelTags);
    }

    @Override
    public Set<TaggedSubmodelDescriptor> lookupBothAasAndSubmodelTags(Set<String> aasTags, Set<String> submodelTags) {
        return this.taggedDirectory.lookupBothAasAndSubmodelTags(aasTags, submodelTags);
    }
}

