/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.shared.authorization.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRoleAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class KeycloakRoleAuthenticator
implements IRoleAuthenticator<Jwt> {
    private static final Logger logger = LoggerFactory.getLogger(KeycloakRoleAuthenticator.class);

    @Override
    public List<String> getRoles(Jwt subjectInformation) {
        return Optional.ofNullable(subjectInformation).map(info -> new JwtAuthenticationToken(subjectInformation)).map(this::jwtStr2roles).orElse(new ArrayList<String>(Collections.singletonList("anonymous")));
    }

    private List<String> jwtStr2roles(JwtAuthenticationToken token) {
        logger.info("jwtStr: {}", (Object)((Jwt)token.getToken()).getTokenValue());
        logger.info("jwt: {}", (Object)token.getTokenAttributes());
        try {
            Object realmAccessObject = token.getTokenAttributes().get("realm_access");
            Map realmAccess = (Map)realmAccessObject;
            Object rolesObject = realmAccess.get("roles");
            if (rolesObject != null) {
                List roles = (List)rolesObject;
                return roles.stream().map(Object::toString).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<String>(Collections.singletonList("anonymous"));
    }
}

