/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.submodel.aggregator.mqtt;

import java.security.ProviderException;
import org.eclipse.basyx.extensions.submodel.aggregator.mqtt.MqttV2SubmodelAggregatorObserver;
import org.eclipse.basyx.extensions.submodel.aggregator.mqtt.MqttV2SubmodelAggregatorTopicFactory;
import org.eclipse.basyx.submodel.aggregator.api.ISubmodelAggregator;
import org.eclipse.basyx.submodel.aggregator.api.ISubmodelAggregatorFactory;
import org.eclipse.basyx.submodel.aggregator.observing.ObservableSubmodelAggregatorV2;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;

public class MqttV2DecoratingSubmodelAggregatorFactory
implements ISubmodelAggregatorFactory {
    private ISubmodelAggregatorFactory submodelAggregatorFactory;
    private MqttClient mqttClient;
    private ObservableSubmodelAggregatorV2 observedSubmodelAggregator;
    protected MqttV2SubmodelAggregatorObserver observer;
    private String aasServerId;
    private MqttV2SubmodelAggregatorTopicFactory topicFactory;

    public MqttV2DecoratingSubmodelAggregatorFactory(ISubmodelAggregatorFactory submodelAggregatorFactory, MqttClient mqttClient, String aasServerId, MqttV2SubmodelAggregatorTopicFactory topicFactory) {
        this.submodelAggregatorFactory = submodelAggregatorFactory;
        this.mqttClient = mqttClient;
        this.aasServerId = aasServerId;
        this.topicFactory = topicFactory;
    }

    @Override
    public ISubmodelAggregator create() {
        try {
            ISubmodelAggregator aggregator = this.submodelAggregatorFactory.create();
            this.observedSubmodelAggregator = new ObservableSubmodelAggregatorV2(aggregator, this.aasServerId);
            this.observer = new MqttV2SubmodelAggregatorObserver(this.mqttClient, this.topicFactory);
            this.observedSubmodelAggregator.addObserver(this.observer);
            return this.observedSubmodelAggregator;
        }
        catch (MqttException e) {
            throw new ProviderException(e);
        }
    }
}

