/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.range;

import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IRange;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.DataElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueType;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.valuetype.ValueTypeHelper;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.range.RangeValue;

public class Range
extends DataElement
implements IRange {
    public static final String MODELTYPE = "Range";
    public static final String VALUETYPE = "valueType";
    public static final String MIN = "min";
    public static final String MAX = "max";

    public Range() {
        this.putAll(new ModelType(MODELTYPE));
    }

    public Range(ValueType valueType) {
        this();
        this.setValueType(valueType);
    }

    public Range(String idShort, ValueType valueType) {
        super(idShort);
        this.putAll(new ModelType(MODELTYPE));
        this.setValueType(valueType);
    }

    public Range(ValueType valueType, Object min, Object max) {
        this(valueType);
        this.put(MIN, min);
        this.put(MAX, max);
    }

    public static Range createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!Range.isValid(obj)) {
            throw new MetamodelConstructionException(Range.class, obj);
        }
        Range facade = new Range();
        facade.setMap(obj);
        return facade;
    }

    public static boolean isValid(Map<String, Object> obj) {
        return DataElement.isValid(obj) && obj.containsKey(VALUETYPE);
    }

    public static boolean isRange(Map<String, Object> map) {
        String modelType = ModelType.createAsFacade(map).getName();
        return MODELTYPE.equals(modelType) || modelType == null && map.containsKey(MIN) && map.containsKey(MAX) && map.containsKey(VALUETYPE);
    }

    public void setValueType(ValueType valueType) {
        this.put(VALUETYPE, valueType.toString());
    }

    @Override
    public ValueType getValueType() {
        return ValueTypeHelper.readTypeDef(this.get(VALUETYPE));
    }

    @Override
    public Object getMin() {
        Object value = this.get(MIN);
        if (this.isNullOrBlank(value)) {
            return null;
        }
        if (value instanceof String) {
            return ValueTypeHelper.getJavaObject(value, this.getValueType());
        }
        return value;
    }

    private boolean isNullOrBlank(Object value) {
        if (value == null) {
            return true;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String stringValue = (String)value;
        return stringValue.isBlank();
    }

    @Override
    public Object getMax() {
        Object value = this.get(MAX);
        if (this.isNullOrBlank(value)) {
            return null;
        }
        if (value instanceof String) {
            return ValueTypeHelper.getJavaObject(value, this.getValueType());
        }
        return value;
    }

    @Override
    protected KeyElements getKeyElement() {
        return KeyElements.RANGE;
    }

    @Override
    public RangeValue getValue() {
        return new RangeValue(this.getMin(), this.getMax());
    }

    @Override
    public void setValue(Object value) {
        if (!RangeValue.isRangeValue(value)) {
            throw new IllegalArgumentException("Given Object is not a RangeValue");
        }
        RangeValue rv = RangeValue.createAsFacade((Map)value);
        this.setValue(rv);
    }

    @Override
    public void setValue(RangeValue rv) {
        Object minValue = rv.getMin();
        Object maxValue = rv.getMax();
        this.put(MIN, ValueTypeHelper.prepareForSerialization(minValue));
        this.put(MAX, ValueTypeHelper.prepareForSerialization(maxValue));
        if (this.getValueType() == null) {
            this.setValueType(ValueTypeHelper.getType(minValue));
        }
    }

    @Override
    public Range getLocalCopy() {
        Range copy = new Range();
        copy.putAll(this);
        return copy;
    }
}

