/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.http.server;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;

public class JwtBearerTokenAuthenticationConfiguration {
    private final String issuerUri;
    private final String jwkSetUri;
    @Nullable
    private final String requiredAud;

    private JwtBearerTokenAuthenticationConfiguration(String issuerUri, String jwkSetUri, @Nullable String requiredAud) {
        this.issuerUri = issuerUri;
        this.jwkSetUri = jwkSetUri;
        this.requiredAud = requiredAud;
    }

    public static JwtBearerTokenAuthenticationConfiguration of(String issuerUri, String jwkSetUri, @Nullable String requiredAud) {
        if (!JwtBearerTokenAuthenticationConfiguration.isValidIssuerUri(issuerUri)) {
            throw new IllegalArgumentException("invalid issuerUri");
        }
        if (!JwtBearerTokenAuthenticationConfiguration.isValidJwkSetUri(jwkSetUri)) {
            throw new IllegalArgumentException("invalid jwkSetUri");
        }
        if (requiredAud != null && !JwtBearerTokenAuthenticationConfiguration.isValidRequiredAudience(requiredAud)) {
            throw new IllegalArgumentException("invalid requiredAud");
        }
        return new JwtBearerTokenAuthenticationConfiguration(issuerUri, jwkSetUri, requiredAud);
    }

    private static boolean isValidIssuerUri(@Nullable String issuerUri) {
        return StringUtils.isNotBlank((CharSequence)issuerUri);
    }

    private static boolean isValidJwkSetUri(@Nullable String jwkSetUri) {
        return StringUtils.isNotBlank((CharSequence)jwkSetUri);
    }

    private static boolean isValidRequiredAudience(@Nullable String requiredAud) {
        return StringUtils.isNotBlank((CharSequence)requiredAud);
    }

    public String getIssuerUri() {
        return this.issuerUri;
    }

    public String getJwkSetUri() {
        return this.jwkSetUri;
    }

    public Optional<String> getRequiredAud() {
        return Optional.ofNullable(this.requiredAud);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JwtBearerTokenAuthenticationConfiguration{");
        sb.append("issuerUri='").append(this.issuerUri).append('\'');
        sb.append(", jwkSetUri='").append(this.jwkSetUri).append('\'');
        sb.append(", requiredAud='").append(this.requiredAud).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JwtBearerTokenAuthenticationConfiguration)) {
            return false;
        }
        JwtBearerTokenAuthenticationConfiguration that = (JwtBearerTokenAuthenticationConfiguration)o;
        return Objects.equals(this.getIssuerUri(), that.getIssuerUri()) && Objects.equals(this.getJwkSetUri(), that.getJwkSetUri()) && Objects.equals(this.getRequiredAud(), that.getRequiredAud());
    }

    public int hashCode() {
        return Objects.hash(this.getIssuerUri(), this.getJwkSetUri(), this.getRequiredAud());
    }
}

