/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client.internal;

import java.io.EOFException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.paho.mqttv5.client.MqttActionListener;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.MqttPingSender;
import org.eclipse.paho.mqttv5.client.MqttToken;
import org.eclipse.paho.mqttv5.client.internal.ClientComms;
import org.eclipse.paho.mqttv5.client.internal.CommsCallback;
import org.eclipse.paho.mqttv5.client.internal.CommsTokenStore;
import org.eclipse.paho.mqttv5.client.internal.ExceptionHelper;
import org.eclipse.paho.mqttv5.client.internal.MqttConnectionState;
import org.eclipse.paho.mqttv5.client.internal.MqttState;
import org.eclipse.paho.mqttv5.client.logging.Logger;
import org.eclipse.paho.mqttv5.client.logging.LoggerFactory;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.MqttPersistable;
import org.eclipse.paho.mqttv5.common.MqttPersistenceException;
import org.eclipse.paho.mqttv5.common.packet.MqttAck;
import org.eclipse.paho.mqttv5.common.packet.MqttAuth;
import org.eclipse.paho.mqttv5.common.packet.MqttConnAck;
import org.eclipse.paho.mqttv5.common.packet.MqttConnect;
import org.eclipse.paho.mqttv5.common.packet.MqttPingReq;
import org.eclipse.paho.mqttv5.common.packet.MqttPingResp;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.MqttPubAck;
import org.eclipse.paho.mqttv5.common.packet.MqttPubComp;
import org.eclipse.paho.mqttv5.common.packet.MqttPubRec;
import org.eclipse.paho.mqttv5.common.packet.MqttPubRel;
import org.eclipse.paho.mqttv5.common.packet.MqttPublish;
import org.eclipse.paho.mqttv5.common.packet.MqttWireMessage;

public class ClientState
implements MqttState {
    private static final String CLASS_NAME = ClientState.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.mqttv5.client.internal.nls.logcat", CLASS_NAME);
    private static final String PERSISTENCE_SENT_PREFIX = "s-";
    private static final String PERSISTENCE_SENT_BUFFERED_PREFIX = "sb-";
    private static final String PERSISTENCE_CONFIRMED_PREFIX = "sc-";
    private static final String PERSISTENCE_RECEIVED_PREFIX = "r-";
    private static final int MIN_MSG_ID = 1;
    private static final int MAX_MSG_ID = 65535;
    private int nextMsgId = 0;
    private ConcurrentHashMap<Integer, Integer> inUseMsgIds;
    private volatile Vector<MqttWireMessage> pendingMessages;
    private volatile Vector<MqttWireMessage> pendingFlows;
    private CommsTokenStore tokenStore;
    private ClientComms clientComms = null;
    private CommsCallback callback = null;
    private boolean cleanStart;
    private MqttClientPersistence persistence;
    private int actualInFlight = 0;
    private int inFlightPubRels = 0;
    private final Object queueLock = new Object();
    private final Object quiesceLock = new Object();
    private boolean quiescing = false;
    private long lastOutboundActivity = 0L;
    private long lastInboundActivity = 0L;
    private long lastPing = 0L;
    private MqttWireMessage pingCommand;
    private final Object pingOutstandingLock = new Object();
    private int pingOutstanding = 0;
    private boolean connected = false;
    private ConcurrentHashMap<Integer, MqttWireMessage> outboundQoS2 = null;
    private ConcurrentHashMap<Integer, MqttWireMessage> outboundQoS1 = null;
    private ConcurrentHashMap<Integer, MqttWireMessage> outboundQoS0 = null;
    private ConcurrentHashMap<Integer, MqttWireMessage> inboundQoS2 = null;
    private MqttPingSender pingSender = null;
    private Hashtable<String, Integer> outgoingTopicAliases;
    private Hashtable<Integer, String> incomingTopicAliases;
    private MqttConnectionState mqttConnection;

    protected ClientState(MqttClientPersistence persistence, CommsTokenStore tokenStore, CommsCallback callback, ClientComms clientComms, MqttPingSender pingSender, MqttConnectionState mqttConnection) throws MqttException {
        this.log.setResourceName(clientComms.getClient().getClientId());
        this.log.finer(CLASS_NAME, "<Init>", "");
        this.inUseMsgIds = new ConcurrentHashMap();
        this.pendingFlows = new Vector();
        this.pendingMessages = new Vector(mqttConnection.getReceiveMaximum());
        this.outboundQoS2 = new ConcurrentHashMap();
        this.outboundQoS1 = new ConcurrentHashMap();
        this.outboundQoS0 = new ConcurrentHashMap();
        this.inboundQoS2 = new ConcurrentHashMap();
        this.pingCommand = new MqttPingReq();
        this.inFlightPubRels = 0;
        this.actualInFlight = 0;
        this.outgoingTopicAliases = new Hashtable();
        this.incomingTopicAliases = new Hashtable();
        this.persistence = persistence;
        this.callback = callback;
        this.tokenStore = tokenStore;
        this.clientComms = clientComms;
        this.pingSender = pingSender;
        this.mqttConnection = mqttConnection;
        this.restoreState();
    }

    protected void setCleanStart(boolean cleanStart) {
        this.cleanStart = cleanStart;
    }

    protected boolean getCleanStart() {
        return this.cleanStart;
    }

    private String getSendPersistenceKey(MqttWireMessage message) {
        return PERSISTENCE_SENT_PREFIX + message.getMessageId();
    }

    private String getSendConfirmPersistenceKey(MqttWireMessage message) {
        return PERSISTENCE_CONFIRMED_PREFIX + message.getMessageId();
    }

    private String getReceivedPersistenceKey(MqttWireMessage message) {
        return PERSISTENCE_RECEIVED_PREFIX + message.getMessageId();
    }

    private String getReceivedPersistenceKey(int messageId) {
        return PERSISTENCE_RECEIVED_PREFIX + messageId;
    }

    private String getSendBufferedPersistenceKey(MqttWireMessage message) {
        return PERSISTENCE_SENT_BUFFERED_PREFIX + message.getMessageId();
    }

    protected void clearState() throws MqttException {
        this.log.fine(CLASS_NAME, "clearState", ">");
        this.persistence.clear();
        this.inUseMsgIds.clear();
        this.pendingMessages.clear();
        this.pendingFlows.clear();
        this.outboundQoS2.clear();
        this.outboundQoS1.clear();
        this.outboundQoS0.clear();
        this.inboundQoS2.clear();
        this.tokenStore.clear();
        this.outgoingTopicAliases.clear();
        this.incomingTopicAliases.clear();
    }

    protected void clearConnectionState() throws MqttException {
        this.log.fine(CLASS_NAME, "clearConnectionState", "665");
        this.outgoingTopicAliases.clear();
        this.incomingTopicAliases.clear();
    }

    private MqttWireMessage restoreMessage(String key, MqttPersistable persistable) throws MqttException {
        MqttWireMessage message = null;
        try {
            message = MqttWireMessage.createWireMessage(persistable);
        }
        catch (MqttException ex) {
            this.log.fine(CLASS_NAME, "restoreMessage", "602", new Object[]{key}, ex);
            if (ex.getCause() instanceof EOFException) {
                if (key != null) {
                    this.persistence.remove(key);
                }
            }
            throw ex;
        }
        this.log.fine(CLASS_NAME, "restoreMessage", "601", new Object[]{key, message});
        return message;
    }

    private void insertInOrder(Vector<MqttWireMessage> list, MqttWireMessage newMsg) {
        int newMsgId = newMsg.getMessageId();
        int i = 0;
        while (i < list.size()) {
            MqttWireMessage otherMsg = list.elementAt(i);
            int otherMsgId = otherMsg.getMessageId();
            if (otherMsgId > newMsgId) {
                list.insertElementAt(newMsg, i);
                return;
            }
            ++i;
        }
        list.addElement(newMsg);
    }

    private Vector<MqttWireMessage> reOrder(Vector<MqttWireMessage> list) {
        Vector<MqttWireMessage> newList = new Vector<MqttWireMessage>();
        if (list.size() == 0) {
            return newList;
        }
        int previousMsgId = 0;
        int largestGap = 0;
        int largestGapMsgIdPosInList = 0;
        int i = 0;
        while (i < list.size()) {
            int currentMsgId = list.elementAt(i).getMessageId();
            if (currentMsgId - previousMsgId > largestGap) {
                largestGap = currentMsgId - previousMsgId;
                largestGapMsgIdPosInList = i;
            }
            previousMsgId = currentMsgId;
            ++i;
        }
        int highestMsgId = previousMsgId;
        int lowestMsgId = list.elementAt(0).getMessageId();
        if (65535 - highestMsgId + lowestMsgId > largestGap) {
            largestGapMsgIdPosInList = 0;
        }
        int i2 = largestGapMsgIdPosInList;
        while (i2 < list.size()) {
            newList.addElement(list.elementAt(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < largestGapMsgIdPosInList) {
            newList.addElement(list.elementAt(i2));
            ++i2;
        }
        return newList;
    }

    protected void restoreState() throws MqttException {
        String key;
        Enumeration<String> messageKeys = this.persistence.keys();
        int highestMsgId = this.nextMsgId;
        Vector<String> orphanedPubRels = new Vector<String>();
        this.log.fine(CLASS_NAME, "restoreState", "600");
        while (messageKeys.hasMoreElements()) {
            MqttPubRel pubRelMessage;
            MqttToken tok;
            MqttPublish sendMessage;
            MqttPersistable persistable;
            key = messageKeys.nextElement();
            MqttWireMessage message = this.restoreMessage(key, persistable = this.persistence.get(key));
            if (message == null) continue;
            if (key.startsWith(PERSISTENCE_RECEIVED_PREFIX)) {
                this.log.fine(CLASS_NAME, "restoreState", "604", new Object[]{key, message});
                this.inboundQoS2.put(message.getMessageId(), message);
                continue;
            }
            if (key.startsWith(PERSISTENCE_SENT_PREFIX)) {
                sendMessage = (MqttPublish)message;
                highestMsgId = Math.max(sendMessage.getMessageId(), highestMsgId);
                if (this.persistence.containsKey(this.getSendConfirmPersistenceKey(sendMessage))) {
                    MqttPersistable persistedConfirm = this.persistence.get(this.getSendConfirmPersistenceKey(sendMessage));
                    MqttPubRel confirmMessage = (MqttPubRel)this.restoreMessage(key, persistedConfirm);
                    if (confirmMessage != null) {
                        this.log.fine(CLASS_NAME, "restoreState", "605", new Object[]{key, message});
                        this.outboundQoS2.put(confirmMessage.getMessageId(), confirmMessage);
                    } else {
                        this.log.fine(CLASS_NAME, "restoreState", "606", new Object[]{key, message});
                    }
                } else {
                    sendMessage.setDuplicate(true);
                    if (sendMessage.getMessage().getQos() == 2) {
                        this.log.fine(CLASS_NAME, "restoreState", "607", new Object[]{key, message});
                        this.outboundQoS2.put(sendMessage.getMessageId(), sendMessage);
                    } else {
                        this.log.fine(CLASS_NAME, "restoreState", "608", new Object[]{key, message});
                        this.outboundQoS1.put(sendMessage.getMessageId(), sendMessage);
                    }
                }
                tok = this.tokenStore.restoreToken(sendMessage);
                tok.internalTok.setClient(this.clientComms.getClient());
                this.inUseMsgIds.put(sendMessage.getMessageId(), sendMessage.getMessageId());
                continue;
            }
            if (key.startsWith(PERSISTENCE_SENT_BUFFERED_PREFIX)) {
                sendMessage = (MqttPublish)message;
                highestMsgId = Math.max(sendMessage.getMessageId(), highestMsgId);
                if (sendMessage.getMessage().getQos() == 2) {
                    this.log.fine(CLASS_NAME, "restoreState", "607", new Object[]{key, message});
                    this.outboundQoS2.put(sendMessage.getMessageId(), sendMessage);
                } else if (sendMessage.getMessage().getQos() == 1) {
                    this.log.fine(CLASS_NAME, "restoreState", "608", new Object[]{key, message});
                    this.outboundQoS1.put(sendMessage.getMessageId(), sendMessage);
                } else {
                    this.log.fine(CLASS_NAME, "restoreState", "511", new Object[]{key, message});
                    this.outboundQoS0.put(sendMessage.getMessageId(), sendMessage);
                    this.persistence.remove(key);
                }
                tok = this.tokenStore.restoreToken(sendMessage);
                tok.internalTok.setClient(this.clientComms.getClient());
                this.inUseMsgIds.put(sendMessage.getMessageId(), sendMessage.getMessageId());
                continue;
            }
            if (!key.startsWith(PERSISTENCE_CONFIRMED_PREFIX) || this.persistence.containsKey(this.getSendPersistenceKey(pubRelMessage = (MqttPubRel)message))) continue;
            orphanedPubRels.addElement(key);
        }
        messageKeys = orphanedPubRels.elements();
        while (messageKeys.hasMoreElements()) {
            key = messageKeys.nextElement();
            this.log.fine(CLASS_NAME, "restoreState", "609", new Object[]{key});
            this.persistence.remove(key);
        }
        this.nextMsgId = highestMsgId;
    }

    private void restoreInflightMessages() {
        MqttWireMessage msg;
        Integer key;
        this.pendingMessages = new Vector(this.mqttConnection.getReceiveMaximum());
        this.pendingFlows = new Vector();
        Enumeration<Integer> keys = this.outboundQoS2.keys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            msg = this.outboundQoS2.get(key);
            if (msg instanceof MqttPublish) {
                this.log.fine(CLASS_NAME, "restoreInflightMessages", "610", new Object[]{key});
                msg.setDuplicate(true);
                this.insertInOrder(this.pendingMessages, (MqttPublish)msg);
                continue;
            }
            if (!(msg instanceof MqttPubRel)) continue;
            this.log.fine(CLASS_NAME, "restoreInflightMessages", "611", new Object[]{key});
            this.insertInOrder(this.pendingFlows, (MqttPubRel)msg);
        }
        keys = this.outboundQoS1.keys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            msg = (MqttPublish)this.outboundQoS1.get(key);
            msg.setDuplicate(true);
            this.log.fine(CLASS_NAME, "restoreInflightMessages", "612", new Object[]{key});
            this.insertInOrder(this.pendingMessages, msg);
        }
        keys = this.outboundQoS0.keys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            msg = (MqttPublish)this.outboundQoS0.get(key);
            this.log.fine(CLASS_NAME, "restoreInflightMessages", "512", new Object[]{key});
            this.insertInOrder(this.pendingMessages, msg);
        }
        this.pendingFlows = this.reOrder(this.pendingFlows);
        this.pendingMessages = this.reOrder(this.pendingMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(MqttWireMessage message, MqttToken token) throws MqttException {
        Object object;
        if (message.isMessageIdRequired() && message.getMessageId() == 0) {
            message.setMessageId(this.getNextMessageId());
        }
        if (message instanceof MqttPublish && ((MqttPublish)message).getTopicName() != null && this.mqttConnection != null && this.mqttConnection.getOutgoingTopicAliasMaximum() > 0) {
            String topic = ((MqttPublish)message).getTopicName();
            if (this.outgoingTopicAliases.containsKey(topic)) {
                ((MqttPublish)message).getProperties().setTopicAlias(this.outgoingTopicAliases.get(topic));
                ((MqttPublish)message).setTopicName(null);
            } else {
                int nextOutgoingTopicAlias = this.mqttConnection.getNextOutgoingTopicAlias();
                if (nextOutgoingTopicAlias <= this.mqttConnection.getOutgoingTopicAliasMaximum()) {
                    ((MqttPublish)message).getProperties().setTopicAlias(nextOutgoingTopicAlias);
                    this.outgoingTopicAliases.put(((MqttPublish)message).getTopicName(), nextOutgoingTopicAlias);
                }
            }
        }
        if (token != null) {
            try {
                token.internalTok.setMessageID(message.getMessageId());
            }
            catch (Exception exception) {}
        }
        if (message instanceof MqttPublish) {
            object = this.queueLock;
            synchronized (object) {
                if (this.actualInFlight >= this.mqttConnection.getReceiveMaximum()) {
                    this.log.fine(CLASS_NAME, "send", "613", new Object[]{this.actualInFlight});
                    throw new MqttException(32202);
                }
                MqttMessage innerMessage = ((MqttPublish)message).getMessage();
                this.log.fine(CLASS_NAME, "send", "628", new Object[]{message.getMessageId(), innerMessage.getQos(), message});
                switch (innerMessage.getQos()) {
                    case 2: {
                        this.outboundQoS2.put(message.getMessageId(), message);
                        this.persistence.put(this.getSendPersistenceKey(message), (MqttPublish)message);
                        break;
                    }
                    case 1: {
                        this.outboundQoS1.put(message.getMessageId(), message);
                        this.persistence.put(this.getSendPersistenceKey(message), (MqttPublish)message);
                    }
                }
                this.tokenStore.saveToken(token, message);
                this.pendingMessages.addElement(message);
                this.queueLock.notifyAll();
            }
        }
        this.log.fine(CLASS_NAME, "send", "615", new Object[]{message.getMessageId(), message});
        if (message instanceof MqttConnect) {
            object = this.queueLock;
            synchronized (object) {
                this.tokenStore.saveToken(token, message);
                this.pendingFlows.insertElementAt(message, 0);
                this.queueLock.notifyAll();
            }
        }
        if (message instanceof MqttPingReq) {
            this.pingCommand = message;
        } else if (message instanceof MqttPubRel) {
            this.outboundQoS2.put(message.getMessageId(), message);
            this.persistence.put(this.getSendConfirmPersistenceKey(message), (MqttPubRel)message);
        } else if (message instanceof MqttPubComp) {
            this.persistence.remove(this.getReceivedPersistenceKey(message));
        }
        object = this.queueLock;
        synchronized (object) {
            if (!(message instanceof MqttAck)) {
                this.tokenStore.saveToken(token, message);
            }
            this.pendingFlows.addElement(message);
            this.queueLock.notifyAll();
        }
    }

    @Override
    public void persistBufferedMessage(MqttWireMessage message) {
        String key = this.getSendBufferedPersistenceKey(message);
        try {
            message.setMessageId(this.getNextMessageId());
            key = this.getSendBufferedPersistenceKey(message);
            try {
                this.persistence.put(key, (MqttPublish)message);
            }
            catch (MqttPersistenceException mqttPersistenceException) {
                this.log.fine(CLASS_NAME, "persistBufferedMessage", "515");
                this.persistence.open(this.clientComms.getClient().getClientId());
                this.persistence.put(key, (MqttPublish)message);
            }
            this.log.fine(CLASS_NAME, "persistBufferedMessage", "513", new Object[]{key});
        }
        catch (MqttException mqttException) {
            this.log.warning(CLASS_NAME, "persistBufferedMessage", "513", new Object[]{key});
        }
    }

    @Override
    public void unPersistBufferedMessage(MqttWireMessage message) {
        try {
            this.log.fine(CLASS_NAME, "unPersistBufferedMessage", "517", new Object[]{message.getKey()});
            this.persistence.remove(this.getSendBufferedPersistenceKey(message));
        }
        catch (MqttPersistenceException mqttPersistenceException) {
            this.log.fine(CLASS_NAME, "unPersistBufferedMessage", "518", new Object[]{message.getKey()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undo(MqttPublish message) throws MqttPersistenceException {
        Object object = this.queueLock;
        synchronized (object) {
            this.log.fine(CLASS_NAME, "undo", "618", new Object[]{message.getMessageId(), message.getMessage().getQos()});
            if (message.getMessage().getQos() == 1) {
                this.outboundQoS1.remove(message.getMessageId());
            } else {
                this.outboundQoS2.remove(message.getMessageId());
            }
            this.pendingMessages.removeElement(message);
            this.persistence.remove(this.getSendPersistenceKey(message));
            this.tokenStore.removeToken(message);
            if (message.getMessage().getQos() > 0) {
                this.releaseMessageId(message.getMessageId());
                message.setMessageId(0);
            }
            this.checkQuiesceLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MqttToken checkForActivity(MqttActionListener pingCallback) throws MqttException {
        this.log.fine(CLASS_NAME, "checkForActivity", "616", new Object[0]);
        Object object = this.quiesceLock;
        synchronized (object) {
            if (this.quiescing) {
                return null;
            }
        }
        MqttToken token = null;
        long keepAlive = TimeUnit.MILLISECONDS.toNanos(this.mqttConnection.getKeepAlive());
        if (this.connected && this.mqttConnection.getKeepAlive() > 0L) {
            long nextPingTime;
            long time = System.nanoTime();
            int delta = 100000;
            Object object2 = this.pingOutstandingLock;
            synchronized (object2) {
                if (this.pingOutstanding > 0 && time - this.lastInboundActivity >= keepAlive + (long)delta) {
                    this.log.severe(CLASS_NAME, "checkForActivity", "619", new Object[]{keepAlive, this.lastOutboundActivity, this.lastInboundActivity, time, this.lastPing});
                    throw ExceptionHelper.createMqttException(32000);
                }
                if (this.pingOutstanding == 0 && time - this.lastOutboundActivity >= 2L * keepAlive) {
                    this.log.severe(CLASS_NAME, "checkForActivity", "642", new Object[]{keepAlive, this.lastOutboundActivity, this.lastInboundActivity, time, this.lastPing});
                    throw ExceptionHelper.createMqttException(32002);
                }
                if (this.pingOutstanding == 0 && time - this.lastInboundActivity >= keepAlive - (long)delta || time - this.lastOutboundActivity >= keepAlive - (long)delta) {
                    this.log.fine(CLASS_NAME, "checkForActivity", "620", new Object[]{keepAlive, this.lastOutboundActivity, this.lastInboundActivity});
                    token = new MqttToken(this.clientComms.getClient().getClientId());
                    if (pingCallback != null) {
                        token.setActionCallback(pingCallback);
                    }
                    this.tokenStore.saveToken(token, this.pingCommand);
                    this.pendingFlows.insertElementAt(this.pingCommand, 0);
                    nextPingTime = keepAlive;
                    this.notifyQueueLock();
                } else {
                    this.log.fine(CLASS_NAME, "checkForActivity", "634", null);
                    nextPingTime = Math.max(1L, keepAlive - (time - this.lastOutboundActivity));
                }
            }
            this.log.fine(CLASS_NAME, "checkForActivity", "624", new Object[]{nextPingTime});
            this.pingSender.schedule(TimeUnit.NANOSECONDS.toMillis(nextPingTime));
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MqttWireMessage get() throws MqttException {
        MqttWireMessage result = null;
        Object object = this.queueLock;
        synchronized (object) {
            while (true) {
                if (result != null) {
                    return result;
                }
                if (this.pendingMessages.isEmpty() && this.pendingFlows.isEmpty() || this.pendingFlows.isEmpty() && this.actualInFlight >= this.mqttConnection.getReceiveMaximum()) {
                    try {
                        this.log.fine(CLASS_NAME, "get", "644");
                        this.queueLock.wait();
                        this.log.fine(CLASS_NAME, "get", "647");
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.pendingFlows == null || !this.connected && (this.pendingFlows.isEmpty() || !(this.pendingFlows.elementAt(0) instanceof MqttConnect))) {
                    this.log.fine(CLASS_NAME, "get", "621");
                    return null;
                }
                if (!this.pendingFlows.isEmpty()) {
                    result = this.pendingFlows.remove(0);
                    if (result instanceof MqttPubRel) {
                        ++this.inFlightPubRels;
                        this.log.fine(CLASS_NAME, "get", "617", new Object[]{this.inFlightPubRels});
                    }
                    this.checkQuiesceLock();
                    continue;
                }
                if (this.pendingMessages.isEmpty()) continue;
                if (this.actualInFlight < this.mqttConnection.getReceiveMaximum()) {
                    result = this.pendingMessages.elementAt(0);
                    this.pendingMessages.removeElementAt(0);
                    ++this.actualInFlight;
                    this.log.fine(CLASS_NAME, "get", "623", new Object[]{this.actualInFlight});
                    continue;
                }
                this.log.fine(CLASS_NAME, "get", "622");
            }
        }
    }

    @Override
    public void notifySentBytes(int sentBytesCount) {
        if (sentBytesCount > 0) {
            this.lastOutboundActivity = System.nanoTime();
        }
        this.log.fine(CLASS_NAME, "notifySentBytes", "643", new Object[]{sentBytesCount});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySent(MqttWireMessage message) {
        this.lastOutboundActivity = System.nanoTime();
        this.log.fine(CLASS_NAME, "notifySent", "625", new Object[]{message.getKey()});
        MqttToken token = this.tokenStore.getToken(message);
        if (token == null) {
            return;
        }
        token.internalTok.notifySent();
        if (message instanceof MqttPingReq) {
            Object object = this.pingOutstandingLock;
            synchronized (object) {
                long time = System.nanoTime();
                Object object2 = this.pingOutstandingLock;
                synchronized (object2) {
                    this.lastPing = time;
                    ++this.pingOutstanding;
                }
                this.log.fine(CLASS_NAME, "notifySent", "635", new Object[]{this.pingOutstanding});
            }
        }
        if (message instanceof MqttPublish && ((MqttPublish)message).getMessage().getQos() == 0) {
            token.internalTok.markComplete(null, null);
            this.callback.asyncOperationComplete(token);
            this.decrementInFlight();
            this.releaseMessageId(message.getMessageId());
            this.tokenStore.removeToken(message);
            this.checkQuiesceLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementInFlight() {
        Object object = this.queueLock;
        synchronized (object) {
            --this.actualInFlight;
            this.log.fine(CLASS_NAME, "decrementInFlight", "646", new Object[]{this.actualInFlight});
            if (!this.checkQuiesceLock()) {
                this.queueLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkQuiesceLock() {
        int tokC = this.tokenStore.count();
        if (this.quiescing && tokC == 0 && this.pendingFlows.size() == 0 && this.callback.isQuiesced()) {
            this.log.fine(CLASS_NAME, "checkQuiesceLock", "626", new Object[]{this.quiescing, this.actualInFlight, this.pendingFlows.size(), this.inFlightPubRels, this.callback.isQuiesced(), tokC});
            Object object = this.quiesceLock;
            synchronized (object) {
                this.quiesceLock.notifyAll();
            }
            return true;
        }
        return false;
    }

    @Override
    public void notifyReceivedBytes(int receivedBytesCount) {
        if (receivedBytesCount > 0) {
            this.lastInboundActivity = System.nanoTime();
        }
        this.log.fine(CLASS_NAME, "notifyReceivedBytes", "630", new Object[]{receivedBytesCount});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReceivedAck(MqttAck ack) throws MqttException {
        this.lastInboundActivity = System.nanoTime();
        this.log.fine(CLASS_NAME, "notifyReceivedAck", "627", new Object[]{ack.getMessageId(), ack});
        MqttToken token = this.tokenStore.getToken(ack);
        MqttException mex = null;
        if (token == null) {
            this.log.fine(CLASS_NAME, "notifyReceivedAck", "662", new Object[]{ack.getMessageId()});
        } else if (ack instanceof MqttPubRec) {
            if (((MqttPubRec)ack).getReasonCodes()[0] > 128) {
                this.log.severe(CLASS_NAME, "notifyReceivedAck", "664", new Object[]{ack.getMessageId(), ack.getReasonCodes()[0], ack.toString()});
                throw new MqttException(((MqttPubRec)ack).getReasonCodes()[0]);
            }
            this.updateResult(ack, token, mex);
            MqttPubRel rel = new MqttPubRel(0, ack.getMessageId(), new MqttProperties());
            this.send(rel, token);
        } else if (ack instanceof MqttPubAck || ack instanceof MqttPubComp) {
            this.notifyResult(ack, token, mex);
        } else if (ack instanceof MqttPingResp) {
            Object rel = this.pingOutstandingLock;
            synchronized (rel) {
                this.pingOutstanding = Math.max(0, this.pingOutstanding - 1);
                this.notifyResult(ack, token, mex);
                if (this.pingOutstanding == 0) {
                    this.tokenStore.removeToken(ack);
                }
            }
            this.log.fine(CLASS_NAME, "notifyReceivedAck", "636", new Object[]{this.pingOutstanding});
        } else if (ack instanceof MqttConnAck) {
            Object object;
            int rc = ((MqttConnAck)ack).getReturnCode();
            if (rc == 0) {
                object = this.queueLock;
                synchronized (object) {
                    if (this.cleanStart) {
                        this.clearState();
                        this.tokenStore.saveToken(token, ack);
                    }
                    this.inFlightPubRels = 0;
                    this.actualInFlight = 0;
                    this.restoreInflightMessages();
                    this.connected();
                }
            } else {
                mex = ExceptionHelper.createMqttException(rc);
                throw mex;
            }
            this.clientComms.connectComplete((MqttConnAck)ack, mex);
            this.notifyResult(ack, token, mex);
            this.tokenStore.removeToken(ack);
            object = this.queueLock;
            synchronized (object) {
                this.queueLock.notifyAll();
            }
        } else {
            this.notifyResult(ack, token, mex);
            this.releaseMessageId(ack.getMessageId());
            this.tokenStore.removeToken(ack);
        }
        this.checkQuiesceLock();
    }

    protected void handleOrphanedAcks(MqttAck ack) throws MqttException {
        this.log.fine(CLASS_NAME, "handleOrphanedAcks", "666", new Object[]{ack.getMessageId(), ack});
        if (!(ack instanceof MqttPubAck)) {
            if (ack instanceof MqttPubRec) {
                MqttProperties pubRelProperties = new MqttProperties();
                if (this.mqttConnection.isSendReasonMessages()) {
                    String reasonString = String.format("Message identifier [%d] was not found. Discontinuing QoS 2 flow.", ack.getMessageId());
                    pubRelProperties.setReasonString(reasonString);
                }
                MqttPubRel rel = new MqttPubRel(146, ack.getMessageId(), new MqttProperties());
                this.send(rel, null);
            } else {
                boolean cfr_ignored_0 = ack instanceof MqttPubComp;
            }
        }
    }

    protected void handleInboundPubRel(MqttPubRel pubRel) throws MqttException {
        if (pubRel.getReasonCodes()[0] > 128) {
            this.log.severe(CLASS_NAME, "handleInboundPubRel", "667", new Object[]{pubRel.getMessageId(), pubRel.toString(), pubRel.getReasonCodes()[0]});
            throw new MqttException(pubRel.getReasonCodes()[0]);
        }
        MqttPubComp pubComp = new MqttPubComp(0, pubRel.getMessageId(), new MqttProperties());
        this.log.info(CLASS_NAME, "handleInboundPubRel", "668", new Object[]{pubComp.toString()});
        this.send(pubComp, null);
    }

    protected void notifyReceivedMsg(MqttWireMessage message) throws MqttException {
        block16: {
            block17: {
                this.lastInboundActivity = System.nanoTime();
                this.log.fine(CLASS_NAME, "notifyReceivedMsg", "651", new Object[]{message.getMessageId(), message});
                if (this.quiescing) break block16;
                if (!(message instanceof MqttPublish)) break block17;
                MqttPublish send = (MqttPublish)message;
                if (send.getProperties().getTopicAlias() != null) {
                    int incomingTopicAlias = send.getProperties().getTopicAlias();
                    if (incomingTopicAlias > this.mqttConnection.getIncomingTopicAliasMax() || incomingTopicAlias == 0) {
                        this.log.severe(CLASS_NAME, "notifyReceivedMsg", "653", new Object[]{(int)this.mqttConnection.getIncomingTopicAliasMax(), incomingTopicAlias});
                        if (this.callback != null) {
                            this.callback.mqttErrorOccurred(new MqttException(50004));
                        }
                        throw new MqttException(32301);
                    }
                    if (send.getTopicName() != null) {
                        this.log.fine(CLASS_NAME, "notifyReceivedMsg", "652", new Object[]{(int)send.getProperties().getTopicAlias(), send.getTopicName()});
                        this.incomingTopicAliases.put(send.getProperties().getTopicAlias(), send.getTopicName());
                    } else if (this.incomingTopicAliases.contains(incomingTopicAlias)) {
                        send.setTopicName(this.incomingTopicAliases.get(incomingTopicAlias));
                    } else {
                        this.log.severe(CLASS_NAME, "notifyReceivedMsg", "654", new Object[]{(int)send.getProperties().getTopicAlias()});
                        throw new MqttException(32302);
                    }
                }
                switch (send.getMessage().getQos()) {
                    case 0: 
                    case 1: {
                        if (this.callback != null) {
                            this.callback.messageArrived(send);
                            break;
                        }
                        break block16;
                    }
                    case 2: {
                        this.persistence.put(this.getReceivedPersistenceKey(message), (MqttPublish)message);
                        this.inboundQoS2.put(send.getMessageId(), send);
                        if (this.callback != null) {
                            this.callback.messageArrived(send);
                        }
                        this.send(new MqttPubRec(0, send.getMessageId(), new MqttProperties()), null);
                    }
                }
                break block16;
            }
            if (message instanceof MqttPubRel) {
                this.handleInboundPubRel((MqttPubRel)message);
            } else if (message instanceof MqttAuth) {
                MqttAuth authMsg = (MqttAuth)message;
                this.callback.authMessageReceived(authMsg);
            }
        }
    }

    protected void notifyComplete(MqttToken token) throws MqttException {
        MqttWireMessage message = token.internalTok.getWireMessage();
        if (message != null && message instanceof MqttAck) {
            this.log.fine(CLASS_NAME, "notifyComplete", "629", new Object[]{message.getMessageId(), token, message});
            MqttAck ack = (MqttAck)message;
            if (ack instanceof MqttPubAck) {
                this.persistence.remove(this.getSendPersistenceKey(message));
                this.persistence.remove(this.getSendBufferedPersistenceKey(message));
                this.outboundQoS1.remove(ack.getMessageId());
                this.decrementInFlight();
                this.releaseMessageId(message.getMessageId());
                this.tokenStore.removeToken(message);
                this.log.fine(CLASS_NAME, "notifyComplete", "650", new Object[]{ack.getMessageId()});
            } else if (ack instanceof MqttPubComp) {
                this.persistence.remove(this.getSendPersistenceKey(message));
                this.persistence.remove(this.getSendConfirmPersistenceKey(message));
                this.persistence.remove(this.getSendBufferedPersistenceKey(message));
                this.outboundQoS2.remove(ack.getMessageId());
                --this.inFlightPubRels;
                this.decrementInFlight();
                this.releaseMessageId(message.getMessageId());
                this.tokenStore.removeToken(message);
                this.log.fine(CLASS_NAME, "notifyComplete", "645", new Object[]{ack.getMessageId(), this.inFlightPubRels});
            }
            this.checkQuiesceLock();
        }
    }

    protected void updateResult(MqttWireMessage ack, MqttToken token, MqttException ex) {
        token.internalTok.update(ack, ex);
    }

    protected void notifyResult(MqttWireMessage ack, MqttToken token, MqttException ex) {
        token.internalTok.markComplete(ack, ex);
        token.internalTok.notifyComplete();
        if (ack != null && ack instanceof MqttAck && !(ack instanceof MqttPubRec)) {
            this.log.fine(CLASS_NAME, "notifyResult", "648", new Object[]{token.internalTok.getKey(), ack, ex});
            this.callback.asyncOperationComplete(token);
        }
        if (ack == null) {
            this.log.fine(CLASS_NAME, "notifyResult", "649", new Object[]{token.internalTok.getKey(), ex});
            this.callback.asyncOperationComplete(token);
        }
    }

    @Override
    public void connected() {
        this.log.fine(CLASS_NAME, "connected", "631");
        this.connected = true;
        this.pingSender.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector<MqttToken> resolveOldTokens(MqttException reason) {
        this.log.fine(CLASS_NAME, "resolveOldTokens", "632", new Object[]{reason});
        MqttException shutReason = reason;
        if (reason == null) {
            shutReason = new MqttException(32102);
        }
        Vector<MqttToken> outT = this.tokenStore.getOutstandingTokens();
        Enumeration<MqttToken> outTE = outT.elements();
        while (outTE.hasMoreElements()) {
            MqttToken tok;
            MqttToken mqttToken = tok = outTE.nextElement();
            synchronized (mqttToken) {
                if (!tok.isComplete() && !tok.internalTok.isCompletePending() && tok.getException() == null) {
                    tok.internalTok.setException(shutReason);
                }
            }
            if (tok.internalTok.isDeliveryToken()) continue;
            this.tokenStore.removeToken(tok.internalTok.getKey());
        }
        return outT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnected(MqttException reason) {
        this.log.fine(CLASS_NAME, "disconnected", "633", new Object[]{reason});
        this.connected = false;
        try {
            if (this.cleanStart) {
                this.clearState();
            }
            this.clearConnectionState();
            this.pendingMessages.clear();
            this.pendingFlows.clear();
            Object object = this.pingOutstandingLock;
            synchronized (object) {
                this.pingOutstanding = 0;
            }
        }
        catch (MqttException mqttException) {}
    }

    private synchronized void releaseMessageId(int msgId) {
        this.inUseMsgIds.remove(msgId);
    }

    private synchronized int getNextMessageId() throws MqttException {
        int startingMessageId = this.nextMsgId;
        int loopCount = 0;
        do {
            ++this.nextMsgId;
            if (this.nextMsgId > 65535) {
                this.nextMsgId = 1;
            }
            if (this.nextMsgId != startingMessageId || ++loopCount != 2) continue;
            throw ExceptionHelper.createMqttException(32001);
        } while (this.inUseMsgIds.containsKey(this.nextMsgId));
        Integer id = this.nextMsgId;
        this.inUseMsgIds.put(id, id);
        return this.nextMsgId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void quiesce(long timeout) {
        if (timeout > 0L) {
            this.log.fine(CLASS_NAME, "quiesce", "637", new Object[]{timeout});
            Object object = this.queueLock;
            synchronized (object) {
                this.quiescing = true;
            }
            this.callback.quiesce();
            this.notifyQueueLock();
            object = this.quiesceLock;
            synchronized (object) {
                try {
                    int tokc = this.tokenStore.count();
                    if (tokc > 0 || this.pendingFlows.size() > 0 || !this.callback.isQuiesced()) {
                        this.log.fine(CLASS_NAME, "quiesce", "639", new Object[]{this.actualInFlight, this.pendingFlows.size(), this.inFlightPubRels, tokc});
                        this.quiesceLock.wait(timeout);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            object = this.queueLock;
            synchronized (object) {
                this.pendingMessages.clear();
                this.pendingFlows.clear();
                this.quiescing = false;
                this.actualInFlight = 0;
            }
            this.log.fine(CLASS_NAME, "quiesce", "640");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyQueueLock() {
        Object object = this.queueLock;
        synchronized (object) {
            this.log.fine(CLASS_NAME, "notifyQueueLock", "638");
            this.queueLock.notifyAll();
        }
    }

    protected void deliveryComplete(MqttPublish message) throws MqttPersistenceException {
        this.log.fine(CLASS_NAME, "deliveryComplete", "641", new Object[]{message.getMessageId()});
        this.persistence.remove(this.getReceivedPersistenceKey(message));
        this.inboundQoS2.remove(message.getMessageId());
    }

    protected void deliveryComplete(int messageId) throws MqttPersistenceException {
        this.log.fine(CLASS_NAME, "deliveryComplete", "641", new Object[]{messageId});
        this.persistence.remove(this.getReceivedPersistenceKey(messageId));
        this.inboundQoS2.remove(messageId);
    }

    @Override
    public int getActualInFlight() {
        return this.actualInFlight;
    }

    @Override
    public Long getOutgoingMaximumPacketSize() {
        return this.mqttConnection.getIncomingMaximumPacketSize();
    }

    @Override
    public Long getIncomingMaximumPacketSize() {
        return this.mqttConnection.getOutgoingMaximumPacketSize();
    }

    protected void close() {
        this.inUseMsgIds.clear();
        if (this.pendingMessages != null) {
            this.pendingMessages.clear();
        }
        this.pendingFlows.clear();
        this.outboundQoS2.clear();
        this.outboundQoS1.clear();
        this.outboundQoS0.clear();
        this.inboundQoS2.clear();
        this.tokenStore.clear();
        this.inUseMsgIds = null;
        this.pendingMessages = null;
        this.pendingFlows = null;
        this.outboundQoS2 = null;
        this.outboundQoS1 = null;
        this.outboundQoS0 = null;
        this.inboundQoS2 = null;
        this.tokenStore = null;
        this.callback = null;
        this.clientComms = null;
        this.persistence = null;
        this.pingCommand = null;
    }

    @Override
    public Properties getDebug() {
        Properties props = new Properties();
        props.put("In use msgids", this.inUseMsgIds);
        props.put("pendingMessages", this.pendingMessages);
        props.put("pendingFlows", this.pendingFlows);
        props.put("serverReceiveMaximum", this.mqttConnection.getReceiveMaximum());
        props.put("nextMsgID", (Object)this.nextMsgId);
        props.put("actualInFlight", (Object)this.actualInFlight);
        props.put("inFlightPubRels", (Object)this.inFlightPubRels);
        props.put("quiescing", (Object)this.quiescing);
        props.put("pingoutstanding", (Object)this.pingOutstanding);
        props.put("lastOutboundActivity", (Object)this.lastOutboundActivity);
        props.put("lastInboundActivity", (Object)this.lastInboundActivity);
        props.put("outboundQoS2", this.outboundQoS2);
        props.put("outboundQoS1", this.outboundQoS1);
        props.put("outboundQoS0", this.outboundQoS0);
        props.put("inboundQoS2", this.inboundQoS2);
        props.put("tokens", this.tokenStore);
        return props;
    }
}

