/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.instrumentation.transformer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.qpid.server.instrumentation.metadata.AutomatedFieldDescription;
import org.apache.qpid.server.instrumentation.metadata.MethodDescription;
import org.apache.qpid.server.instrumentation.transformer.ConfiguredObjectMethodAttributeOrStatisticTransformer;
import org.apache.qpid.server.instrumentation.transformer.ConfiguredObjectMethodOperationTransformer;
import org.apache.qpid.server.instrumentation.transformer.ConfiguredObjectTypeRegistryTransformer;
import org.apache.qpid.server.instrumentation.transformer.QpidTransformer;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QpidClassFileTransformer
implements ClassFileTransformer {
    private static final String CO_METHOD_ATTRIBUTE_OR_STATISTICS = "org/apache/qpid/server/model/ConfiguredObjectMethodAttributeOrStatistic";
    private static final String CO_METHOD_OPERATION = "org/apache/qpid/server/model/ConfiguredObjectMethodOperation";
    private static final String CO_TYPE_REGISTRY = "org/apache/qpid/server/model/ConfiguredObjectTypeRegistry$AutomatedField";
    private static final Map<String, String> TYPES = Map.of("ConfiguredObjectMethodAttributeOrStatistic", "org/apache/qpid/server/model/ConfiguredObjectMethodAttributeOrStatistic", "ConfiguredObjectMethodOperation", "org/apache/qpid/server/model/ConfiguredObjectMethodOperation", "AutomatedField", "org/apache/qpid/server/model/ConfiguredObjectTypeRegistry$AutomatedField");
    private static final String CLASSPATH_PROPERTY = "java.class.path";
    private static final String QPID_ROOT_PACKAGE = "org/apache/qpid";
    private static final String CLASS_EXTENSION = ".class";
    private static final List<String> AUTOMATED_FIELD_ANNOTATIONS = List.of("Lorg/apache/qpid/server/model/ManagedAttributeField;");
    private static final List<String> GETTER_ANNOTATIONS = List.of("Lorg/apache/qpid/server/model/DerivedAttribute;", "Lorg/apache/qpid/server/model/ManagedAttribute;", "Lorg/apache/qpid/server/model/ManagedStatistic;");
    private static final List<String> OPERATION_ANNOTATIONS = List.of("Lorg/apache/qpid/server/model/ManagedOperation;");
    private static final List<String> STATE_TRANSITION_ANNOTATIONS = List.of("Lorg/apache/qpid/server/model/StateTransition;");
    private static final List<String> ANNOTATIONS = Stream.of(AUTOMATED_FIELD_ANNOTATIONS, GETTER_ANNOTATIONS, OPERATION_ANNOTATIONS, STATE_TRANSITION_ANNOTATIONS).flatMap(Collection::stream).collect(Collectors.toUnmodifiableList());
    private static final Logger LOGGER = LoggerFactory.getLogger(QpidClassFileTransformer.class);
    private final Map<String, QpidTransformer<?>> _transformers = new HashMap();
    private final List<String> _allowedTypes;

    public QpidClassFileTransformer(String arg, Instrumentation instrumentation) {
        LOGGER.info("Initializing QPID instrumentation agent");
        this._allowedTypes = this.parseArgs(arg);
        String classPath = System.getProperty(CLASSPATH_PROPERTY);
        List classPathEntries = Arrays.stream(classPath.split(File.pathSeparator)).collect(Collectors.toList());
        ArrayList automatedFields = new ArrayList();
        ArrayList getters = new ArrayList();
        ArrayList operations = new ArrayList();
        ArrayList stateTransitions = new ArrayList();
        for (String classPathEntry : classPathEntries) {
            try {
                JarFile jarFile = this.jarFile(classPathEntry);
                try {
                    if (jarFile == null) continue;
                    jarFile.stream().filter(jarEntry -> jarEntry.getName().startsWith(QPID_ROOT_PACKAGE) && jarEntry.getName().endsWith(CLASS_EXTENSION)).forEach(jarEntry -> this.parse(jarFile, (JarEntry)jarEntry, automatedFields, (List<MethodDescription>)getters, (List<MethodDescription>)operations, (List<MethodDescription>)stateTransitions));
                }
                finally {
                    if (jarFile == null) continue;
                    jarFile.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Error when accessing class files", (Throwable)e);
            }
        }
        LOGGER.info("Identified {} automated fields", (Object)automatedFields.size());
        LOGGER.info("Identified {} managed attribute methods", (Object)getters.size());
        LOGGER.info("Identified {} managed operation methods", (Object)operations.size());
        LOGGER.info("Identified {} state transition methods", (Object)stateTransitions.size());
        LOGGER.info("Loaded {} classes", (Object)instrumentation.getAllLoadedClasses().length);
        this._transformers.put(CO_METHOD_ATTRIBUTE_OR_STATISTICS, new ConfiguredObjectMethodAttributeOrStatisticTransformer(getters));
        this._transformers.put(CO_METHOD_OPERATION, new ConfiguredObjectMethodOperationTransformer(operations));
        this._transformers.put(CO_TYPE_REGISTRY, new ConfiguredObjectTypeRegistryTransformer(automatedFields));
        LOGGER.info("QPID instrumentation agent initialized");
    }

    private List<String> parseArgs(String args) {
        if (args == null || args.isEmpty()) {
            return new ArrayList<String>(TYPES.values());
        }
        return Arrays.stream(args.split(",")).map(String::trim).filter(TYPES::containsKey).map(TYPES::get).distinct().collect(Collectors.toList());
    }

    private JarFile jarFile(String path) {
        try {
            return new JarFile(path);
        }
        catch (IOException e) {
            LOGGER.debug("Error when parsing jar file", (Throwable)e);
            return null;
        }
    }

    private void parse(JarFile jar, JarEntry jarEntry, List<AutomatedFieldDescription> automatedFields, List<MethodDescription> getters, List<MethodDescription> operations, List<MethodDescription> stateTransitions) {
        try (InputStream inputStream = jar.getInputStream(jarEntry);){
            ClassReader classReader = new ClassReader(inputStream);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 8);
            List methods = classNode.methods;
            List fields = classNode.fields;
            methods.stream().filter(methodNode -> methodNode.visibleAnnotations != null).forEach(methodNode -> this.parse(classNode, (MethodNode)methodNode, getters, operations, stateTransitions));
            fields.stream().filter(field -> field.visibleAnnotations != null).forEach(field -> this.parse(classNode, (FieldNode)field, automatedFields));
        }
        catch (IOException e) {
            throw new ServerScopedRuntimeException((Throwable)e);
        }
    }

    private void parse(ClassNode classNode, MethodNode methodNode, List<MethodDescription> getters, List<MethodDescription> operations, List<MethodDescription> stateTransitions) {
        List annotations = methodNode.visibleAnnotations;
        annotations.stream().filter(node -> ANNOTATIONS.contains(node.desc)).forEach(node -> this.parse(classNode, methodNode, (AnnotationNode)node, getters, operations, stateTransitions));
    }

    private void parse(ClassNode classNode, MethodNode methodNode, AnnotationNode node, List<MethodDescription> getters, List<MethodDescription> operations, List<MethodDescription> stateTransitions) {
        if (GETTER_ANNOTATIONS.contains(node.desc)) {
            getters.add(MethodDescription.of(classNode, methodNode));
        }
        if (OPERATION_ANNOTATIONS.contains(node.desc)) {
            operations.add(MethodDescription.of(classNode, methodNode));
        }
        if (STATE_TRANSITION_ANNOTATIONS.contains(node.desc)) {
            stateTransitions.add(MethodDescription.of(classNode, methodNode));
        }
    }

    private void parse(ClassNode classNode, FieldNode fieldNode, List<AutomatedFieldDescription> automatedFields) {
        List annotations = fieldNode.visibleAnnotations;
        annotations.stream().filter(node -> AUTOMATED_FIELD_ANNOTATIONS.contains(node.desc)).forEach(node -> automatedFields.add(AutomatedFieldDescription.of(classNode, fieldNode, node)));
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (this._allowedTypes.contains(className) && this._transformers.containsKey(className)) {
            LOGGER.info("Transforming {}", (Object)className);
            byte[] bytes = this._transformers.get(className).generate(classfileBuffer);
            LOGGER.info("{} transformed", (Object)className);
            return bytes;
        }
        return classfileBuffer;
    }
}

