/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.qpid.server.logging.LogMessage;
import org.slf4j.LoggerFactory;

public class TrustStoreMessages {
    private static final ResourceBundle MESSAGES;
    private static final Locale CURRENT_LOCALE;
    public static final String TRUSTSTORE_LOG_HIERARCHY = "qpid.message.truststore";
    public static final String CLOSE_LOG_HIERARCHY = "qpid.message.truststore.close";
    public static final String CREATE_LOG_HIERARCHY = "qpid.message.truststore.create";
    public static final String DELETE_LOG_HIERARCHY = "qpid.message.truststore.delete";
    public static final String EXPIRING_LOG_HIERARCHY = "qpid.message.truststore.expiring";
    public static final String OPEN_LOG_HIERARCHY = "qpid.message.truststore.open";
    public static final String OPERATION_LOG_HIERARCHY = "qpid.message.truststore.operation";
    public static final String UPDATE_LOG_HIERARCHY = "qpid.message.truststore.update";

    public static LogMessage CLOSE(String param1) {
        String rawMessage = MESSAGES.getString("CLOSE");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return TrustStoreMessages.CLOSE_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage CREATE(String param1, String param2, String param3) {
        String rawMessage = MESSAGES.getString("CREATE");
        Object[] messageArguments = new Object[]{param1, param2, param3};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return TrustStoreMessages.CREATE_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage DELETE(String param1, String param2) {
        String rawMessage = MESSAGES.getString("DELETE");
        Object[] messageArguments = new Object[]{param1, param2};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return TrustStoreMessages.DELETE_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage EXPIRING(String param1, String param2, String param3) {
        String rawMessage = MESSAGES.getString("EXPIRING");
        Object[] messageArguments = new Object[]{param1, param2, param3};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return TrustStoreMessages.EXPIRING_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage OPEN(String param1, String param2) {
        String rawMessage = MESSAGES.getString("OPEN");
        Object[] messageArguments = new Object[]{param1, param2};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return TrustStoreMessages.OPEN_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage OPERATION(String param1) {
        String rawMessage = MESSAGES.getString("OPERATION");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return TrustStoreMessages.OPERATION_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage UPDATE(String param1, String param2, String param3) {
        String rawMessage = MESSAGES.getString("UPDATE");
        Object[] messageArguments = new Object[]{param1, param2, param3};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return TrustStoreMessages.UPDATE_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    private TrustStoreMessages() {
    }

    static {
        Locale locale = Locale.US;
        String localeSetting = System.getProperty("qpid.broker_locale");
        if (localeSetting != null) {
            String[] localeParts = localeSetting.split("_");
            String language = localeParts.length > 0 ? localeParts[0] : "";
            String country = localeParts.length > 1 ? localeParts[1] : "";
            String variant = "";
            if (localeParts.length > 2) {
                variant = localeSetting.substring(language.length() + 1 + country.length() + 1);
            }
            locale = new Locale(language, country, variant);
        }
        CURRENT_LOCALE = locale;
        LoggerFactory.getLogger((String)TRUSTSTORE_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)CLOSE_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)CREATE_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)DELETE_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)EXPIRING_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)OPEN_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)OPERATION_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)UPDATE_LOG_HIERARCHY);
        MESSAGES = ResourceBundle.getBundle("org.apache.qpid.server.logging.messages.TrustStore_logmessages", CURRENT_LOCALE);
    }
}

