/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.preferences.Preference;
import org.apache.qpid.server.model.preferences.PreferenceFactory;
import org.apache.qpid.server.model.preferences.UserPreferencesImpl;
import org.apache.qpid.server.store.preferences.PreferenceRecord;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.store.preferences.PreferencesRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesRecoverer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreferencesRecoverer.class);
    private final TaskExecutor _executor;

    public PreferencesRecoverer(TaskExecutor executor) {
        this._executor = executor;
    }

    public void recoverPreferences(ConfiguredObject<?> parent, Collection<PreferenceRecord> preferenceRecords, PreferenceStore preferencesStore) {
        HashSet<UUID> corruptedRecords = new HashSet<UUID>();
        HashMap<UUID, Collection<PreferenceRecord>> objectToRecordMap = new HashMap<UUID, Collection<PreferenceRecord>>();
        for (PreferenceRecord preferenceRecord : preferenceRecords) {
            UUID associatedObjectId = this.getAssociatedObjectId(preferenceRecord.getAttributes());
            if (associatedObjectId == null) {
                LOGGER.info("Could not find associated object for preference : {}", (Object)preferenceRecord.getId());
                corruptedRecords.add(preferenceRecord.getId());
                continue;
            }
            HashSet<PreferenceRecord> objectPreferences = (HashSet<PreferenceRecord>)objectToRecordMap.get(associatedObjectId);
            if (objectPreferences == null) {
                objectPreferences = new HashSet<PreferenceRecord>();
                objectToRecordMap.put(associatedObjectId, objectPreferences);
            }
            objectPreferences.add(preferenceRecord);
        }
        this.setUserPreferences(parent, objectToRecordMap, preferencesStore, corruptedRecords);
        if (!objectToRecordMap.isEmpty()) {
            LOGGER.warn("Could not recover preferences associated with: {}", objectToRecordMap.keySet());
            for (Collection records : objectToRecordMap.values()) {
                for (PreferenceRecord record : records) {
                    corruptedRecords.add(record.getId());
                }
            }
        }
        if (!corruptedRecords.isEmpty()) {
            LOGGER.warn("Removing unrecoverable corrupted preferences: {}", corruptedRecords);
            preferencesStore.replace(corruptedRecords, Collections.emptySet());
        }
    }

    private void setUserPreferences(ConfiguredObject<?> associatedObject, Map<UUID, Collection<PreferenceRecord>> objectToRecordMap, PreferenceStore preferenceStore, Set<UUID> corruptedRecords) {
        Collection<PreferenceRecord> preferenceRecords = objectToRecordMap.remove(associatedObject.getId());
        ArrayList<Preference> recoveredPreferences = new ArrayList<Preference>();
        if (preferenceRecords != null) {
            for (PreferenceRecord preferenceRecord : preferenceRecords) {
                Map<String, Object> attributes = preferenceRecord.getAttributes();
                try {
                    Preference recoveredPreference = PreferenceFactory.fromAttributes(associatedObject, attributes);
                    this.validateRecoveredPreference(recoveredPreference);
                    recoveredPreferences.add(recoveredPreference);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.info(String.format("Cannot recover preference '%s/%s'", preferenceRecord.getId(), attributes.get("name")), (Throwable)e);
                    corruptedRecords.add(preferenceRecord.getId());
                }
            }
        }
        associatedObject.setUserPreferences(new UserPreferencesImpl(this._executor, associatedObject, preferenceStore, recoveredPreferences));
        if (!(associatedObject instanceof PreferencesRoot)) {
            Collection<Class<? extends ConfiguredObject>> childrenCategories = associatedObject.getModel().getChildTypes(associatedObject.getCategoryClass());
            for (Class<? extends ConfiguredObject> childCategory : childrenCategories) {
                Collection<? extends ConfiguredObject> children = associatedObject.getChildren(childCategory);
                for (ConfiguredObject configuredObject : children) {
                    this.setUserPreferences(configuredObject, objectToRecordMap, preferenceStore, corruptedRecords);
                }
            }
        }
    }

    private void validateRecoveredPreference(Preference recoveredPreference) {
        if (recoveredPreference.getId() == null) {
            throw new IllegalArgumentException("Recovered preference has no id");
        }
        if (recoveredPreference.getOwner() == null) {
            throw new IllegalArgumentException("Recovered preference has no owner");
        }
        if (recoveredPreference.getCreatedDate() == null) {
            throw new IllegalArgumentException("Recovered preference has no createdDate");
        }
        if (recoveredPreference.getLastUpdatedDate() == null) {
            throw new IllegalArgumentException("Recovered preference has no lastUpdatedDate");
        }
    }

    private UUID getAssociatedObjectId(Map<String, Object> preferenceRecordAttributes) {
        UUID associatedObjectId;
        if (preferenceRecordAttributes == null) {
            return null;
        }
        Object associatedObjectIdObject = preferenceRecordAttributes.get("associatedObject");
        if (associatedObjectIdObject == null || !(associatedObjectIdObject instanceof String)) {
            return null;
        }
        try {
            associatedObjectId = UUID.fromString((String)associatedObjectIdObject);
        }
        catch (Exception e) {
            return null;
        }
        return associatedObjectId;
    }
}

