/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.typedmessage;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.apache.qpid.server.typedmessage.TypedBytesCodes;
import org.apache.qpid.server.typedmessage.TypedBytesFormatException;

public class TypedBytesContentReader
implements TypedBytesCodes {
    private final ByteBuffer _data;
    private final int _position;
    private final int _limit;
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final CharsetDecoder _charsetDecoder = UTF8_CHARSET.newDecoder();
    private int _byteArrayRemaining = -1;

    public TypedBytesContentReader(ByteBuffer data) {
        this._data = data.duplicate();
        this._position = this._data.position();
        this._limit = this._data.limit();
    }

    public void checkAvailable(int len) throws EOFException {
        if (this._data.remaining() < len) {
            throw new EOFException("Unable to read " + len + " bytes");
        }
    }

    public byte readWireType() throws TypedBytesFormatException, EOFException {
        this.checkAvailable(1);
        return this._data.get();
    }

    public boolean readBoolean() throws EOFException, TypedBytesFormatException {
        int position = this._data.position();
        byte wireType = this.readWireType();
        try {
            boolean result;
            switch (wireType) {
                case 1: {
                    this.checkAvailable(1);
                    result = this.readBooleanImpl();
                    break;
                }
                case 10: {
                    this.checkAvailable(1);
                    result = Boolean.parseBoolean(this.readStringImpl());
                    break;
                }
                default: {
                    this._data.position(position);
                    throw new TypedBytesFormatException("Unable to convert " + wireType + " to a boolean");
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
    }

    public boolean readBooleanImpl() {
        return this._data.get() != 0;
    }

    public byte readByte() throws EOFException, TypedBytesFormatException {
        byte result;
        int position = this._data.position();
        byte wireType = this.readWireType();
        try {
            switch (wireType) {
                case 2: {
                    this.checkAvailable(1);
                    result = this.readByteImpl();
                    break;
                }
                case 10: {
                    this.checkAvailable(1);
                    result = Byte.parseByte(this.readStringImpl());
                    break;
                }
                default: {
                    this._data.position(position);
                    throw new TypedBytesFormatException("Unable to convert " + wireType + " to a byte");
                }
            }
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
        return result;
    }

    public byte readByteImpl() {
        return this._data.get();
    }

    public short readShort() throws EOFException, TypedBytesFormatException {
        short result;
        int position = this._data.position();
        byte wireType = this.readWireType();
        try {
            switch (wireType) {
                case 4: {
                    this.checkAvailable(2);
                    result = this.readShortImpl();
                    break;
                }
                case 10: {
                    this.checkAvailable(1);
                    result = Short.parseShort(this.readStringImpl());
                    break;
                }
                case 2: {
                    this.checkAvailable(1);
                    result = this.readByteImpl();
                    break;
                }
                default: {
                    this._data.position(position);
                    throw new TypedBytesFormatException("Unable to convert " + wireType + " to a short");
                }
            }
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
        return result;
    }

    public short readShortImpl() {
        return this._data.getShort();
    }

    public char readChar() throws EOFException, TypedBytesFormatException {
        int position = this._data.position();
        byte wireType = this.readWireType();
        try {
            if (wireType == 11) {
                throw new NullPointerException();
            }
            if (wireType != 5) {
                this._data.position(position);
                throw new TypedBytesFormatException("Unable to convert " + wireType + " to a char");
            }
            this.checkAvailable(2);
            return this.readCharImpl();
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
    }

    public char readCharImpl() {
        return this._data.getChar();
    }

    public int readInt() throws EOFException, TypedBytesFormatException {
        int position = this._data.position();
        byte wireType = this.readWireType();
        try {
            int result;
            switch (wireType) {
                case 6: {
                    this.checkAvailable(4);
                    result = this.readIntImpl();
                    break;
                }
                case 4: {
                    this.checkAvailable(2);
                    result = this.readShortImpl();
                    break;
                }
                case 10: {
                    this.checkAvailable(1);
                    result = Integer.parseInt(this.readStringImpl());
                    break;
                }
                case 2: {
                    this.checkAvailable(1);
                    result = this.readByteImpl();
                    break;
                }
                default: {
                    this._data.position(position);
                    throw new TypedBytesFormatException("Unable to convert " + wireType + " to an int");
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
    }

    public int readIntImpl() {
        return this._data.getInt();
    }

    public long readLong() throws EOFException, TypedBytesFormatException {
        int position = this._data.position();
        byte wireType = this.readWireType();
        try {
            long result;
            switch (wireType) {
                case 7: {
                    this.checkAvailable(8);
                    result = this.readLongImpl();
                    break;
                }
                case 6: {
                    this.checkAvailable(4);
                    result = this.readIntImpl();
                    break;
                }
                case 4: {
                    this.checkAvailable(2);
                    result = this.readShortImpl();
                    break;
                }
                case 10: {
                    this.checkAvailable(1);
                    result = Long.parseLong(this.readStringImpl());
                    break;
                }
                case 2: {
                    this.checkAvailable(1);
                    result = this.readByteImpl();
                    break;
                }
                default: {
                    this._data.position(position);
                    throw new TypedBytesFormatException("Unable to convert " + wireType + " to a long");
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
    }

    public long readLongImpl() {
        return this._data.getLong();
    }

    public float readFloat() throws EOFException, TypedBytesFormatException {
        int position = this._data.position();
        byte wireType = this.readWireType();
        try {
            float result;
            switch (wireType) {
                case 8: {
                    this.checkAvailable(4);
                    result = this.readFloatImpl();
                    break;
                }
                case 10: {
                    this.checkAvailable(1);
                    result = Float.parseFloat(this.readStringImpl());
                    break;
                }
                default: {
                    this._data.position(position);
                    throw new TypedBytesFormatException("Unable to convert " + wireType + " to a float");
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
    }

    public float readFloatImpl() {
        return this._data.getFloat();
    }

    public double readDouble() throws TypedBytesFormatException, EOFException {
        int position = this._data.position();
        byte wireType = this.readWireType();
        try {
            double result;
            switch (wireType) {
                case 9: {
                    this.checkAvailable(8);
                    result = this.readDoubleImpl();
                    break;
                }
                case 8: {
                    this.checkAvailable(4);
                    result = this.readFloatImpl();
                    break;
                }
                case 10: {
                    this.checkAvailable(1);
                    result = Double.parseDouble(this.readStringImpl());
                    break;
                }
                default: {
                    this._data.position(position);
                    throw new TypedBytesFormatException("Unable to convert " + wireType + " to a double");
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
    }

    public double readDoubleImpl() {
        return this._data.getDouble();
    }

    public String readString() throws EOFException, TypedBytesFormatException {
        int position = this._data.position();
        byte wireType = this.readWireType();
        try {
            String result;
            switch (wireType) {
                case 10: {
                    this.checkAvailable(1);
                    result = this.readStringImpl();
                    break;
                }
                case 11: {
                    Object result2 = null;
                    throw new NullPointerException("data is null");
                }
                case 1: {
                    this.checkAvailable(1);
                    result = String.valueOf(this.readBooleanImpl());
                    break;
                }
                case 7: {
                    this.checkAvailable(8);
                    result = String.valueOf(this.readLongImpl());
                    break;
                }
                case 6: {
                    this.checkAvailable(4);
                    result = String.valueOf(this.readIntImpl());
                    break;
                }
                case 4: {
                    this.checkAvailable(2);
                    result = String.valueOf(this.readShortImpl());
                    break;
                }
                case 2: {
                    this.checkAvailable(1);
                    result = String.valueOf(this.readByteImpl());
                    break;
                }
                case 8: {
                    this.checkAvailable(4);
                    result = String.valueOf(this.readFloatImpl());
                    break;
                }
                case 9: {
                    this.checkAvailable(8);
                    result = String.valueOf(this.readDoubleImpl());
                    break;
                }
                case 5: {
                    this.checkAvailable(2);
                    result = String.valueOf(this.readCharImpl());
                    break;
                }
                default: {
                    this._data.position(position);
                    throw new TypedBytesFormatException("Unable to convert " + wireType + " to a String");
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
    }

    public String readStringImpl() throws TypedBytesFormatException {
        try {
            byte b;
            this._charsetDecoder.reset();
            ByteBuffer dup = this._data.duplicate();
            int pos = this._data.position();
            while ((b = this._data.get()) != 0) {
            }
            dup.limit(this._data.position() - 1);
            return this._charsetDecoder.decode(dup).toString();
        }
        catch (CharacterCodingException e) {
            TypedBytesFormatException jmse = new TypedBytesFormatException("Error decoding byte stream as a UTF8 string: " + e);
            jmse.initCause(e);
            throw jmse;
        }
    }

    public int readBytes(byte[] bytes) throws EOFException, TypedBytesFormatException {
        if (bytes == null) {
            throw new IllegalArgumentException("byte array must not be null");
        }
        if (this._byteArrayRemaining == -1) {
            this.checkAvailable(1);
            byte wireType = this.readWireType();
            if (wireType != 3) {
                throw new TypedBytesFormatException("Unable to convert " + wireType + " to a byte array");
            }
            this.checkAvailable(4);
            int size = this._data.getInt();
            if (size == -1) {
                return -1;
            }
            if (size > this._data.remaining()) {
                throw new EOFException("Byte array has stated length " + size + " but message only contains " + this._data.remaining() + " bytes");
            }
            this._byteArrayRemaining = size;
        } else if (this._byteArrayRemaining == 0) {
            this._byteArrayRemaining = -1;
            return -1;
        }
        int returnedSize = this.readBytesImpl(bytes);
        if (returnedSize < bytes.length) {
            this._byteArrayRemaining = -1;
        }
        return returnedSize;
    }

    private int readBytesImpl(byte[] bytes) {
        int count = this._byteArrayRemaining >= bytes.length ? bytes.length : this._byteArrayRemaining;
        this._byteArrayRemaining -= count;
        if (count == 0) {
            return 0;
        }
        this._data.get(bytes, 0, count);
        return count;
    }

    public Object readObject() throws EOFException, TypedBytesFormatException {
        int position = this._data.position();
        byte wireType = this.readWireType();
        Object result = null;
        try {
            switch (wireType) {
                case 1: {
                    this.checkAvailable(1);
                    result = this.readBooleanImpl();
                    break;
                }
                case 2: {
                    this.checkAvailable(1);
                    result = this.readByteImpl();
                    break;
                }
                case 3: {
                    this.checkAvailable(4);
                    int size = this._data.getInt();
                    if (size == -1) {
                        result = null;
                        break;
                    }
                    this._byteArrayRemaining = size;
                    byte[] bytesResult = new byte[size];
                    this.readBytesImpl(bytesResult);
                    result = bytesResult;
                    break;
                }
                case 4: {
                    this.checkAvailable(2);
                    result = this.readShortImpl();
                    break;
                }
                case 5: {
                    this.checkAvailable(2);
                    result = Character.valueOf(this.readCharImpl());
                    break;
                }
                case 6: {
                    this.checkAvailable(4);
                    result = this.readIntImpl();
                    break;
                }
                case 7: {
                    this.checkAvailable(8);
                    result = this.readLongImpl();
                    break;
                }
                case 8: {
                    this.checkAvailable(4);
                    result = Float.valueOf(this.readFloatImpl());
                    break;
                }
                case 9: {
                    this.checkAvailable(8);
                    result = this.readDoubleImpl();
                    break;
                }
                case 11: {
                    result = null;
                    break;
                }
                case 10: {
                    this.checkAvailable(1);
                    result = this.readStringImpl();
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            this._data.position(position);
            throw e;
        }
    }

    public void reset() {
        this._byteArrayRemaining = -1;
        this._data.position(this._position);
        this._data.limit(this._limit);
    }

    public ByteBuffer getData() {
        ByteBuffer buf = this._data.duplicate();
        buf.position(this._position);
        buf.limit(this._limit);
        return buf;
    }

    public long size() {
        return this._limit - this._position;
    }

    public int remaining() {
        return this._data.remaining();
    }

    public void readRawBytes(byte[] bytes, int offset, int count) {
        this._data.get(bytes, offset, count);
    }

    public String readLengthPrefixedUTF() throws TypedBytesFormatException {
        try {
            short length = this.readShortImpl();
            if (length == 0) {
                return "";
            }
            this._charsetDecoder.reset();
            ByteBuffer encodedString = this._data.slice();
            encodedString.limit(length);
            this._data.position(this._data.position() + length);
            CharBuffer string = this._charsetDecoder.decode(encodedString);
            return string.toString();
        }
        catch (CharacterCodingException e) {
            TypedBytesFormatException jmse = new TypedBytesFormatException("Error decoding byte stream as a UTF8 string: " + e);
            jmse.initCause(e);
            throw jmse;
        }
    }
}

