/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution;

import jetbrains.exodus.core.execution.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JobHandler {
    public abstract void handle(Job var1);

    @NotNull
    static JobHandler[] append(@Nullable JobHandler[] handlers, @NotNull JobHandler handle) {
        int size = handlers == null ? 0 : handlers.length;
        JobHandler[] result = new JobHandler[size + 1];
        if (size > 0) {
            System.arraycopy(handlers, 0, result, 0, size);
        }
        result[size] = handle;
        return result;
    }

    static JobHandler[] remove(@Nullable JobHandler[] handlers, JobHandler handle) {
        int size;
        int n = size = handlers == null ? 0 : handlers.length;
        if (size <= 1) {
            return null;
        }
        JobHandler[] result = new JobHandler[size - 1];
        for (int i = 0; i < size; ++i) {
            JobHandler handler = handlers[i];
            if (handler == handle) {
                handle = null;
                ++i;
                continue;
            }
            result[i] = handle;
        }
        return result;
    }

    static void invokeHandlers(@Nullable JobHandler[] handlers, @NotNull Job job) {
        if (handlers != null) {
            for (JobHandler handler : handlers) {
                handler.handle(job);
            }
        }
    }
}

