/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServlet;
import org.apache.commons.collections4.map.HashedMap;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.registration.memory.InMemoryRegistry;
import org.eclipse.basyx.components.IComponent;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxContextConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxMqttConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxSQLConfiguration;
import org.eclipse.basyx.components.configuration.BaSyxSecurityConfiguration;
import org.eclipse.basyx.components.registry.authorization.internal.AuthorizedAASRegistryFeatureFactory;
import org.eclipse.basyx.components.registry.configuration.BaSyxRegistryConfiguration;
import org.eclipse.basyx.components.registry.configuration.RegistryBackend;
import org.eclipse.basyx.components.registry.configuration.RegistryEventBackend;
import org.eclipse.basyx.components.registry.mongodb.MongoDBRegistry;
import org.eclipse.basyx.components.registry.mongodb.MongoDBTaggedDirectory;
import org.eclipse.basyx.components.registry.mqtt.MqttRegistryFactory;
import org.eclipse.basyx.components.registry.mqtt.MqttTaggedDirectoryFactory;
import org.eclipse.basyx.components.registry.mqtt.MqttV2RegistryFactory;
import org.eclipse.basyx.components.registry.mqtt.MqttV2TaggedDirectoryFactory;
import org.eclipse.basyx.components.registry.servlet.RegistryServlet;
import org.eclipse.basyx.components.registry.servlet.TaggedDirectoryServlet;
import org.eclipse.basyx.components.registry.sql.SQLRegistry;
import org.eclipse.basyx.components.security.authorization.internal.AuthorizationDynamicClassLoader;
import org.eclipse.basyx.components.security.authorization.internal.IJwtBearerTokenAuthenticationConfigurationProvider;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.IAASTaggedDirectory;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedAASDescriptor;
import org.eclipse.basyx.extensions.aas.directory.tagged.map.MapTaggedDirectory;
import org.eclipse.basyx.extensions.shared.encoding.Base64URLEncoder;
import org.eclipse.basyx.extensions.shared.encoding.IEncoder;
import org.eclipse.basyx.extensions.shared.encoding.URLEncoder;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxContext;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxHTTPServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryComponent
implements IComponent {
    private static Logger logger = LoggerFactory.getLogger(RegistryComponent.class);
    private BaSyxHTTPServer server;
    private BaSyxContextConfiguration contextConfig;
    private BaSyxRegistryConfiguration registryConfig;
    private BaSyxMongoDBConfiguration mongoDBConfig;
    private BaSyxSQLConfiguration sqlConfig;
    private BaSyxMqttConfiguration mqttConfig;
    private BaSyxSecurityConfiguration securityConfig;

    public RegistryComponent() {
        this.contextConfig = new BaSyxContextConfiguration();
        this.registryConfig = new BaSyxRegistryConfiguration();
    }

    public RegistryComponent(BaSyxContextConfiguration contextConfig) {
        this.contextConfig = contextConfig;
        this.registryConfig = new BaSyxRegistryConfiguration(RegistryBackend.INMEMORY);
    }

    public RegistryComponent(BaSyxContextConfiguration contextConfig, BaSyxMongoDBConfiguration mongoDBConfig) {
        this.contextConfig = contextConfig;
        this.registryConfig = new BaSyxRegistryConfiguration(RegistryBackend.MONGODB);
        this.mongoDBConfig = mongoDBConfig;
    }

    public RegistryComponent(BaSyxContextConfiguration contextConfig, BaSyxRegistryConfiguration registryConfig, BaSyxMongoDBConfiguration mongoDBConfig) {
        this.contextConfig = contextConfig;
        this.registryConfig = registryConfig;
        this.mongoDBConfig = mongoDBConfig;
    }

    public RegistryComponent(BaSyxContextConfiguration contextConfig, BaSyxSQLConfiguration sqlConfig) {
        this.contextConfig = contextConfig;
        this.registryConfig = new BaSyxRegistryConfiguration(RegistryBackend.SQL);
        this.sqlConfig = sqlConfig;
    }

    public RegistryComponent(BaSyxContextConfiguration contextConfig, BaSyxRegistryConfiguration registryConfig, BaSyxSQLConfiguration sqlConfig) {
        this.contextConfig = contextConfig;
        this.registryConfig = registryConfig;
        this.sqlConfig = sqlConfig;
    }

    public RegistryComponent(BaSyxContextConfiguration contextConfig, BaSyxRegistryConfiguration registryConfig) {
        this.contextConfig = contextConfig;
        this.registryConfig = registryConfig;
    }

    public void setSecurityConfiguration(BaSyxSecurityConfiguration configuration) {
        this.securityConfig = configuration;
    }

    public void startComponent() {
        this.configureSecurity();
        BaSyxContext context = this.contextConfig.createBaSyxContext();
        context.addServletMapping("/*", this.createRegistryServlet());
        if (this.registryConfig.isAuthorizationEnabled()) {
            this.configureContextForAuthorization(context);
        }
        this.server = new BaSyxHTTPServer(context);
        this.server.start();
        logger.info("Registry server started");
    }

    public void enableMQTT(BaSyxMqttConfiguration configuration) {
        this.mqttConfig = configuration;
    }

    public void disableMQTT() {
        this.mqttConfig = null;
    }

    private BaSyxSQLConfiguration loadSQLConfiguration() {
        BaSyxSQLConfiguration config;
        if (this.sqlConfig == null) {
            config = new BaSyxSQLConfiguration();
            config.loadFromDefaultSource();
        } else {
            config = this.sqlConfig;
        }
        return config;
    }

    private BaSyxMongoDBConfiguration loadMongoDBConfiguration() {
        BaSyxMongoDBConfiguration config;
        if (this.mongoDBConfig == null) {
            config = new BaSyxMongoDBConfiguration();
            config.loadFromDefaultSource();
        } else {
            config = this.mongoDBConfig;
        }
        return config;
    }

    private HttpServlet createRegistryServlet() {
        if (this.registryConfig.isTaggedDirectoryEnabled()) {
            return this.createTaggedRegistryServlet();
        }
        IAASRegistry registryBackend = this.createRegistryBackend();
        IAASRegistry decoratedRegistry = this.decorate(registryBackend);
        return new RegistryServlet(decoratedRegistry);
    }

    private HttpServlet createTaggedRegistryServlet() {
        this.throwRuntimeExceptionIfConfigurationIsNotSuitableForTaggedDirectory();
        logger.info("Enable tagged directory functionality");
        MongoDBTaggedDirectory taggedDirectory = this.registryConfig.getRegistryBackend().equals((Object)RegistryBackend.MONGODB) ? new MongoDBTaggedDirectory(this.loadMongoDBConfiguration(), new HashMap<String, Set<TaggedAASDescriptor>>()) : new MapTaggedDirectory((Map)new HashedMap(), (Map)new HashedMap());
        IAASTaggedDirectory decoratedDirectory = this.decorateTaggedDirectory((IAASTaggedDirectory)taggedDirectory);
        return new TaggedDirectoryServlet(decoratedDirectory);
    }

    private IAASTaggedDirectory decorateTaggedDirectory(IAASTaggedDirectory taggedDirectory) {
        IAASTaggedDirectory decoratedTaggedDirectory = taggedDirectory;
        if (this.isMQTTEnabled()) {
            decoratedTaggedDirectory = this.configureMqttTagged(decoratedTaggedDirectory);
        }
        if (this.registryConfig.isAuthorizationEnabled()) {
            decoratedTaggedDirectory = this.decorateWithAuthorization(decoratedTaggedDirectory);
        }
        return decoratedTaggedDirectory;
    }

    private IAASTaggedDirectory configureMqttTagged(IAASTaggedDirectory decoratedTaggedDirectory) {
        if (this.mqttConfig == null) {
            this.mqttConfig = new BaSyxMqttConfiguration();
            this.mqttConfig.loadFromDefaultSource();
        }
        logger.info("Enable MQTT events for broker " + this.mqttConfig.getServer());
        if (this.registryConfig.getRegistryEvents().equals((Object)RegistryEventBackend.MQTT)) {
            decoratedTaggedDirectory = new MqttTaggedDirectoryFactory().create(decoratedTaggedDirectory, this.mqttConfig);
            logger.info("MQTT event backend for " + this.registryConfig.getRegistryId());
        } else if (this.registryConfig.getRegistryEvents().equals((Object)RegistryEventBackend.MQTTV2)) {
            decoratedTaggedDirectory = new MqttV2TaggedDirectoryFactory().create(decoratedTaggedDirectory, this.mqttConfig, this.registryConfig, (IEncoder)new Base64URLEncoder());
            logger.info("MQTTV2 event backend for " + this.registryConfig.getRegistryId());
        } else if (this.registryConfig.getRegistryEvents().equals((Object)RegistryEventBackend.MQTTV2_SIMPLE_ENCODING)) {
            logger.info("MQTTV2_SIMPLE_ENCODING event backend for " + this.registryConfig.getRegistryId());
            decoratedTaggedDirectory = new MqttV2TaggedDirectoryFactory().create(decoratedTaggedDirectory, this.mqttConfig, this.registryConfig, (IEncoder)new URLEncoder());
        }
        return decoratedTaggedDirectory;
    }

    private void throwRuntimeExceptionIfConfigurationIsNotSuitableForTaggedDirectory() {
        if (!this.isConfigurationSuitableForTaggedDirectory()) {
            throw new RuntimeException("The current version does not support this configuration.\n\t* Persistent backend SQL\nis currently not supported in combination with tagged directory functionality.");
        }
    }

    private IAASRegistry createRegistryBackend() {
        RegistryBackend backendType = this.registryConfig.getRegistryBackend();
        switch (backendType) {
            case MONGODB: {
                return this.createMongoDBRegistryBackend();
            }
            case SQL: {
                return this.createSQLRegistryBackend();
            }
            case INMEMORY: {
                return this.createInMemoryRegistryBackend();
            }
        }
        throw new RuntimeException("Unknown backend type " + backendType);
    }

    private IAASRegistry createInMemoryRegistryBackend() {
        logger.info("Creating InMemoryRegistry");
        return new InMemoryRegistry();
    }

    private IAASRegistry createSQLRegistryBackend() {
        logger.info("Creating SQLRegistry");
        BaSyxSQLConfiguration sqlConfiguration = this.loadSQLConfiguration();
        return new SQLRegistry(sqlConfiguration);
    }

    private IAASRegistry createMongoDBRegistryBackend() {
        logger.info("Creating MongoDBRegistry");
        BaSyxMongoDBConfiguration mongoDBConfiguration = this.loadMongoDBConfiguration();
        return new MongoDBRegistry(mongoDBConfiguration);
    }

    private IAASRegistry decorate(IAASRegistry aasRegistry) {
        IAASRegistry decoratedRegistry = aasRegistry;
        if (this.isMQTTEnabled()) {
            decoratedRegistry = this.configureMqtt(decoratedRegistry);
        }
        if (this.registryConfig.isAuthorizationEnabled()) {
            decoratedRegistry = this.decorateWithAuthorization(decoratedRegistry);
        }
        return decoratedRegistry;
    }

    private void configureContextForAuthorization(BaSyxContext context) {
        IJwtBearerTokenAuthenticationConfigurationProvider jwtBearerTokenAuthenticationConfigurationProvider = this.getJwtBearerTokenAuthenticationConfigurationProvider();
        if (jwtBearerTokenAuthenticationConfigurationProvider != null) {
            context.setJwtBearerTokenAuthenticationConfiguration(jwtBearerTokenAuthenticationConfigurationProvider.get(this.securityConfig));
        }
    }

    private IJwtBearerTokenAuthenticationConfigurationProvider getJwtBearerTokenAuthenticationConfigurationProvider() {
        if (this.securityConfig.getAuthorizationStrategyJwtBearerTokenAuthenticationConfigurationProvider() == null) {
            return null;
        }
        return (IJwtBearerTokenAuthenticationConfigurationProvider)AuthorizationDynamicClassLoader.loadInstanceDynamically((BaSyxConfiguration)this.securityConfig, (String)"authorization.strategy.jwtBearerTokenAuthenticationConfigurationProvider", IJwtBearerTokenAuthenticationConfigurationProvider.class);
    }

    private IAASRegistry decorateWithAuthorization(IAASRegistry registry) {
        logger.info("Enable Authorization for Registry");
        return new AuthorizedAASRegistryFeatureFactory(this.securityConfig).create().getAASRegistryDecorator().decorate(registry);
    }

    private IAASTaggedDirectory decorateWithAuthorization(IAASTaggedDirectory taggedDirectory) {
        logger.info("Enable Authorization for TaggedDirectory");
        return new AuthorizedAASRegistryFeatureFactory(this.securityConfig).create().getTaggedDirectoryDecorator().decorate(taggedDirectory);
    }

    private IAASRegistry configureMqtt(IAASRegistry decoratedRegistry) {
        if (this.mqttConfig == null) {
            this.mqttConfig = new BaSyxMqttConfiguration();
            this.mqttConfig.loadFromDefaultSource();
        }
        logger.info("Enable MQTT events for broker " + this.mqttConfig.getServer());
        if (this.registryConfig.getRegistryEvents().equals((Object)RegistryEventBackend.MQTT)) {
            decoratedRegistry = new MqttRegistryFactory().create(decoratedRegistry, this.mqttConfig);
            logger.info("MQTT event backend for " + this.registryConfig.getRegistryId());
        } else if (this.registryConfig.getRegistryEvents().equals((Object)RegistryEventBackend.MQTTV2)) {
            decoratedRegistry = new MqttV2RegistryFactory().create(decoratedRegistry, this.mqttConfig, this.registryConfig, (IEncoder)new Base64URLEncoder());
            logger.info("MQTTV2 event backend for " + this.registryConfig.getRegistryId());
        } else if (this.registryConfig.getRegistryEvents().equals((Object)RegistryEventBackend.MQTTV2_SIMPLE_ENCODING)) {
            logger.info("MQTTV2_SIMPLE_ENCODING event backend for " + this.registryConfig.getRegistryId());
            decoratedRegistry = new MqttV2RegistryFactory().create(decoratedRegistry, this.mqttConfig, this.registryConfig, (IEncoder)new URLEncoder());
        }
        return decoratedRegistry;
    }

    private boolean isMQTTEnabled() {
        return !this.registryConfig.getRegistryEvents().equals((Object)RegistryEventBackend.NONE);
    }

    private boolean isConfigurationSuitableForTaggedDirectory() {
        return !this.registryConfig.getRegistryBackend().equals((Object)RegistryBackend.SQL);
    }

    private void configureSecurity() {
        if (!this.registryConfig.isAuthorizationEnabled()) {
            return;
        }
        if (this.securityConfig == null) {
            this.securityConfig = new BaSyxSecurityConfiguration();
            this.securityConfig.loadFromDefaultSource();
        }
    }

    public void stopComponent() {
        this.server.shutdown();
        logger.info("Registry server stopped");
    }
}

